/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.security;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.thread.ThreadContext;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.interfaces.security.resource.ResourceHandle;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.security.CodeBasedSecurityConnector;
import com.sap.engine.services.keystore.impl.security.SecurityConnector;
import com.sap.engine.services.keystore.impl.security.UBSDriver;
import com.sap.engine.services.keystore.interfaces.KeyStoreConstants;
import com.sap.engine.services.keystore.server.KeyStoreServiceFrame;
import java.security.KeyStoreException;

public class UserBasedSecurityConnector
implements SecurityConnector {
    public static final String[] SEPARATORS = new String[]{"\"", "$", "{", "}", ":", " ", "*"};
    private static SecurityContext securityContext = null;
    private static final String ALL_ACTIONS = "ALL";
    private static final String ALL_INSTANCES = "ALL";
    static UserBasedSecurityConnector connector = null;
    private static final int ITERATIONS = 100;
    private static ConfigurationHandlerFactory configurationHandlerFactory = null;
    public static final String ALL_ITEMS = "*";
    private static final String UB_CONNECTOR_NOT_INITIALIZED = "UB_CONNECTOR_NOT_INITIALIZED";
    private static final String VIEW_SYSTEM_SECURITY_NOT_CREATED = "VIEW_SYSTEM_SECURITY_NOT_CREATED";
    private static final String VIEW_SYSTEM_SECURITY_NOT_REMOVED = "VIEW_SYSTEM_SECURITY_NOT_REMOVED";
    private static final String ENTRY_SYSTEM_SECURITY_NOT_CREATED = "ENTRY_SYSTEM_SECURITY_NOT_CREATED";
    private static final String ENTRY_SYSTEM_SECURITY_NOT_REMOVED = "ENTRY_SYSTEM_SECURITY_NOT_REMOVED";
    private static final String ENTRY_SYSTEM_SECURITY_SUPPORT_NOT_RENAMED = "ENTRY_SYSTEM_SECURITY_SUPPORT_NOT_RENAMED";
    private static final String CANNOT_GET_CFG_HANDLER = "CANNOT_GET_CFG_HANDLER";
    private static final String CONFIGURATION_COMMIT_FAILED = "CONFIGURATION_COMMIT_FAILED";
    private static final String CONFIGURATION_CLOSE_FAILED = "CONFIGURATION_CLOSE_FAILED";
    static /* synthetic */ Class class$com$sap$engine$services$keystore$impl$security$UserBasedSecurityConnector;

    public static synchronized void setSecurityContext(SecurityContext context, ConfigurationHandlerFactory handlerFactory, boolean isEmptyDB) throws Exception {
        configurationHandlerFactory = handlerFactory;
        securityContext = context;
        if (isEmptyDB) {
            KeystoreResourceAccessor.trace(300, "   empty DB configuration found ");
            UserBasedSecurityConnector.init();
        } else {
            KeystoreResourceAccessor.trace(300, "   DB already initialized ");
        }
        KeystoreResourceAccessor.trace(300, "   UserBasedSecurityConnector started ...");
    }

    public static synchronized UserBasedSecurityConnector getConnector() {
        if (securityContext == null) {
            throw new RuntimeException("UserBasedSecurityConnector not initialized!");
        }
        if (connector == null) {
            connector = new UserBasedSecurityConnector();
        }
        return connector;
    }

    private UserBasedSecurityConnector() {
    }

    private static void init() throws Exception {
        SecurityContext rootContext = null;
        ResourceContext rootResources = null;
        SecurityRoleContext rootRoles = null;
        try {
            rootContext = securityContext;
            rootResources = rootContext.getAuthorizationContext().getSecurityResourceContext();
            rootRoles = rootContext.getAuthorizationContext().getSecurityRoleContext();
            ResourceAccessControlHandle controlHandle = null;
            SecurityRole administrator = UBSDriver.addSecurityRole(rootRoles, "KeystoreAdministrator");
            SecurityRole systemAdministrators = UBSDriver.getSecurityRole(rootRoles, "administrators");
            String[] adminGroups = systemAdministrators.getGroups();
            String[] adminUsers = systemAdministrators.getUsers();
            int i = 0;
            while (i < adminGroups.length) {
                UBSDriver.addGroup(administrator, adminGroups[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < adminUsers.length) {
                UBSDriver.addUser(administrator, adminUsers[i2]);
                ++i2;
            }
            UBSDriver.setRollDescription(administrator, "Keystore provider system role - the users from this role have all user based security permissions!");
            SecurityRole viewCreator = UBSDriver.addSecurityRole(rootRoles, "KeystoreViewsCreator");
            int i3 = 0;
            while (i3 < adminGroups.length) {
                UBSDriver.addGroup(viewCreator, adminGroups[i3]);
                ++i3;
            }
            int i4 = 0;
            while (i4 < adminUsers.length) {
                UBSDriver.addUser(viewCreator, adminUsers[i4]);
                ++i4;
            }
            UBSDriver.setRollDescription(viewCreator, "Keystore provider system role - the users from this role have user based security permission to create a new views!");
            KeystoreResourceAccessor.trace(300, "begin initialization of SecurityConector resources..");
            UBSDriver.createResource(rootResources, "keystore-views");
            controlHandle = rootResources.getResourceAccessControlHandle("keystore-views");
            UBSDriver.grantSecurityRole(controlHandle, administrator.getName(), "ALL", "ALL");
            UBSDriver.grantSecurityRole(controlHandle, "administrators", "ALL", "ALL");
            UBSDriver.grantSecurityRole(controlHandle, "KeystoreViewsCreator", "ALL", "ALL");
            KeystoreResourceAccessor.trace(300, " initialization of system resources finished..");
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(600, e, UB_CONNECTOR_NOT_INITIALIZED);
            KeystoreResourceAccessor.traceThrowable(600, UB_CONNECTOR_NOT_INITIALIZED, null, e);
            throw e;
        }
    }

    public synchronized void checkPermissions_createView() throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            ResourceAccessControlHandle viewControlHandle = UserBasedSecurityConnector.getKeystoreControlHandle();
            viewControlHandle.checkPermission("ALL", "ALL");
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed("(thread: " + Thread.currentThread().getName() + ",user: " + currentUser + ") - checkPermissions 'createView': " + e);
        }
    }

    public synchronized void createViewPermission(String alias) throws Exception {
    }

    public synchronized void createViewPermission(String currentUser, String alias) throws Exception {
        SecurityContext viewSecurityContext = null;
        ModificationContext m = null;
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        String viewPolicyConfigurationAlias = UserBasedSecurityConnector.createCompoundName("keystore-view", alias);
        try {
            handler = UserBasedSecurityConnector.getHandler();
            rootCfg = UserBasedSecurityConnector.ensureViewPolicyConfiguration(handler, alias);
            try {
                m = securityContext.getModificationContext();
                viewSecurityContext = m.beginModifications(rootCfg);
                viewSecurityContext.registerPolicyConfiguration(viewPolicyConfigurationAlias);
                viewSecurityContext = viewSecurityContext.getPolicyConfigurationContext(viewPolicyConfigurationAlias);
                ResourceContext viewResourceContext = viewSecurityContext.getAuthorizationContext().getSecurityResourceContext();
                SecurityRoleContext viewRoleContext = viewSecurityContext.getAuthorizationContext().getSecurityRoleContext();
                UBSDriver.createResource(viewResourceContext, "view-actions");
                ResourceHandle viewResource = viewResourceContext.getResourceHandle("view-actions");
                int i = 0;
                while (i < KeyStoreConstants.RESOURCE_VIEW_ACTIONS.length) {
                    UBSDriver.createAction(viewResource, KeyStoreConstants.RESOURCE_VIEW_ACTIONS[i]);
                    ++i;
                }
                UBSDriver.createResource(viewResourceContext, "property-actions");
                ResourceHandle propertiesResource = viewResourceContext.getResourceHandle("property-actions");
                int i2 = 0;
                while (i2 < KeyStoreConstants.RESOURCE_PROPERTIES_ACTIONS.length) {
                    UBSDriver.createAction(propertiesResource, KeyStoreConstants.RESOURCE_PROPERTIES_ACTIONS[i2]);
                    ++i2;
                }
                UBSDriver.createResource(viewResourceContext, "entry-actions");
                ResourceHandle entriesResource = viewResourceContext.getResourceHandle("entry-actions");
                int i3 = 0;
                while (i3 < KeyStoreConstants.RESOURCE_ENTRY_ACTIONS.length) {
                    UBSDriver.createAction(entriesResource, KeyStoreConstants.RESOURCE_ENTRY_ACTIONS[i3]);
                    ++i3;
                }
                SecurityRole creator = UBSDriver.addSecurityRole(viewRoleContext, "view-creator");
                SecurityRole administrator = UBSDriver.addSecurityRoleReference(viewRoleContext, "KeystoreAdministrator", "SAP-J2EE-Engine", "KeystoreAdministrator");
                SecurityRole referenced_administrators = UBSDriver.addSecurityRoleReference(viewRoleContext, "ReferenceAdministrators", "SAP-J2EE-Engine", "administrators");
                if (currentUser != null) {
                    UBSDriver.addUser(creator, currentUser);
                }
                ResourceAccessControlHandle viewControlHandle = viewResourceContext.getResourceAccessControlHandle("view-actions");
                ResourceAccessControlHandle propertiesControlHandle = viewResourceContext.getResourceAccessControlHandle("property-actions");
                ResourceAccessControlHandle entriesControlHandle = viewResourceContext.getResourceAccessControlHandle("entry-actions");
                UBSDriver.grantSecurityRole(viewControlHandle, creator.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(propertiesControlHandle, creator.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(entriesControlHandle, creator.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(viewControlHandle, administrator.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(propertiesControlHandle, administrator.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(entriesControlHandle, administrator.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(viewControlHandle, referenced_administrators.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(propertiesControlHandle, referenced_administrators.getName(), "ALL", "ALL");
                UBSDriver.grantSecurityRole(entriesControlHandle, referenced_administrators.getName(), "ALL", "ALL");
                UserBasedSecurityConnector.commit(handler);
                KeystoreResourceAccessor.trace(300, UserBasedSecurityConnector.g(alias) + " view permission created..");
            }
            catch (Exception e) {
                KeystoreResourceAccessor.log(600, e, VIEW_SYSTEM_SECURITY_NOT_CREATED, new Object[]{currentUser, alias});
                KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.g(alias) + " - create view permissions failed: ", e);
                throw e;
            }
            Object var23_23 = null;
        }
        catch (Throwable throwable) {
            Object var23_24 = null;
            UserBasedSecurityConnector.close(handler);
            throw throwable;
        }
        UserBasedSecurityConnector.close(handler);
    }

    public void checkPermissions_removeView(String alias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(alias), "DESTROY_VIEW", "ALL");
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(alias) + " - checkPermissions 'removeView': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void removeViewPermission(String alias) throws Exception {
        try {
            String view_policy_context_name = UserBasedSecurityConnector.createCompoundName("keystore-view", alias);
            securityContext.unregisterPolicyConfiguration(view_policy_context_name);
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(600, e, VIEW_SYSTEM_SECURITY_NOT_REMOVED, new Object[]{alias});
            KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.g(alias) + " - view permissions not removed: ", e);
            throw e;
        }
    }

    public void checkPermissions_createEntry(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "CREATE_ENTRY_AT_VIEW", "ALL");
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias) + " checkProllbackModification();ermissions - 'createEntry': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void createEntryPermission(String viewAlias, String entryAlias) throws Exception {
    }

    public void createEntryPermission(String currentUser, String viewAlias, String entryAlias) throws Exception {
        SecurityContext viewSecurityContext = null;
        ModificationContext m = null;
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        String viewPolicyConfigurationAlias = UserBasedSecurityConnector.createCompoundName("keystore-view", viewAlias);
        try {
            handler = UserBasedSecurityConnector.getHandler();
            rootCfg = UserBasedSecurityConnector.ensureViewPolicyConfiguration(handler, viewAlias);
            try {
                SecurityRole referenced_administrators;
                m = securityContext.getModificationContext();
                viewSecurityContext = m.beginModifications(rootCfg);
                viewSecurityContext = viewSecurityContext.getPolicyConfigurationContext(viewPolicyConfigurationAlias);
                ResourceContext viewResourceContext = viewSecurityContext.getAuthorizationContext().getSecurityResourceContext();
                SecurityRoleContext viewRoleContext = viewSecurityContext.getAuthorizationContext().getSecurityRoleContext();
                ResourceHandle entriesResource = null;
                ResourceAccessControlHandle entriesAccessControl = null;
                entriesResource = viewResourceContext.getResourceHandle("entry-actions");
                if (entriesResource == null) {
                    throw new KeyStoreException("There is no entry resource [" + viewAlias + ", " + entryAlias + "]!");
                }
                UBSDriver.createInstance(entriesResource, entryAlias);
                entriesAccessControl = viewResourceContext.getResourceAccessControlHandle("entry-actions");
                String roleName = UserBasedSecurityConnector.createCompoundName("entry-creator", entryAlias);
                SecurityRole entryCreator = UBSDriver.addSecurityRole(viewRoleContext, roleName);
                SecurityRole administrator = UBSDriver.getSecurityRole(viewRoleContext, "KeystoreAdministrator");
                if (administrator == null) {
                    administrator = UBSDriver.addSecurityRoleReference(viewRoleContext, "KeystoreAdministrator", "SAP-J2EE-Engine", "KeystoreAdministrator");
                }
                if ((referenced_administrators = UBSDriver.getSecurityRole(viewRoleContext, "ReferenceAdministrators")) == null) {
                    referenced_administrators = UBSDriver.addSecurityRoleReference(viewRoleContext, "ReferenceAdministrators", "SAP-J2EE-Engine", "administrators");
                }
                if (currentUser != null) {
                    UBSDriver.addUser(entryCreator, currentUser);
                }
                UBSDriver.grantSecurityRole(entriesAccessControl, entryCreator.getName(), "ALL", entryAlias);
                UBSDriver.grantSecurityRole(entriesAccessControl, administrator.getName(), "ALL", entryAlias);
                UBSDriver.grantSecurityRole(entriesAccessControl, referenced_administrators.getName(), "ALL", entryAlias);
                UserBasedSecurityConnector.commit(handler);
                KeystoreResourceAccessor.trace(300, UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - entry permission created");
            }
            catch (Exception e) {
                KeystoreResourceAccessor.log(600, e, ENTRY_SYSTEM_SECURITY_NOT_CREATED, new Object[]{currentUser, viewAlias, entryAlias});
                KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - entry permission not created", e);
                throw e;
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            UserBasedSecurityConnector.close(handler);
            throw throwable;
        }
        UserBasedSecurityConnector.close(handler);
    }

    public void checkPermissions_removeEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "REMOVE_ENTRY", entryAlias);
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias, entryAlias) + " checkPermissions 'removeEntry': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void destroyEntryPermission(String viewAlias, String entryAlias) throws Exception {
        SecurityContext viewSecurityContext = null;
        ModificationContext m = null;
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        String viewPolicyConfigurationAlias = UserBasedSecurityConnector.createCompoundName("keystore-view", viewAlias);
        try {
            handler = UserBasedSecurityConnector.getHandler();
            rootCfg = UserBasedSecurityConnector.ensureViewPolicyConfiguration(handler, viewAlias);
            try {
                m = securityContext.getModificationContext();
                viewSecurityContext = m.beginModifications(rootCfg);
                viewSecurityContext = viewSecurityContext.getPolicyConfigurationContext(viewPolicyConfigurationAlias);
                ResourceContext viewResourceContext = viewSecurityContext.getAuthorizationContext().getSecurityResourceContext();
                SecurityRoleContext viewRoleContext = viewSecurityContext.getAuthorizationContext().getSecurityRoleContext();
                ResourceHandle entriesResource = viewResourceContext.getResourceHandle("entry-actions");
                try {
                    UBSDriver.removeSecurityRole(viewRoleContext, UserBasedSecurityConnector.createCompoundName("entry-creator", entryAlias));
                }
                catch (Exception e) {
                    KeystoreResourceAccessor.traceThrowable(300, UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - the system security role [" + UserBasedSecurityConnector.createCompoundName("entry-creator", entryAlias) + "] may have not been removed", e);
                }
                UBSDriver.removeInstance(entriesResource, entryAlias);
                UserBasedSecurityConnector.commit(handler);
                KeystoreResourceAccessor.trace(300, UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - entry permission removed");
            }
            catch (Exception e) {
                KeystoreResourceAccessor.log(600, e, ENTRY_SYSTEM_SECURITY_NOT_REMOVED, new Object[]{viewAlias, entryAlias});
                KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - entry permission not removed", e);
                throw e;
            }
            Object var13_13 = null;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            UserBasedSecurityConnector.close(handler);
            throw throwable;
        }
        UserBasedSecurityConnector.close(handler);
    }

    public void renameEntryPermission(String viewAlias, String oldEntryAlias, String newEntryAlias) throws Exception {
        SecurityContext viewSecurityContext = null;
        ModificationContext m = null;
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        String viewPolicyConfigurationAlias = UserBasedSecurityConnector.createCompoundName("keystore-view", viewAlias);
        try {
            handler = UserBasedSecurityConnector.getHandler();
            rootCfg = UserBasedSecurityConnector.ensureViewPolicyConfiguration(handler, viewAlias);
            try {
                m = securityContext.getModificationContext();
                viewSecurityContext = m.beginModifications(rootCfg);
                viewSecurityContext = viewSecurityContext.getPolicyConfigurationContext(viewPolicyConfigurationAlias);
                ResourceContext viewResourceContext = viewSecurityContext.getAuthorizationContext().getSecurityResourceContext();
                SecurityRoleContext viewRoleContext = viewSecurityContext.getAuthorizationContext().getSecurityRoleContext();
                ResourceHandle entriesResource = viewResourceContext.getResourceHandle("entry-actions");
                ResourceAccessControlHandle acl_handle = viewResourceContext.getResourceAccessControlHandle("entry-actions");
                UBSDriver.createInstance(entriesResource, newEntryAlias);
                String[] actions = entriesResource.getActions();
                String role_name_old_entry_creator = UserBasedSecurityConnector.createCompoundName("entry-creator", oldEntryAlias);
                String role_name_new_entry_creator = UserBasedSecurityConnector.createCompoundName("entry-creator", newEntryAlias);
                int i = 0;
                while (i < actions.length) {
                    String[] grantedRoles = acl_handle.listGrantedSecurityRoles(actions[i], oldEntryAlias);
                    String[] deniedRoles = acl_handle.listDeniedSecurityRoles(actions[i], oldEntryAlias);
                    int j = 0;
                    while (j < grantedRoles.length) {
                        if (grantedRoles[j].equals(role_name_old_entry_creator)) {
                            UBSDriver.grantSecurityRole(acl_handle, role_name_new_entry_creator, actions[i], newEntryAlias);
                        } else {
                            UBSDriver.grantSecurityRole(acl_handle, grantedRoles[j], actions[i], newEntryAlias);
                        }
                        ++j;
                    }
                    int j2 = 0;
                    while (j2 < deniedRoles.length) {
                        if (deniedRoles[j2].equals(role_name_old_entry_creator)) {
                            UBSDriver.denySecurityRole(acl_handle, role_name_new_entry_creator, actions[i], newEntryAlias);
                        } else {
                            UBSDriver.denySecurityRole(acl_handle, deniedRoles[j2], actions[i], newEntryAlias);
                        }
                        ++j2;
                    }
                    ++i;
                }
                SecurityRole role_new_entry_creator = UBSDriver.addSecurityRole(viewRoleContext, role_name_new_entry_creator);
                SecurityRole role_old_entry_creator = UBSDriver.getSecurityRole(viewRoleContext, role_name_old_entry_creator);
                String[] groups = role_old_entry_creator.getGroups();
                String[] users = role_old_entry_creator.getUsers();
                int k = 0;
                while (k < groups.length) {
                    UBSDriver.addGroup(role_new_entry_creator, groups[k]);
                    ++k;
                }
                int k2 = 0;
                while (k2 < users.length) {
                    UBSDriver.addUser(role_new_entry_creator, users[k2]);
                    ++k2;
                }
                UBSDriver.removeSecurityRole(viewRoleContext, role_name_old_entry_creator);
                UBSDriver.removeInstance(entriesResource, oldEntryAlias);
                UserBasedSecurityConnector.commit(handler);
                KeystoreResourceAccessor.trace(300, UserBasedSecurityConnector.g(viewAlias, oldEntryAlias, newEntryAlias) + " entry renamed");
            }
            catch (Exception e) {
                KeystoreResourceAccessor.log(600, e, ENTRY_SYSTEM_SECURITY_SUPPORT_NOT_RENAMED, new Object[]{viewAlias, oldEntryAlias, newEntryAlias});
                KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.g(viewAlias, oldEntryAlias, newEntryAlias) + " entry not renamed", e);
                throw e;
            }
            Object var24_26 = null;
        }
        catch (Throwable throwable) {
            Object var24_27 = null;
            UserBasedSecurityConnector.close(handler);
            throw throwable;
        }
        UserBasedSecurityConnector.close(handler);
    }

    public void checkPermissions_createProperty(String viewAlias) throws KeyStoreException {
        try {
            String currentUser = UserBasedSecurityConnector.getCurrentUser();
            if (currentUser == null) {
                return;
            }
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "SET_VIEW_PROPERTY", "ALL");
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.p(viewAlias, "") + " - checkPermissions 'createProperty': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void createPropertyPermission(String viewAlias, String key) throws Exception {
    }

    public void createPropertyPermission(String currentUser, String viewAlias, String key) throws Exception {
        SecurityContext viewSecurityContext = null;
        ModificationContext m = null;
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        String viewPolicyConfigurationAlias = UserBasedSecurityConnector.createCompoundName("keystore-view", viewAlias);
        try {
            handler = UserBasedSecurityConnector.getHandler();
            rootCfg = UserBasedSecurityConnector.ensureViewPolicyConfiguration(handler, viewAlias);
            try {
                SecurityRole referenced_administrators;
                m = securityContext.getModificationContext();
                viewSecurityContext = m.beginModifications(rootCfg);
                viewSecurityContext = viewSecurityContext.getPolicyConfigurationContext(viewPolicyConfigurationAlias);
                ResourceContext viewResourceContext = viewSecurityContext.getAuthorizationContext().getSecurityResourceContext();
                SecurityRoleContext viewRoleContext = viewSecurityContext.getAuthorizationContext().getSecurityRoleContext();
                ResourceHandle propertiesResource = viewResourceContext.getResourceHandle("property-actions");
                ResourceAccessControlHandle acl_handle = viewResourceContext.getResourceAccessControlHandle("property-actions");
                if (propertiesResource == null) {
                    throw new KeyStoreException("There is no properties resource for view [" + viewAlias + "]!");
                }
                UBSDriver.createInstance(propertiesResource, key);
                String roleName = UserBasedSecurityConnector.createCompoundName("property-creator", key);
                SecurityRole propertyCreator = UBSDriver.addSecurityRole(viewRoleContext, roleName);
                SecurityRole administrator = UBSDriver.getSecurityRole(viewRoleContext, "KeystoreAdministrator");
                if (administrator == null) {
                    administrator = UBSDriver.addSecurityRoleReference(viewRoleContext, "KeystoreAdministrator", "SAP-J2EE-Engine", "KeystoreAdministrator");
                }
                if ((referenced_administrators = UBSDriver.getSecurityRole(viewRoleContext, "ReferenceAdministrators")) == null) {
                    referenced_administrators = UBSDriver.addSecurityRoleReference(viewRoleContext, "ReferenceAdministrators", "SAP-J2EE-Engine", "administrators");
                }
                if (currentUser != null) {
                    UBSDriver.addUser(propertyCreator, currentUser);
                }
                UBSDriver.grantSecurityRole(acl_handle, propertyCreator.getName(), "ALL", key);
                UBSDriver.grantSecurityRole(acl_handle, administrator.getName(), "ALL", key);
                UBSDriver.grantSecurityRole(acl_handle, referenced_administrators.getName(), "ALL", key);
                UserBasedSecurityConnector.commit(handler);
                KeystoreResourceAccessor.trace(500, UserBasedSecurityConnector.p(viewAlias, key) + " - permission for property [" + key + "] created");
            }
            catch (Exception e) {
                KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.p(viewAlias, key) + " -  permission for property [" + key + "] NOT created", e);
                throw e;
            }
            Object var18_18 = null;
        }
        catch (Throwable throwable) {
            Object var18_19 = null;
            UserBasedSecurityConnector.close(handler);
            throw throwable;
        }
        UserBasedSecurityConnector.close(handler);
    }

    public void checkPermissions_removeProperty(String viewAlias, String key) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getPropertiesControlHandle(viewAlias), "REMOVE_PROPERTY", key);
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.p(viewAlias, key) + " - checkPermissions 'removeProperty': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void destroyPropertyPermission(String viewAlias, String key) throws Exception {
        SecurityContext viewSecurityContext = null;
        ModificationContext m = null;
        ConfigurationHandler handler = null;
        Configuration rootCfg = null;
        String viewPolicyConfigurationAlias = UserBasedSecurityConnector.createCompoundName("keystore-view", viewAlias);
        try {
            handler = UserBasedSecurityConnector.getHandler();
            rootCfg = UserBasedSecurityConnector.ensureViewPolicyConfiguration(handler, viewAlias);
            try {
                m = securityContext.getModificationContext();
                viewSecurityContext = m.beginModifications(rootCfg);
                viewSecurityContext = viewSecurityContext.getPolicyConfigurationContext(viewPolicyConfigurationAlias);
                ResourceContext viewResourceContext = viewSecurityContext.getAuthorizationContext().getSecurityResourceContext();
                SecurityRoleContext viewRoleContext = viewSecurityContext.getAuthorizationContext().getSecurityRoleContext();
                ResourceHandle propertiesResource = viewResourceContext.getResourceHandle("property-actions");
                UBSDriver.removeSecurityRole(viewRoleContext, UserBasedSecurityConnector.createCompoundName("property-creator", key));
                UBSDriver.removeInstance(propertiesResource, key);
                UserBasedSecurityConnector.commit(handler);
                KeystoreResourceAccessor.trace(300, UserBasedSecurityConnector.p(viewAlias, key) + " property permission removed");
            }
            catch (Exception e) {
                KeystoreResourceAccessor.traceThrowable(600, UserBasedSecurityConnector.p(viewAlias, key) + " property permission NOT removed", e);
                throw e;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            UserBasedSecurityConnector.close(handler);
            throw throwable;
        }
        UserBasedSecurityConnector.close(handler);
    }

    public void checkPermissions_getProperty(String viewAlias, String key) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getPropertiesControlHandle(viewAlias), "GET_PROPERTY", key);
        }
        catch (SecurityException e) {
            String msg = UserBasedSecurityConnector.p(viewAlias, key) + " - checkPermissions 'getProperty': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_listProperty(String viewAlias, String key) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getPropertiesControlHandle(viewAlias), "LIST_PROPERTY", key);
        }
        catch (SecurityException e) {
            String msg = UserBasedSecurityConnector.p(viewAlias, key) + " - checkPermissions 'listProperty': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_writeProperty(String viewAlias, String key) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getPropertiesControlHandle(viewAlias), "UPDATE_PROPERTY", key);
        }
        catch (SecurityException e) {
            String msg = UserBasedSecurityConnector.p(viewAlias, key) + " - checkPermissions 'writeProperty': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_getViewProperties(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "GET_VIEW_PROPERTIES", "ALL");
        }
        catch (SecurityException e) {
            String msg = UserBasedSecurityConnector.g(viewAlias) + " - checkPermissions 'getViewProperties': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_aliases(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "VIEW_ALIASES", "ALL");
        }
        catch (SecurityException e) {
            String msg = UserBasedSecurityConnector.g(viewAlias) + " - checkPermissions 'aliases': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_readEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "READ_ENTRY", entryAlias);
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - checkPermissions 'readEntry': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_listEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "LIST_ENTRY", entryAlias);
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - checkPermissions 'listEntry': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_writeEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "WRITE_ENTRY", entryAlias);
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - checkPermissions 'writeEntry': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_size(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "SIZE_OF_VIEW", "ALL");
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias, "") + " - checkPermissions 'size': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_listView(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "LIST_VIEW", "ALL");
        }
        catch (Exception e) {
            String msg = UserBasedSecurityConnector.g(viewAlias, "") + " - checkPermissions 'listView': " + e;
            UserBasedSecurityConnector.checkFailed(msg);
        }
    }

    public void checkPermissions_findAlias(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "FIND_ALIAS", "ALL");
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed(UserBasedSecurityConnector.g(viewAlias, "") + " - checkPermissions 'findAlias': " + e);
        }
    }

    public void checkPermissions_isViewExists(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "IS_VIEW_EXISTS", "ALL");
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed(UserBasedSecurityConnector.g(viewAlias, "") + " - checkPermissions  'isExistsView': " + e);
        }
    }

    public void checkPermissions_getView(String viewAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getViewControlHandle(viewAlias), "GET_VIEW", "ALL");
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed(UserBasedSecurityConnector.g(viewAlias, "") + " - checkPermissions  'getView': " + e);
        }
    }

    public void checkPermissions_IsKey(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "IS_ENTRY_A_KEY", entryAlias);
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed(UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - checkPermissions  'isKey': " + e);
        }
    }

    public void checkPermissions_renameEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "RENAME_ENTRY", entryAlias);
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed(UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - checkPermissions  'renameEntry': " + e);
        }
    }

    public void checkPermissions_IsExistsEntry(String viewAlias, String entryAlias) throws KeyStoreException {
        String currentUser = UserBasedSecurityConnector.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        try {
            UserBasedSecurityConnector.checkPermission(UserBasedSecurityConnector.getEntriesControlHandle(viewAlias), "IS_ENTRY_EXISTS", entryAlias);
        }
        catch (Exception e) {
            UserBasedSecurityConnector.checkFailed(UserBasedSecurityConnector.g(viewAlias, entryAlias) + " - checkPermissions  'isExistsEntry': " + e);
        }
    }

    private static ConfigurationHandler getHandler() throws KeyStoreException {
        try {
            return configurationHandlerFactory.getConfigurationHandler();
        }
        catch (Exception e) {
            KeystoreResourceAccessor.traceThrowable(500, CANNOT_GET_CFG_HANDLER, null, e);
            KeystoreResourceAccessor.log(500, e, CANNOT_GET_CFG_HANDLER);
            throw new BaseKeystoreException(CANNOT_GET_CFG_HANDLER, e);
        }
    }

    private static SecurityContext getViewPolicyContext(String viewAlias) {
        String policy_context_name = UserBasedSecurityConnector.createCompoundName("keystore-view", viewAlias);
        return securityContext.getPolicyConfigurationContext(policy_context_name);
    }

    private static Configuration ensureViewPolicyConfiguration(ConfigurationHandler handler, String viewAlias) throws Exception {
        return UserBasedSecurityConnector.ensureWriteConfiguration(handler, new String[]{"keystore", "$$$user-based-security-root$$$", viewAlias});
    }

    /*
     * Unable to fully structure code
     */
    private static Configuration ensureWriteConfiguration(ConfigurationHandler handler, String[] path) throws Exception {
        block19: {
            block18: {
                try {
                    counter = 0;
                    temp = null;
                    result = null;
                    lock = new Object();
                    while (counter++ <= 100) {
                        i = 0;
                        try {
                            try {
                                result = handler.openConfiguration(path[0], 1);
                            }
                            catch (NameNotFoundException ne) {
                                result = handler.createRootConfiguration(path[0]);
                            }
                            i = 1;
                            while (i < path.length) {
                                try {
                                    result = result.getSubConfiguration(path[i]);
                                }
                                catch (NameNotFoundException ne) {
                                    result = result.createSubConfiguration(path[i]);
                                }
                                ++i;
                            }
                            return result;
                        }
                        catch (ConfigurationLockedException _) {
                            temp = _;
                            try {
                                var8_14 = lock;
                                synchronized (var8_14) {
                                    lock.wait(100L);
                                }
                            }
                            catch (InterruptedException __) {}
                        }
                        catch (NameNotFoundException ne) {
                            throw ne;
                        }
                    }
                    throw new RuntimeException("Cannot ensure a configuration: " + temp.getMessage());
                }
                catch (RuntimeException re) {
                    throw new Exception(re.getMessage());
                }
                catch (Exception e) {
                    KeystoreResourceAccessor.traceThrowable(400, "ensureWriteConfiguration(..): ", e);
                    KeystoreResourceAccessor.trace(400, "used handler: " + handler);
                    if (path == null) break block18;
                    i = 0;
                    ** while (i < path.length)
                }
lbl-1000:
                // 1 sources

                {
                    KeystoreResourceAccessor.trace(400, "path[" + i + "]: " + path[i]);
                    ++i;
                    continue;
lbl50:
                    // 1 sources

                    break block19;
                }
            }
            KeystoreResourceAccessor.trace(400, "path: " + path);
        }
        throw e;
    }

    private static void commit(ConfigurationHandler handler) throws KeyStoreException {
        if (handler != null) {
            try {
                handler.commit();
            }
            catch (Exception _) {
                KeystoreResourceAccessor.traceThrowable(500, "Cannot commit a configuration handler", _);
                KeystoreResourceAccessor.trace(500, "handler: " + handler);
                KeystoreResourceAccessor.log(500, _, CONFIGURATION_COMMIT_FAILED);
                throw new BaseKeystoreException(CONFIGURATION_COMMIT_FAILED, _);
            }
        }
    }

    private static void close(ConfigurationHandler handler) throws KeyStoreException {
        if (handler != null) {
            try {
                handler.rollback();
            }
            catch (Exception _) {
                KeystoreResourceAccessor.trace(400, "Non Fatal Warning: rollback handler at close: " + _);
            }
            try {
                handler.closeAllConfigurations();
            }
            catch (Exception _) {
                KeystoreResourceAccessor.log(500, _, CONFIGURATION_CLOSE_FAILED);
                KeystoreResourceAccessor.traceThrowable(500, "closeAllConfigurations", _);
                KeystoreResourceAccessor.trace(500, "handler: " + handler);
                throw new BaseKeystoreException(CONFIGURATION_CLOSE_FAILED, _);
            }
        }
    }

    private static synchronized void waitToUnlock(int timeout) {
        try {
            (class$com$sap$engine$services$keystore$impl$security$UserBasedSecurityConnector == null ? (class$com$sap$engine$services$keystore$impl$security$UserBasedSecurityConnector = UserBasedSecurityConnector.class$("com.sap.engine.services.keystore.impl.security.UserBasedSecurityConnector")) : class$com$sap$engine$services$keystore$impl$security$UserBasedSecurityConnector).wait(timeout);
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private static void checkPermission(ResourceAccessControlHandle controlHandle, String action, String instance) {
        if (controlHandle == null) {
            return;
        }
        controlHandle.checkPermission(action, instance);
    }

    private static ResourceAccessControlHandle getViewControlHandle(String viewAlias) {
        SecurityContext viewPolicyContext = UserBasedSecurityConnector.getViewPolicyContext(viewAlias);
        if (viewPolicyContext == null) {
            return null;
        }
        return viewPolicyContext.getAuthorizationContext().getSecurityResourceContext().getResourceAccessControlHandle("view-actions");
    }

    private static ResourceAccessControlHandle getEntriesControlHandle(String viewAlias) {
        SecurityContext viewPolicyContext = UserBasedSecurityConnector.getViewPolicyContext(viewAlias);
        if (viewPolicyContext == null) {
            return null;
        }
        return viewPolicyContext.getAuthorizationContext().getSecurityResourceContext().getResourceAccessControlHandle("entry-actions");
    }

    private static ResourceAccessControlHandle getPropertiesControlHandle(String viewAlias) {
        SecurityContext viewPolicyContext = UserBasedSecurityConnector.getViewPolicyContext(viewAlias);
        if (viewPolicyContext == null) {
            return null;
        }
        return viewPolicyContext.getAuthorizationContext().getSecurityResourceContext().getResourceAccessControlHandle("property-actions");
    }

    private static ResourceAccessControlHandle getKeystoreControlHandle() {
        return securityContext.getAuthorizationContext().getSecurityResourceContext().getResourceAccessControlHandle("keystore-views");
    }

    public static final String getCurrentUser() {
        ThreadContext threadContext = KeyStoreServiceFrame.getCoreContext().getThreadSystem().getThreadContext();
        if (threadContext == null) {
            return null;
        }
        SecurityContextObject contextObject = (SecurityContextObject)((Object)threadContext.getContextObject("security"));
        if (contextObject != null) {
            if (contextObject.getSession() != null) {
                return contextObject.getSession().getPrincipal().toString();
            }
            return null;
        }
        return null;
    }

    private static final String createCompoundName(String prefix, String token) {
        return prefix + "." + token;
    }

    private static void checkFailed(String description) throws KeyStoreException {
        KeystoreResourceAccessor.trace(300, description);
        throw new KeyStoreException(description);
    }

    private static final String g(String viewAlias) {
        return "(thread: " + Thread.currentThread().getName() + ", view:" + viewAlias + " , user: " + UserBasedSecurityConnector.getCurrentUser() + ")";
    }

    private static final String g(String viewAlias, String entryAlias) {
        return "(thread: " + Thread.currentThread().getName() + ",view:" + viewAlias + ", entry: " + entryAlias + ", user: " + UserBasedSecurityConnector.getCurrentUser() + ")";
    }

    private static final String g(String viewAlias, String oldEntryAlias, String newEntryAlias) {
        return "(thread: " + Thread.currentThread().getName() + ",view:" + viewAlias + ", old_entry_alias: " + oldEntryAlias + ", new_entry_alias: " + newEntryAlias + ", user: " + UserBasedSecurityConnector.getCurrentUser() + ")";
    }

    private static final String p(String viewAlias, String key) {
        return "(thread: " + Thread.currentThread().getName() + ",view:" + viewAlias + ", key: " + key + ", user: " + UserBasedSecurityConnector.getCurrentUser() + ")";
    }

    public void grantPermissionForUser(String userName, String roleName, String[] params) throws Exception {
        SecurityRoleContext viewRoleContext = null;
        ResourceAccessControlHandle controlHandle = null;
        int type = CodeBasedSecurityConnector.getCmdType(params[0]);
        switch (type) {
            case 0: {
                controlHandle = UserBasedSecurityConnector.getViewControlHandle(params[1]);
                UBSDriver.grantSecurityRole(controlHandle, roleName, params[0], "ALL");
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                break;
            }
            case 1: {
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                controlHandle = UserBasedSecurityConnector.getPropertiesControlHandle(params[1]);
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UBSDriver.grantSecurityRole(controlHandle, roleName, params[0], instance_alias);
                break;
            }
            case 2: {
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                controlHandle = UserBasedSecurityConnector.getEntriesControlHandle(params[1]);
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UBSDriver.grantSecurityRole(controlHandle, roleName, params[0], instance_alias);
                break;
            }
            case 3: {
                controlHandle = UserBasedSecurityConnector.getKeystoreControlHandle();
                UBSDriver.grantSecurityRole(controlHandle, roleName, "ALL", "ALL");
                viewRoleContext = securityContext.getAuthorizationContext().getSecurityRoleContext();
            }
        }
        SecurityRole role = UBSDriver.getSecurityRole(viewRoleContext, roleName);
        if (role == null) {
            UBSDriver.addSecurityRole(viewRoleContext, roleName);
            role = UBSDriver.getSecurityRole(viewRoleContext, roleName);
        }
        if (userName != null) {
            UBSDriver.addUser(role, userName);
        }
    }

    public void clearPermissionForUser(String userName, String roleName, String[] params) throws Exception {
        ResourceAccessControlHandle controlHandle = null;
        int type = CodeBasedSecurityConnector.getCmdType(params[0]);
        SecurityRoleContext viewRoleContext = null;
        switch (type) {
            case 0: {
                controlHandle = UserBasedSecurityConnector.getViewControlHandle(params[1]);
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                UserBasedSecurityConnector.denyUser(viewRoleContext, controlHandle, userName, roleName, params[0], "ALL");
                break;
            }
            case 1: {
                controlHandle = UserBasedSecurityConnector.getPropertiesControlHandle(params[1]);
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UserBasedSecurityConnector.denyUser(viewRoleContext, controlHandle, userName, roleName, params[0], instance_alias);
                break;
            }
            case 2: {
                controlHandle = UserBasedSecurityConnector.getEntriesControlHandle(params[1]);
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UserBasedSecurityConnector.denyUser(viewRoleContext, controlHandle, userName, roleName, params[0], instance_alias);
                break;
            }
            case 3: {
                controlHandle = UserBasedSecurityConnector.getKeystoreControlHandle();
                UserBasedSecurityConnector.denyUser(securityContext.getAuthorizationContext().getSecurityRoleContext(), controlHandle, userName, roleName, "ALL", "ALL");
            }
        }
    }

    private static final void denyUser(SecurityRoleContext roleContext, ResourceAccessControlHandle controlHandle, String userName, String roleName, String action, String instance) throws KeyStoreException {
        if (userName == null) {
            UBSDriver.denySecurityRole(controlHandle, roleName, action, instance);
        } else {
            SecurityRole role = UBSDriver.getSecurityRole(roleContext, roleName);
            if (role == null) {
                role = UBSDriver.addSecurityRole(roleContext, roleName);
                UBSDriver.addUser(role, userName);
                UBSDriver.denySecurityRole(controlHandle, roleName, action, instance);
            }
            UBSDriver.removeUser(role, userName);
        }
    }

    public void grantPermissionForGroup(String groupName, String roleName, String[] params) throws Exception {
        SecurityRoleContext roleContext = null;
        ResourceAccessControlHandle controlHandle = null;
        int type = CodeBasedSecurityConnector.getCmdType(params[0]);
        switch (type) {
            case 0: {
                controlHandle = UserBasedSecurityConnector.getViewControlHandle(params[1]);
                UBSDriver.grantSecurityRole(controlHandle, roleName, params[0], "ALL");
                roleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                break;
            }
            case 1: {
                controlHandle = UserBasedSecurityConnector.getPropertiesControlHandle(params[1]);
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UBSDriver.grantSecurityRole(controlHandle, roleName, params[0], instance_alias);
                roleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                break;
            }
            case 2: {
                controlHandle = UserBasedSecurityConnector.getEntriesControlHandle(params[1]);
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UBSDriver.grantSecurityRole(controlHandle, roleName, params[0], instance_alias);
                roleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                break;
            }
            case 3: {
                controlHandle = UserBasedSecurityConnector.getKeystoreControlHandle();
                UBSDriver.grantSecurityRole(controlHandle, roleName, "ALL", "ALL");
                roleContext = securityContext.getAuthorizationContext().getSecurityRoleContext();
            }
        }
        SecurityRole role = UBSDriver.getSecurityRole(roleContext, roleName);
        if (role == null) {
            UBSDriver.addSecurityRole(roleContext, roleName);
            role = UBSDriver.getSecurityRole(roleContext, roleName);
        }
        if (groupName != null) {
            UBSDriver.addGroup(role, groupName);
        }
    }

    public void clearPermissionForGroup(String groupName, String roleName, String[] params) throws Exception {
        ResourceAccessControlHandle controlHandle = null;
        int type = CodeBasedSecurityConnector.getCmdType(params[0]);
        SecurityRoleContext viewRoleContext = null;
        switch (type) {
            case 0: {
                controlHandle = UserBasedSecurityConnector.getViewControlHandle(params[1]);
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                UserBasedSecurityConnector.denyGroup(viewRoleContext, controlHandle, groupName, roleName, params[0], "ALL");
                break;
            }
            case 1: {
                controlHandle = UserBasedSecurityConnector.getPropertiesControlHandle(params[1]);
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UserBasedSecurityConnector.denyGroup(viewRoleContext, controlHandle, groupName, roleName, params[0], instance_alias);
                break;
            }
            case 2: {
                controlHandle = UserBasedSecurityConnector.getEntriesControlHandle(params[1]);
                viewRoleContext = UserBasedSecurityConnector.getViewPolicyContext(params[1]).getAuthorizationContext().getSecurityRoleContext();
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                UserBasedSecurityConnector.denyGroup(viewRoleContext, controlHandle, groupName, roleName, params[0], instance_alias);
                break;
            }
            case 3: {
                controlHandle = UserBasedSecurityConnector.getKeystoreControlHandle();
                UserBasedSecurityConnector.denyGroup(securityContext.getAuthorizationContext().getSecurityRoleContext(), controlHandle, groupName, roleName, "ALL", "ALL");
            }
        }
    }

    private static final void denyGroup(SecurityRoleContext roleContext, ResourceAccessControlHandle controlHandle, String groupName, String roleName, String action, String instance) throws KeyStoreException {
        if (groupName == null) {
            UBSDriver.denySecurityRole(controlHandle, roleName, action, instance);
        } else {
            SecurityRole role = roleContext.getSecurityRole(roleName);
            if (role == null) {
                role = UBSDriver.addSecurityRole(roleContext, roleName);
                UBSDriver.addGroup(role, groupName);
                UBSDriver.denySecurityRole(controlHandle, roleName, action, instance);
            }
            UBSDriver.removeGroup(role, groupName);
        }
    }

    public String[][] listAllRoles(String[] params) throws Exception {
        ResourceAccessControlHandle controlHandle = null;
        int type = CodeBasedSecurityConnector.getCmdType(params[0]);
        switch (type) {
            case 0: {
                controlHandle = UserBasedSecurityConnector.getViewControlHandle(params[1]);
                return UBSDriver.getAllRoles(controlHandle, params[0], "ALL");
            }
            case 1: {
                controlHandle = UserBasedSecurityConnector.getPropertiesControlHandle(params[1]);
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                return UBSDriver.getAllRoles(controlHandle, params[0], instance_alias);
            }
            case 2: {
                controlHandle = UserBasedSecurityConnector.getEntriesControlHandle(params[1]);
                String instance_alias = params[2];
                if (instance_alias.equals(ALL_ITEMS)) {
                    instance_alias = "ALL";
                }
                return UBSDriver.getAllRoles(controlHandle, params[0], instance_alias);
            }
            case 3: {
                controlHandle = UserBasedSecurityConnector.getKeystoreControlHandle();
                return UBSDriver.getAllRoles(controlHandle, "ALL", "ALL");
            }
        }
        KeystoreResourceAccessor.trace(400, "Unknown command: " + params[0]);
        throw new Exception("Unknown command: " + params[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

