/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.security;

import com.sap.engine.interfaces.security.ResourceContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.interfaces.security.resource.ResourceAccessControlHandle;
import com.sap.engine.interfaces.security.resource.ResourceHandle;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.security.exceptions.StorageLockedException;
import java.security.KeyStoreException;

public class UBSDriver {
    private static final int TIMEOUT = 100;
    private static final int ITERATIONS = 100;
    private static final Object synch_lock = new Object();

    public static void createResource(ResourceContext resourceContext, String resourceName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                resourceContext.createResource(resourceName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void grantSecurityRole(ResourceAccessControlHandle resource, String roleName, String actionName, String instanceName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                resource.grantSecurityRole(roleName, actionName, instanceName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void denySecurityRole(ResourceAccessControlHandle resource, String roleName, String actionName, String instanceName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                resource.denySecurityRole(roleName, actionName, instanceName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void createInstance(ResourceHandle resource, String instanceName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                resource.createInstance(instanceName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void createAction(ResourceHandle resource, String actionName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                resource.createAction(actionName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void removeSecurityRole(SecurityRoleContext roleContext, String roleName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                roleContext.removeSecurityRole(roleName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void removeInstance(ResourceHandle resource, String instanceName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                resource.removeInstance(instanceName);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static SecurityRole addSecurityRole(SecurityRoleContext roleContext, String roleName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                return roleContext.addSecurityRole(roleName);
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static SecurityRole getSecurityRole(SecurityRoleContext roleContext, String roleName) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                return roleContext.getSecurityRole(roleName);
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static SecurityRole addSecurityRoleReference(SecurityRoleContext roleContext, String roleName, String targetPolicy, String targetRole) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                return roleContext.addSecurityRoleReference(roleName, targetPolicy, targetRole);
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void addUser(SecurityRole role, String user) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                role.addUser(user);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void addGroup(SecurityRole role, String group) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                role.addGroup(group);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void removeGroup(SecurityRole role, String group) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                role.removeGroup(group);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void removeUser(SecurityRole role, String user) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                role.removeUser(user);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static void setRollDescription(SecurityRole role, String description) throws KeyStoreException {
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                role.setDescription(description);
                return;
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    public static String[][] getAllRoles(ResourceAccessControlHandle controlHandle, String instance, String action) throws KeyStoreException {
        String[] grantedRoles = null;
        String[] deniedRoles = null;
        int i = 0;
        StorageLockedException _ = null;
        while (i++ < 100) {
            try {
                grantedRoles = controlHandle.listGrantedSecurityRoles(action, instance);
                deniedRoles = controlHandle.listDeniedSecurityRoles(action, instance);
                return new String[][]{grantedRoles, deniedRoles};
            }
            catch (StorageLockedException slock) {
                _ = slock;
                UBSDriver.waitToUnlock(100);
            }
        }
        KeystoreResourceAccessor.traceThrowable(400, "Timeout exceeded", _);
        throw new BaseKeystoreException("rc_013", _);
    }

    private static void waitToUnlock(int timeout) {
        Object object = synch_lock;
        synchronized (object) {
            try {
                synch_lock.wait(timeout);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

