/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.security;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.impl.security.CodeBasedSecurityConnector;
import com.sap.engine.services.keystore.impl.security.CreateEntryPermissions;
import com.sap.engine.services.keystore.impl.security.CreatePropertyPermissions;
import com.sap.engine.services.keystore.impl.security.CreateViewPermissions;
import com.sap.engine.services.keystore.impl.security.GetAdminSubject;
import com.sap.engine.services.keystore.impl.security.RemoveEntryPermissions;
import com.sap.engine.services.keystore.impl.security.RemovePropertyPermissions;
import com.sap.engine.services.keystore.impl.security.RemoveViewPermissions;
import com.sap.engine.services.keystore.impl.security.RenameEntryPermissions;
import com.sap.engine.services.keystore.impl.security.UserBasedSecurityConnector;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.security.auth.Subject;

public class SecurityRestrictionsChecker
extends AbstractKeystoreManager {
    private AbstractKeystoreManager keystoreManager;
    private Subject adminUser = null;
    private SecurityContext securityContext = null;
    CodeBasedSecurityConnector codeSecurity = null;
    UserBasedSecurityConnector userSecurity = null;

    public SecurityRestrictionsChecker(AbstractKeystoreManager keystoreManager, SecurityContext securityContext) {
        this.keystoreManager = keystoreManager;
        this.securityContext = securityContext;
    }

    public static void checkUserPermission(String[] params) throws KeyStoreException {
        if (params.length > 1 && params[1].equals("DEFAULT")) {
            return;
        }
        try {
            if (params[0].equals("GET_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_getView(params[1]);
            } else if (params[0].equals("IS_VIEW_EXISTS")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_isViewExists(params[1]);
            } else if (params[0].equals("IS_ENTRY_EXISTS")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_IsExistsEntry(params[1], params[2]);
            } else if (params[0].equals("VIEW_ALIASES")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_aliases(params[1]);
            } else if (params[0].equals("LIST_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_listEntry(params[1], params[2]);
            } else if (params[0].equals("RENAME_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_renameEntry(params[1], params[2]);
            } else if (params[0].equals("REMOVE_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_removeEntry(params[1], params[2]);
            } else if (params[0].equals("FIND_ALIAS")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_findAlias(params[1]);
            } else if (params[0].equals("READ_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_readEntry(params[1], params[2]);
            } else if (params[0].equals("SIZE_OF_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_size(params[1]);
            } else if (params[0].equals("CREATE_ENTRY_AT_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_createEntry(params[1]);
            } else if (params[0].equals("WRITE_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_writeEntry(params[1], params[2]);
            } else if (params[0].equals("IS_ENTRY_A_KEY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_IsKey(params[1], params[2]);
            } else if (params[0].equals("LIST_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_listView(params[1]);
            } else if (params[0].equals("CREATE_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_createView();
            } else if (params[0].equals("DESTROY_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_removeView(params[1]);
            } else if (params[0].equals("GET_VIEW_PROPERTIES")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_getViewProperties(params[1]);
            } else if (params[0].equals("GET_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_getProperty(params[1], params[2]);
            } else if (params[0].equals("REMOVE_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_removeProperty(params[1], params[2]);
            } else if (params[0].equals("UPDATE_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_writeProperty(params[1], params[2]);
            } else if (params[0].equals("SET_VIEW_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_createProperty(params[1]);
            }
        }
        catch (BaseKeystoreException bex) {
            KeystoreResourceAccessor.traceThrowable(300, "checkUserPermission: " + SecurityRestrictionsChecker.dumpParams(params), bex);
            throw bex;
        }
        catch (Exception kse) {
            BaseKeystoreException bex = new BaseKeystoreException("rc_000", new Object[]{SecurityRestrictionsChecker.dumpParams(params)}, (Throwable)kse);
            KeystoreResourceAccessor.traceThrowable(300, "Unexpected: checkUserPermission: " + SecurityRestrictionsChecker.dumpParams(params), kse);
            throw bex;
        }
    }

    private static String dumpParams(String[] params) {
        String result = "{";
        int i = 0;
        while (i < params.length) {
            result = result + params[i] + " ";
            ++i;
        }
        return result + "}";
    }

    public static void checkCodePermission(String[] params) throws KeyStoreException {
        if (params.length > 1 && params[1].equals("DEFAULT")) {
            return;
        }
        try {
            if (params[0].equals("GET_VIEW")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_getView(params[1]);
            } else if (params[0].equals("IS_VIEW_EXISTS")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_isViewExists(params[1]);
            } else if (params[0].equals("IS_ENTRY_EXISTS")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_IsExistsEntry(params[1], params[2]);
            } else if (params[0].equals("VIEW_ALIASES")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_aliases(params[1]);
            } else if (params[0].equals("LIST_ENTRY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_listEntry(params[1], params[2]);
            } else if (params[0].equals("RENAME_ENTRY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_renameEntry(params[1], params[2]);
            } else if (params[0].equals("REMOVE_ENTRY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_removeEntry(params[1], params[2]);
            } else if (params[0].equals("FIND_ALIAS")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_findAlias(params[1]);
            } else if (params[0].equals("READ_ENTRY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_readEntry(params[1], params[2]);
            } else if (params[0].equals("SIZE_OF_VIEW")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_size(params[1]);
            } else if (params[0].equals("CREATE_ENTRY_AT_VIEW")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_createEntry(params[1]);
            } else if (params[0].equals("WRITE_ENTRY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_writeEntry(params[1], params[2]);
            } else if (params[0].equals("IS_ENTRY_A_KEY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_IsKey(params[1], params[2]);
            } else if (params[0].equals("LIST_VIEW")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_listView(params[1]);
            } else if (params[0].equals("CREATE_VIEW")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_createView();
            } else if (params[0].equals("DESTROY_VIEW")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_removeView(params[1]);
            } else if (params[0].equals("GET_VIEW_PROPERTIES")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_getViewProperties(params[1]);
            } else if (params[0].equals("GET_PROPERTY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_getProperty(params[1], params[2]);
            } else if (params[0].equals("REMOVE_PROPERTY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_removeProperty(params[1], params[2]);
            } else if (params[0].equals("UPDATE_PROPERTY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_writeProperty(params[1], params[2]);
            } else if (params[0].equals("SET_VIEW_PROPERTY")) {
                CodeBasedSecurityConnector.getConnector().checkPermissions_createProperty(params[1]);
            }
        }
        catch (BaseKeystoreException bex) {
            KeystoreResourceAccessor.traceThrowable(300, "checkCodePermission: " + SecurityRestrictionsChecker.dumpParams(params), bex);
            throw bex;
        }
        catch (Exception kse) {
            BaseKeystoreException bex = new BaseKeystoreException("rc_001", new Object[]{SecurityRestrictionsChecker.dumpParams(params)}, (Throwable)kse);
            KeystoreResourceAccessor.traceThrowable(300, "Unexpected: checkCodePermission: " + SecurityRestrictionsChecker.dumpParams(params), bex);
            throw bex;
        }
    }

    public void checkPermission(String[] params) throws KeyStoreException {
        boolean isReadableForAll = false;
        if (params.length > 1) {
            if (params[1].equals("DEFAULT")) {
                return;
            }
            isReadableForAll = params[1].equals("TrustedCAs");
        }
        try {
            if (params[0].equals("GET_VIEW") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_getView(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_getView(params[1]);
            } else if (params[0].equals("IS_VIEW_EXISTS") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_isViewExists(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_isViewExists(params[1]);
            } else if (params[0].equals("IS_ENTRY_EXISTS") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_IsExistsEntry(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_IsExistsEntry(params[1], params[2]);
            } else if (params[0].equals("VIEW_ALIASES") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_aliases(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_aliases(params[1]);
            } else if (params[0].equals("LIST_ENTRY") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_listEntry(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_listEntry(params[1], params[2]);
            } else if (params[0].equals("RENAME_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_renameEntry(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_renameEntry(params[1], params[2]);
            } else if (params[0].equals("REMOVE_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_removeEntry(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_removeEntry(params[1], params[2]);
            } else if (params[0].equals("FIND_ALIAS") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_findAlias(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_findAlias(params[1]);
            } else if (params[0].equals("READ_ENTRY") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_readEntry(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_readEntry(params[1], params[2]);
            } else if (params[0].equals("SIZE_OF_VIEW") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_size(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_size(params[1]);
            } else if (params[0].equals("CREATE_ENTRY_AT_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_createEntry(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_createEntry(params[1]);
            } else if (params[0].equals("WRITE_ENTRY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_writeEntry(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_writeEntry(params[1], params[2]);
            } else if (params[0].equals("IS_ENTRY_A_KEY") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_IsKey(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_IsKey(params[1], params[2]);
            } else if (params[0].equals("LIST_VIEW") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_listView(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_listView(params[1]);
            } else if (params[0].equals("CREATE_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_createView();
                CodeBasedSecurityConnector.getConnector().checkPermissions_createView();
            } else if (params[0].equals("DESTROY_VIEW")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_removeView(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_removeView(params[1]);
            } else if (params[0].equals("GET_VIEW_PROPERTIES") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_getViewProperties(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_getViewProperties(params[1]);
            } else if (params[0].equals("GET_PROPERTY") && !isReadableForAll) {
                UserBasedSecurityConnector.getConnector().checkPermissions_getProperty(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_getProperty(params[1], params[2]);
            } else if (params[0].equals("REMOVE_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_removeProperty(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_removeProperty(params[1], params[2]);
            } else if (params[0].equals("UPDATE_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_writeProperty(params[1], params[2]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_writeProperty(params[1], params[2]);
            } else if (params[0].equals("SET_VIEW_PROPERTY")) {
                UserBasedSecurityConnector.getConnector().checkPermissions_createProperty(params[1]);
                CodeBasedSecurityConnector.getConnector().checkPermissions_createProperty(params[1]);
            }
        }
        catch (BaseKeystoreException bex) {
            KeystoreResourceAccessor.traceThrowable(300, "checkPermission: " + SecurityRestrictionsChecker.dumpParams(params), bex);
            throw bex;
        }
        catch (Exception kse) {
            BaseKeystoreException bex = new BaseKeystoreException("rc_002", new Object[]{SecurityRestrictionsChecker.dumpParams(params)}, (Throwable)kse);
            KeystoreResourceAccessor.traceThrowable(300, "Unexpected:checkPermission: " + SecurityRestrictionsChecker.dumpParams(params), bex);
            throw bex;
        }
    }

    public void stop() {
        this.keystoreManager.stop();
    }

    public KeyStore getKeystore(String keystore_view_name) throws KeyStoreException {
        this.checkPermission(new String[]{"GET_VIEW", keystore_view_name});
        return this.keystoreManager.getKeystore(keystore_view_name);
    }

    public boolean existKeystoreView(String keystore_view_name) throws KeyStoreException {
        this.checkPermission(new String[]{"IS_VIEW_EXISTS", keystore_view_name});
        return this.keystoreManager.existKeystoreView(keystore_view_name);
    }

    public boolean exists(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkPermission(new String[]{"IS_ENTRY_EXISTS", keystore_view_name, alias});
        return this.keystoreManager.exists(keystore_view_name, alias);
    }

    public String[] aliases(String keystore_view_name) throws KeyStoreException {
        this.checkPermission(new String[]{"VIEW_ALIASES", keystore_view_name});
        if (!keystore_view_name.equals("DEFAULT")) {
            String[] temp = this.keystoreManager.aliases(keystore_view_name);
            String[] result = new String[]{};
            Vector<String> t = new Vector<String>();
            int i = 0;
            while (i < temp.length) {
                block5: {
                    try {
                        this.checkPermission(new String[]{"LIST_ENTRY", keystore_view_name, temp[i]});
                    }
                    catch (Exception e) {
                        break block5;
                    }
                    t.add(temp[i]);
                }
                ++i;
            }
            result = new String[t.size()];
            int i2 = 0;
            while (i2 < result.length) {
                result[i2] = (String)t.get(i2);
                ++i2;
            }
            return result;
        }
        return this.keystoreManager.aliases(keystore_view_name);
    }

    public void renameEntry(String keystoreViewAlias, String oldEntryAlias, String newEntryAlias) throws KeyStoreException {
        if (!keystoreViewAlias.equals("DEFAULT")) {
            this.checkPermission(new String[]{"RENAME_ENTRY", keystoreViewAlias, oldEntryAlias});
            RenameEntryPermissions renamer = new RenameEntryPermissions(keystoreViewAlias, oldEntryAlias, newEntryAlias);
            Exception e = (Exception)Subject.doAs(this.getAdminUser(), renamer);
            if (e != null) {
                BaseKeystoreException bex = new BaseKeystoreException("rc_011", new Object[]{UserBasedSecurityConnector.getCurrentUser(), keystoreViewAlias, oldEntryAlias, newEntryAlias}, (Throwable)e);
                KeystoreResourceAccessor.traceThrowable(300, "RenameEntryPermissions: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystoreViewAlias + ", " + oldEntryAlias + ", " + newEntryAlias, e);
                throw bex;
            }
        }
        this.keystoreManager.renameEntry(keystoreViewAlias, oldEntryAlias, newEntryAlias);
    }

    public synchronized Subject getAdminUser() throws BaseKeystoreException {
        if (this.adminUser == null) {
            GetAdminSubject getAdminSubjectAction = new GetAdminSubject(this.securityContext);
            Object result = AccessController.doPrivileged(getAdminSubjectAction);
            if (result instanceof Subject) {
                this.adminUser = (Subject)result;
            } else {
                throw (BaseKeystoreException)result;
            }
        }
        return this.adminUser;
    }

    public void deleteEntry(String keystore_view_name, String alias) throws KeyStoreException {
        if (!keystore_view_name.equals("DEFAULT")) {
            this.checkPermission(new String[]{"REMOVE_ENTRY", keystore_view_name, alias});
            RemoveEntryPermissions remover = new RemoveEntryPermissions(keystore_view_name, alias);
            Exception e = (Exception)Subject.doAs(this.getAdminUser(), remover);
            if (e != null) {
                BaseKeystoreException bex = new BaseKeystoreException("rc_010", new Object[]{keystore_view_name, alias}, (Throwable)e);
                KeystoreResourceAccessor.traceThrowable(300, "deleteEntry: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystore_view_name + ", " + alias, e);
                throw bex;
            }
        }
        this.keystoreManager.deleteEntry(keystore_view_name, alias);
    }

    public String findAlias(String keystore_view_name, KeyStoreSpiEntry entry) throws KeyStoreException {
        this.checkPermission(new String[]{"FIND_ALIAS", keystore_view_name});
        return this.keystoreManager.findAlias(keystore_view_name, entry);
    }

    public KeyStoreSpiEntry readEntry(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkPermission(new String[]{"READ_ENTRY", keystore_view_name, alias});
        return this.keystoreManager.readEntry(keystore_view_name, alias);
    }

    public int size(String keystore_view_name) throws KeyStoreException {
        this.checkPermission(new String[]{"SIZE_OF_VIEW", keystore_view_name});
        return this.keystoreManager.size(keystore_view_name);
    }

    public void writeEntry(String keystore_view_name, String alias, KeyStoreSpiEntry entry) throws KeyStoreException {
        if (!keystore_view_name.equals("DEFAULT")) {
            boolean existsEntry = this.keystoreManager.exists(keystore_view_name, alias);
            if (!existsEntry) {
                this.checkPermission(new String[]{"CREATE_ENTRY_AT_VIEW", keystore_view_name});
            } else {
                this.checkPermission(new String[]{"WRITE_ENTRY", keystore_view_name, alias});
            }
            if (!existsEntry) {
                CreateEntryPermissions creator = new CreateEntryPermissions(UserBasedSecurityConnector.getCurrentUser(), keystore_view_name, alias);
                Exception e = (Exception)Subject.doAs(this.getAdminUser(), creator);
                if (e != null) {
                    BaseKeystoreException bex = new BaseKeystoreException(existsEntry ? "rc_008" : "rc_009", new Object[]{UserBasedSecurityConnector.getCurrentUser(), keystore_view_name, alias}, (Throwable)e);
                    KeystoreResourceAccessor.traceThrowable(300, "writeEntry: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystore_view_name + ", " + alias + ", " + entry, e);
                    throw bex;
                }
            }
        }
        this.keystoreManager.writeEntry(keystore_view_name, alias, entry);
    }

    public boolean isKeyEntry(String keystore_view_name, String alias) throws KeyStoreException {
        this.checkPermission(new String[]{"IS_ENTRY_A_KEY", keystore_view_name, alias});
        return this.keystoreManager.isKeyEntry(keystore_view_name, alias);
    }

    public String[] getKeystoreViewNames() throws KeyStoreException {
        String[] temp = this.keystoreManager.getKeystoreViewNames();
        String[] result = null;
        Vector<String> t = new Vector<String>();
        int i = 0;
        while (i < temp.length) {
            block4: {
                try {
                    this.checkPermission(new String[]{"LIST_VIEW", temp[i]});
                }
                catch (Exception e) {
                    break block4;
                }
                t.add(temp[i]);
            }
            ++i;
        }
        result = new String[t.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)t.get(i2);
            ++i2;
        }
        return result;
    }

    public void createKeystoreViewEntry(String keystore_view_alias, Properties properties) throws KeyStoreException {
        if (this.keystoreManager.existKeystoreView(keystore_view_alias)) {
            BaseKeystoreException bex = new BaseKeystoreException("sm_0023", new Object[]{UserBasedSecurityConnector.getCurrentUser(), keystore_view_alias});
            throw bex;
        }
        this.checkPermission(new String[]{"CREATE_VIEW"});
        if (!keystore_view_alias.equals("DEFAULT")) {
            CreateViewPermissions creator = new CreateViewPermissions(UserBasedSecurityConnector.getCurrentUser(), keystore_view_alias);
            Exception e = (Exception)Subject.doAs(this.getAdminUser(), creator);
            if (e != null) {
                BaseKeystoreException bex = new BaseKeystoreException("rc_003", new Object[]{UserBasedSecurityConnector.getCurrentUser(), keystore_view_alias}, (Throwable)e);
                KeystoreResourceAccessor.traceThrowable(300, "createKeystoreViewEntry: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystore_view_alias, e);
                throw bex;
            }
        }
        this.keystoreManager.createKeystoreViewEntry(keystore_view_alias, properties);
    }

    public void destroyKeystoreViewEntry(String keystore_view_alias) throws KeyStoreException {
        this.checkPermission(new String[]{"DESTROY_VIEW", keystore_view_alias});
        if (!keystore_view_alias.equals("DEFAULT")) {
            RemoveViewPermissions eraser = new RemoveViewPermissions(keystore_view_alias);
            Exception e = (Exception)Subject.doAs(this.getAdminUser(), eraser);
            if (e != null) {
                BaseKeystoreException bex = new BaseKeystoreException("rc_004", new Object[]{UserBasedSecurityConnector.getCurrentUser(), keystore_view_alias}, (Throwable)e);
                KeystoreResourceAccessor.traceThrowable(300, "destroyKeystoreViewEntry: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystore_view_alias, e);
                throw bex;
            }
        }
        this.keystoreManager.destroyKeystoreViewEntry(keystore_view_alias);
    }

    public Properties getKeystoreViewProperties(String keystore_view_name) throws KeyStoreException {
        this.checkPermission(new String[]{"GET_VIEW_PROPERTIES", keystore_view_name});
        if (!keystore_view_name.equals("DEFAULT")) {
            Properties temp = this.keystoreManager.getKeystoreViewProperties(keystore_view_name);
            Enumeration keys = ((Hashtable)temp).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                try {
                    this.checkPermission(new String[]{"GET_PROPERTY", keystore_view_name, key});
                }
                catch (Exception e) {
                    ((Hashtable)temp).remove(key);
                }
            }
            return temp;
        }
        return this.keystoreManager.getKeystoreViewProperties(keystore_view_name);
    }

    public void removeProperty(String keystore_view, String key) throws KeyStoreException {
        this.checkPermission(new String[]{"REMOVE_PROPERTY", keystore_view, key});
        if (!keystore_view.equals("DEFAULT")) {
            RemovePropertyPermissions remover = new RemovePropertyPermissions(keystore_view, key);
            Exception e = (Exception)Subject.doAs(this.getAdminUser(), remover);
            if (e != null) {
                BaseKeystoreException bex = new BaseKeystoreException("rc_005", new Object[]{keystore_view, key}, (Throwable)e);
                KeystoreResourceAccessor.traceThrowable(300, "removeProperty: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystore_view + ", " + key, e);
                throw bex;
            }
        }
        this.keystoreManager.removeProperty(keystore_view, key);
    }

    public void setProperty(String keystore_view, String key, String value) throws KeyStoreException {
        if (!keystore_view.equals("DEFAULT")) {
            boolean existsProperty = false;
            try {
                existsProperty = this.keystoreManager.getProperty(keystore_view, key) != null;
            }
            catch (Exception e) {
                existsProperty = false;
            }
            if (existsProperty) {
                this.checkPermission(new String[]{"UPDATE_PROPERTY", keystore_view, key});
            } else {
                this.checkPermission(new String[]{"SET_VIEW_PROPERTY", keystore_view});
            }
            if (!existsProperty) {
                CreatePropertyPermissions creator = new CreatePropertyPermissions(UserBasedSecurityConnector.getCurrentUser(), keystore_view, key);
                Exception e = (Exception)Subject.doAs(this.getAdminUser(), creator);
                if (e != null) {
                    BaseKeystoreException bex = new BaseKeystoreException(existsProperty ? "rc_007" : "rc_006", new Object[]{keystore_view, key}, (Throwable)e);
                    KeystoreResourceAccessor.traceThrowable(300, "setProperty: " + UserBasedSecurityConnector.getCurrentUser() + ", " + keystore_view + ", " + key + ", " + value, e);
                    throw bex;
                }
            }
        }
        this.keystoreManager.setProperty(keystore_view, key, value);
    }

    public String getProperty(String keystore_view, String key) throws KeyStoreException {
        this.checkPermission(new String[]{"GET_PROPERTY", keystore_view, key});
        return this.keystoreManager.getProperty(keystore_view, key);
    }
}

