/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.coder;

import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.impl.coder.Util;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;

public class RepositoryCoder
extends KeyStoreEntryCoder {
    public KeyStoreSpiEntry decode(byte[] data, int offset, int length) throws KeyStoreException {
        byte[] encoded = null;
        if (offset == 0 && length == data.length) {
            encoded = data;
        } else {
            encoded = new byte[length];
            System.arraycopy(data, offset, encoded, 0, length);
        }
        return KeyStoreEntry.createEntry(encoded);
    }

    public KeyStoreSpiEntry decode(InputStream in) throws KeyStoreException {
        try {
            byte[] length = new byte[4];
            if (in.read(length) != 4) {
                throw new IOException();
            }
            byte[] data = new byte[Util.byteArrayToInt(length)];
            in.read(data);
            return this.decode(data, 0, data.length);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("ID21108: I/O exception. " + ioe);
        }
    }

    public void encode(KeyStoreSpiEntry entry, OutputStream out) throws KeyStoreException {
        byte[] data = entry.toByteArray();
        try {
            out.write(Util.intToByteArray(data.length));
            out.write(data);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("ID21108: I/O exception. " + ioe);
        }
    }

    public void encode(KeyStoreSpiEntry entry, byte[] out, int offset) throws KeyStoreException {
        byte[] data = entry.toByteArray();
        System.arraycopy(data, 0, out, offset, data.length);
    }
}

