/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl.coder;

import com.sap.engine.lib.security.Base64;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;

public class Base64X509CertificateCoder
extends KeyStoreEntryCoder {
    private static final byte[] HEADER = "-----BEGIN CERTIFICATE-----\n".getBytes();
    private static final byte[] FOOTER = "\n-----END CERTIFICATE-----\n".getBytes();

    public KeyStoreSpiEntry decode(byte[] data, int offset, int length) throws KeyStoreException {
        ByteArrayInputStream in = new ByteArrayInputStream(data, offset, length);
        return this.decode(in);
    }

    public KeyStoreSpiEntry decode(InputStream in) throws KeyStoreException {
        try {
            ByteArrayInputStream base64 = new ByteArrayInputStream(Base64.decode(in));
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return new KeyStoreEntry(factory.generateCertificate(base64));
        }
        catch (Exception e) {
            throw new KeyStoreException("ID21113: " + e.getMessage());
        }
    }

    public void encode(KeyStoreSpiEntry entry, OutputStream out) throws KeyStoreException {
        Certificate cert = null;
        byte[] data = null;
        if (!entry.isCertificateEntry()) {
            throw new KeyStoreException("ID21110: Not a certificate entry.");
        }
        try {
            cert = entry.getCertificate();
            data = this.headFoot(cert.getEncoded());
        }
        catch (Exception cee) {
            throw new KeyStoreException("ID21113: Encoding exception. " + cee);
        }
        try {
            out.write(data);
        }
        catch (IOException ioe) {
            throw new KeyStoreException("ID21108: I/O exception. " + ioe);
        }
    }

    public void encode(KeyStoreSpiEntry entry, byte[] out, int offset) throws KeyStoreException {
        Certificate cert = null;
        byte[] data = null;
        if (!entry.isCertificateEntry()) {
            throw new KeyStoreException("ID21110: Not a certificate entry.");
        }
        try {
            cert = entry.getCertificate();
            data = this.headFoot(cert.getEncoded());
        }
        catch (Exception cee) {
            throw new KeyStoreException("ID21113: Encoding exception. " + cee);
        }
        System.arraycopy(data, 0, out, offset, data.length);
    }

    private byte[] headFoot(byte[] raw) throws Exception {
        raw = Base64.encode(raw);
        byte[] data = new byte[raw.length + HEADER.length + FOOTER.length];
        System.arraycopy(HEADER, 0, data, 0, HEADER.length);
        System.arraycopy(raw, 0, data, HEADER.length, raw.length);
        System.arraycopy(FOOTER, 0, data, HEADER.length + raw.length, FOOTER.length);
        return data;
    }
}

