/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationHandlerFactory;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.impl.EntriesReadCache;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.impl.storage.EntriesStorage;
import com.sap.engine.services.keystore.impl.storage.PropertiesStorage;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Properties;

public class StorageManager
extends AbstractKeystoreManager {
    public static final String ROOT_KEYSTORE_VIEWS_CONFIGURATION_NAME = "keystore";
    public static final String VIEW_PROPERTIES_CONFIGURATION_NAME = "properties";
    public static final String VIEW_ENTRIES_CONFIGURATION_NAME = "entries";
    public static final int MAX_ATTEMPTS = 1000;
    private static final String SECURITY_CFG_NAME = "$$$user-based-security-root$$$";
    private ConfigurationHandlerFactory handlerFactory = null;
    private Properties defaultViewProps = new Properties();
    private static final int TIMEOUT = 100;
    EntriesReadCache cache = null;
    private static final String CONFIGURATION_COMMIT_FAILED = "CONFIGURATION_COMMIT_FAILED";
    private static final String CONFIGURATION_CLOSE_FAILED = "CONFIGURATION_CLOSE_FAILED";

    public StorageManager(ConfigurationHandlerFactory configurationHandlerFactory, boolean isEmptyDB) throws KeyStoreException {
        this.handlerFactory = configurationHandlerFactory;
        if (isEmptyDB) {
            try {
                this.createKeystoreViewEntry("DEFAULT", this.defaultViewProps);
                KeystoreResourceAccessor.trace(300, "   Default view created OK");
            }
            catch (Exception ke) {
                StorageManager.log(ke, "sm_0001", null);
            }
        } else {
            KeystoreResourceAccessor.trace(300, "  Default view exists!");
        }
    }

    public boolean registerCache(EntriesReadCache cache) {
        this.cache = cache;
        try {
            this.getHandler().addConfigurationChangedListener(cache, ROOT_KEYSTORE_VIEWS_CONFIGURATION_NAME);
            return true;
        }
        catch (KeyStoreException e) {
            KeystoreResourceAccessor.traceThrowable(400, "EntriesCache not registered as a configuration event listener", null, e);
            return false;
        }
    }

    public void checkPermission(String[] params) throws KeyStoreException {
    }

    public void stop() {
        if (this.cache != null) {
            try {
                this.getHandler().removeConfigurationChangedListener(this.cache, ROOT_KEYSTORE_VIEWS_CONFIGURATION_NAME);
            }
            catch (KeyStoreException e) {
                KeystoreResourceAccessor.traceThrowable(400, "EntriesCache not unregistered as a configuration event listener", null, e);
            }
        }
    }

    public synchronized KeyStore getKeystore(String keystore_view_name) throws KeyStoreException {
        String selectAliasToken = null;
        try {
            KeyStore ks = KeyStore.getInstance("EBSDKS");
            selectAliasToken = "KEY_VIEW_ALIAS=" + keystore_view_name + ';';
            ks.load(null, selectAliasToken.toCharArray());
            return ks;
        }
        catch (Exception e) {
            Object[] params = new Object[]{keystore_view_name};
            BaseKeystoreException bex = new BaseKeystoreException("sm_0003", params, (Throwable)e);
            StorageManager.log(e, "sm_0003", params);
            throw bex;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exists(String keystore_view_name, String alias) throws KeyStoreException {
        boolean bex2;
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name, alias};
        try {
            handler = this.getHandler();
            Configuration root = null;
            root = this.getReadConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex2 = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex2, "sm_0009", params);
                    throw bex2;
                }
                bex2 = EntriesStorage.exists(alias, root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME));
                Object var9_9 = null;
            }
            catch (Exception e) {
                BaseKeystoreException bex3 = new BaseKeystoreException("sm_0004", params, (Throwable)e);
                StorageManager.log(e, "sm_0004", params);
                throw bex3;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bex2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] aliases(String keystore_view_name) throws KeyStoreException {
        String[] bex2;
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name};
        try {
            handler = this.getHandler();
            Configuration root = null;
            root = this.getReadConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex2 = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex2, "sm_0009", params);
                    throw bex2;
                }
                bex2 = EntriesStorage.aliases(root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME));
                Object var9_8 = null;
            }
            catch (BaseKeystoreException bex3) {
                throw bex3;
            }
            catch (Exception e) {
                BaseKeystoreException bex4 = new BaseKeystoreException("sm_0005", params, (Throwable)e);
                StorageManager.log(e, "sm_0005", params);
                throw bex4;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bex2;
    }

    public void renameEntry(String keystoreViewAlias, String oldEntryAlias, String newEntryAlias) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystoreViewAlias, oldEntryAlias, newEntryAlias};
        try {
            handler = this.getHandler();
            Configuration root = null;
            Configuration view = null;
            root = this.getWriteConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystoreViewAlias)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                view = root.getSubConfiguration(keystoreViewAlias).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME);
                if (EntriesStorage.exists(newEntryAlias, view)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0006", params);
                    StorageManager.log(bex, "sm_0006", params);
                    throw bex;
                }
                if (!EntriesStorage.exists(oldEntryAlias, view)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0007", params);
                    StorageManager.log(bex, "sm_0007", params);
                    throw bex;
                }
                EntriesStorage.renameEntry(oldEntryAlias, newEntryAlias, view);
                this.commit(handler);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception _) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0008", params, (Throwable)_);
                StorageManager.log(_, "sm_0008", params);
                throw bex;
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    public void deleteEntry(String keystore_view_name, String alias) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name, alias};
        try {
            handler = this.getHandler();
            Configuration root = null;
            Configuration view = null;
            root = this.getWriteConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                view = root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME);
                EntriesStorage.deleteEntry(alias, view);
                this.commit(handler);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0010", params, (Throwable)e);
                StorageManager.log(e, "sm_0010", params);
                throw bex;
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String findAlias(String keystore_view_name, KeyStoreSpiEntry entry) throws KeyStoreException {
        String bex2;
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name};
        try {
            handler = this.getHandler();
            Configuration root = null;
            root = this.getReadConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex2 = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex2, "sm_0009", params);
                    throw bex2;
                }
                bex2 = EntriesStorage.findAlias((KeyStoreEntry)entry, root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME));
                Object var10_9 = null;
            }
            catch (BaseKeystoreException bex3) {
                throw bex3;
            }
            catch (Exception e) {
                BaseKeystoreException bex4 = new BaseKeystoreException("sm_0011", params, (Throwable)e);
                StorageManager.log(e, "sm_0011", params);
                throw bex4;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bex2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KeyStoreSpiEntry readEntry(String keystore_view_name, String alias) throws KeyStoreException {
        KeyStoreSpiEntry bex2;
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name};
        try {
            handler = this.getHandler();
            Configuration root = null;
            root = this.getReadConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex2 = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex2, "sm_0009", params);
                    throw bex2;
                }
                bex2 = EntriesStorage.readEntry(alias, root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME));
                Object var10_9 = null;
            }
            catch (BaseKeystoreException bex3) {
                throw bex3;
            }
            catch (Exception e) {
                BaseKeystoreException bex4 = new BaseKeystoreException("sm_0012", params, (Throwable)e);
                StorageManager.log(e, "sm_0012", params);
                throw bex4;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bex2;
    }

    public void writeEntry(String keystore_view_name, String alias, KeyStoreSpiEntry entry) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name, alias};
        try {
            handler = this.getHandler();
            Configuration root = null;
            Configuration view = null;
            root = this.getWriteConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                view = root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME);
                EntriesStorage.writeEntry(alias, entry, view);
                this.commit(handler);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0013", params, (Throwable)e);
                StorageManager.log(e, "sm_0013", params);
                throw bex;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isKeyEntry(String keystore_view_name, String alias) throws KeyStoreException {
        boolean bex2;
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name, alias};
        try {
            handler = this.getHandler();
            Configuration root = null;
            root = this.getReadConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex2 = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex2, "sm_0009", params);
                    throw bex2;
                }
                bex2 = EntriesStorage.isKeyEntry(alias, root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME));
                Object var10_9 = null;
            }
            catch (BaseKeystoreException bex3) {
                throw bex3;
            }
            catch (Exception e) {
                BaseKeystoreException bex4 = new BaseKeystoreException("sm_0014", params, (Throwable)e);
                StorageManager.log(e, "sm_0014", params);
                throw bex4;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bex2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existKeystoreView(String keystore_view_name) throws KeyStoreException {
        boolean bl;
        ConfigurationHandler handler = null;
        try {
            handler = this.getHandler();
            try {
                bl = this.getReadConfiguration(handler).existsSubConfiguration(keystore_view_name);
                Object var6_5 = null;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0015", new Object[]{keystore_view_name}, (Throwable)e);
                StorageManager.log(e, "sm_0015", new Object[]{keystore_view_name});
                throw bex;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int size(String keystore_view_name) throws KeyStoreException {
        int bex2;
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_name};
        try {
            handler = this.getHandler();
            Configuration root = null;
            root = this.getReadConfiguration(handler);
            try {
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex2 = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex2, "sm_0009", params);
                    throw bex2;
                }
                bex2 = EntriesStorage.size(root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME));
                Object var9_8 = null;
            }
            catch (BaseKeystoreException bex3) {
                throw bex3;
            }
            catch (Exception e) {
                BaseKeystoreException bex4 = new BaseKeystoreException("sm_0016", params, (Throwable)e);
                StorageManager.log(e, "sm_0016", params);
                throw bex4;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return bex2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getKeystoreViewNames() throws KeyStoreException {
        String[] stringArray;
        ConfigurationHandler handler = null;
        String[] result = new String[]{};
        try {
            try {
                handler = this.getHandler();
                result = this.getReadConfiguration(handler).getAllSubConfigurationNames();
                ArrayList<String> temp = new ArrayList<String>(result.length);
                int i = 0;
                while (true) {
                    if (i >= result.length) {
                        result = new String[temp.size()];
                        temp.toArray(result);
                        stringArray = result;
                        Object var7_8 = null;
                        break;
                    }
                    if (!result[i].equals(SECURITY_CFG_NAME)) {
                        temp.add(result[i]);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0017", e);
                StorageManager.log(e, "sm_0017", null);
                throw bex;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return stringArray;
    }

    public void createKeystoreViewEntry(String keystore_view_alias, Properties properties) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_alias, properties};
        try {
            try {
                Configuration root = null;
                Configuration view = null;
                handler = this.getHandler();
                root = this.getWriteConfiguration(handler);
                if (root.existsSubConfiguration(keystore_view_alias)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0023", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                view = root.createSubConfiguration(keystore_view_alias);
                view.createSubConfiguration(VIEW_PROPERTIES_CONFIGURATION_NAME);
                view.createSubConfiguration(VIEW_ENTRIES_CONFIGURATION_NAME);
                this.commit(handler);
                Object var9_11 = null;
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0018", params, (Throwable)e);
                StorageManager.log(e, "sm_0018", params);
                throw bex;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    public void destroyKeystoreViewEntry(String keystore_view_alias) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Object[] params = new Object[]{keystore_view_alias};
        try {
            try {
                Configuration root = null;
                handler = this.getHandler();
                root = this.getWriteConfiguration(handler);
                if (!root.existsSubConfiguration(keystore_view_alias)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                root.deleteConfiguration(keystore_view_alias);
                this.commit(handler);
                Object var8_8 = null;
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0019", params, (Throwable)e);
                StorageManager.log(e, "sm_0019", params);
                throw bex;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    public Properties getKeystoreViewProperties(String keystore_view_name) throws KeyStoreException {
        Properties properties;
        ConfigurationHandler handler = null;
        Configuration propertiesCfg = null;
        Object[] params = new Object[]{keystore_view_name};
        try {
            handler = this.getHandler();
            try {
                Configuration root = this.getWriteConfiguration(handler);
                if (!root.existsSubConfiguration(keystore_view_name)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                propertiesCfg = root.getSubConfiguration(keystore_view_name).getSubConfiguration(VIEW_PROPERTIES_CONFIGURATION_NAME);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("ps_0000", params, (Throwable)e);
                StorageManager.log(e, "ps_0000", params);
                throw bex;
            }
            properties = PropertiesStorage.getKeystoreViewProperties(keystore_view_name, propertiesCfg);
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return properties;
    }

    public void removeProperty(String keystore_view, String key) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Configuration propertiesCfg = null;
        Object[] params = new Object[]{keystore_view, key};
        try {
            handler = this.getHandler();
            try {
                Configuration root = this.getWriteConfiguration(handler);
                if (!root.existsSubConfiguration(keystore_view)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                propertiesCfg = root.getSubConfiguration(keystore_view).getSubConfiguration(VIEW_PROPERTIES_CONFIGURATION_NAME);
                PropertiesStorage.removeProperty(keystore_view, key, propertiesCfg);
                this.commit(handler);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0020", params, (Throwable)e);
                StorageManager.log(e, "sm_0020", params);
                throw bex;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    public void setProperty(String keystore_view, String key, String value) throws KeyStoreException {
        ConfigurationHandler handler = null;
        Configuration propertiesCfg = null;
        Object[] params = new Object[]{keystore_view, key, value};
        try {
            handler = this.getHandler();
            try {
                Configuration root = this.getWriteConfiguration(handler);
                if (!root.existsSubConfiguration(keystore_view)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                propertiesCfg = root.getSubConfiguration(keystore_view).getSubConfiguration(VIEW_PROPERTIES_CONFIGURATION_NAME);
                PropertiesStorage.setProperty(keystore_view, key, value, propertiesCfg);
                this.commit(handler);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0021", params, (Throwable)e);
                StorageManager.log(e, "sm_0021", params);
                throw bex;
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
    }

    public String getProperty(String keystore_view, String key) throws KeyStoreException {
        String string;
        ConfigurationHandler handler = null;
        Configuration propertiesCfg = null;
        Object[] params = new Object[]{keystore_view, key};
        try {
            handler = this.getHandler();
            try {
                Configuration root = this.getWriteConfiguration(handler);
                if (!root.existsSubConfiguration(keystore_view)) {
                    BaseKeystoreException bex = new BaseKeystoreException("sm_0009", params);
                    StorageManager.log(bex, "sm_0009", params);
                    throw bex;
                }
                propertiesCfg = root.getSubConfiguration(keystore_view).getSubConfiguration(VIEW_PROPERTIES_CONFIGURATION_NAME);
            }
            catch (BaseKeystoreException bex) {
                throw bex;
            }
            catch (Exception e) {
                BaseKeystoreException bex = new BaseKeystoreException("sm_0022", params, (Throwable)e);
                StorageManager.log(e, "sm_0022", params);
                throw bex;
            }
            string = PropertiesStorage.getProperty(keystore_view, key, propertiesCfg);
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.close(handler);
            throw throwable;
        }
        this.close(handler);
        return string;
    }

    private ConfigurationHandler getHandler() throws KeyStoreException {
        try {
            return this.handlerFactory.getConfigurationHandler();
        }
        catch (Exception e) {
            throw new KeyStoreException("Cannot get a handler: " + e.getMessage());
        }
    }

    private Configuration getReadConfiguration(ConfigurationHandler handler) throws KeyStoreException {
        try {
            int counter = 0;
            ConfigurationLockedException temp = null;
            while (counter++ <= 1000) {
                try {
                    return handler.openConfiguration(ROOT_KEYSTORE_VIEWS_CONFIGURATION_NAME, 0);
                }
                catch (ConfigurationLockedException _) {
                    temp = _;
                    try {
                        StorageManager storageManager = this;
                        synchronized (storageManager) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException __) {
                        // empty catch block
                    }
                }
            }
            throw new KeyStoreException("Cannot get root keystore views configuration: " + temp.getMessage());
        }
        catch (KeyStoreException kve) {
            throw kve;
        }
        catch (Exception e) {
            throw new KeyStoreException("Cannot get root keystore view configuration: " + e.getMessage());
        }
    }

    private Configuration getWriteConfiguration(ConfigurationHandler handler) throws KeyStoreException {
        try {
            int counter = 0;
            ConfigurationLockedException temp = null;
            while (counter++ <= 1000) {
                try {
                    return handler.openConfiguration(ROOT_KEYSTORE_VIEWS_CONFIGURATION_NAME, 1);
                }
                catch (ConfigurationLockedException _) {
                    temp = _;
                    try {
                        StorageManager storageManager = this;
                        synchronized (storageManager) {
                            this.wait(100L);
                        }
                    }
                    catch (InterruptedException __) {
                        // empty catch block
                    }
                }
            }
            throw new KeyStoreException("Cannot get root keystore views configuration: " + temp.getMessage());
        }
        catch (KeyStoreException kve) {
            throw kve;
        }
        catch (Exception e) {
            throw new KeyStoreException("Cannot get root keystore view configuration: " + e.getMessage());
        }
    }

    private void commit(ConfigurationHandler handler) throws KeyStoreException {
        if (handler != null) {
            try {
                handler.commit();
            }
            catch (Exception _) {
                throw new BaseKeystoreException(CONFIGURATION_COMMIT_FAILED, _);
            }
        }
    }

    private void close(ConfigurationHandler handler) throws KeyStoreException {
        if (handler != null) {
            try {
                handler.rollback();
            }
            catch (Exception _) {
                KeystoreResourceAccessor.trace(400, "Non Fatal Warning: rollback hadler at close: " + _);
            }
            try {
                handler.closeAllConfigurations();
            }
            catch (Exception _) {
                throw new BaseKeystoreException(CONFIGURATION_CLOSE_FAILED, _);
            }
        }
    }

    private static final void log(Throwable _, String key, Object[] params) {
        if (params == null) {
            KeystoreResourceAccessor.log(500, _, key);
        } else {
            KeystoreResourceAccessor.log(500, _, key, params);
        }
        KeystoreResourceAccessor.traceThrowable(500, key, params, _);
    }
}

