/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.impl;

import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.interfaces.keystore.SecurityConnector;
import com.sap.engine.services.keystore.exceptions.BaseKeystoreException;
import com.sap.engine.services.keystore.exceptions.BaseRemoteException;
import com.sap.engine.services.keystore.impl.AbstractKeystoreManager;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.rmi.RemoteException;
import java.util.Properties;

public class KeystoreManagerManagementImpl
implements KeystoreManagerManagement {
    private AbstractKeystoreManager localImpl = null;
    private RemoteSecurity remoteSecurity = null;
    private SecurityConnector securityConnector = null;

    public KeystoreManagerManagementImpl(AbstractKeystoreManager impl, RemoteSecurity remoteSecurity, SecurityConnector securityConnector) throws RemoteException {
        this.localImpl = impl;
        this.remoteSecurity = remoteSecurity;
        this.securityConnector = securityConnector;
    }

    public boolean exists(String keystore_view_alias, String alias) throws RemoteException {
        try {
            return this.localImpl.exists(keystore_view_alias, alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public RemoteSecurity getRemoteSecurity() {
        return this.remoteSecurity;
    }

    public String[] aliases(String keystore_view_alias) throws RemoteException {
        try {
            return this.localImpl.aliases(keystore_view_alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void renameEntry(String keystore_view_alias, String old_entry_alias, String new_entry_alias) throws RemoteException {
        try {
            this.localImpl.renameEntry(keystore_view_alias, old_entry_alias, new_entry_alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void deleteEntry(String keystore_view_alias, String alias) throws RemoteException {
        try {
            this.localImpl.deleteEntry(keystore_view_alias, alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public String findAlias(String keystore_view_alias, KeyStoreSpiEntry entry) throws RemoteException {
        try {
            return this.localImpl.findAlias(keystore_view_alias, entry);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public KeyStoreSpiEntry readEntry(String keystore_view_alias, String alias) throws RemoteException {
        try {
            return this.localImpl.readEntry(keystore_view_alias, alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public int size(String keystore_view_alias) throws RemoteException {
        try {
            return this.localImpl.size(keystore_view_alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void writeEntry(String keystore_view_alias, String alias, KeyStoreSpiEntry entry) throws RemoteException {
        try {
            this.localImpl.writeEntry(keystore_view_alias, alias, entry);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public boolean isKeyEntry(String keystore_view_alias, String alias) throws RemoteException {
        try {
            return this.localImpl.isKeyEntry(keystore_view_alias, alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public boolean existKeystoreView(String keystoreViewAlias) throws RemoteException {
        try {
            return this.localImpl.existKeystoreView(keystoreViewAlias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public String[] getKeystoreViewAliases() throws RemoteException {
        try {
            return this.localImpl.getKeystoreViewNames();
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void createKeystoreView(String application_name, Properties properties) throws RemoteException {
        try {
            this.localImpl.createKeystoreViewEntry(application_name, properties);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void destroyKeystoreView(String application_name) throws RemoteException {
        try {
            this.localImpl.destroyKeystoreViewEntry(application_name);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public Properties getKeystoreViewProperties(String keystore_view_alias) throws RemoteException {
        try {
            return this.localImpl.getKeystoreViewProperties(keystore_view_alias);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void setProperty(String keystore_view_alias, String key, String value) throws RemoteException {
        try {
            this.localImpl.setProperty(keystore_view_alias, key, value);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public void removeProperty(String keystore_view_alias, String key) throws RemoteException {
        try {
            this.localImpl.removeProperty(keystore_view_alias, key);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public String getProperty(String keystore_view_alias, String key) throws RemoteException {
        try {
            return this.localImpl.getProperty(keystore_view_alias, key);
        }
        catch (BaseKeystoreException bex) {
            throw new BaseRemoteException("remote_wrapper", bex);
        }
        catch (Exception kse) {
            throw new BaseRemoteException("remote_wrapper", kse);
        }
    }

    public SecurityConnector getSecurityConnector() throws RemoteException {
        return this.securityConnector;
    }

    public void stop() {
        this.localImpl.stop();
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }
}

