/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.exceptions;

import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.TimeZone;

public class BaseRemoteException
extends RemoteException
implements IBaseException {
    private BaseExceptionInfo info = null;
    public static final String REMOTE_WRAPPER = "remote_wrapper";
    public static final String NULL_DOMAIN_NAME = "rsc_000";
    public static final String CLEAR_CODE_PERMISSION = "rsc_001";
    public static final String GRANT_CODE_PERMISSION = "rsc_002";
    public static final String IS_USER_GRANTED = "rsc_003";
    public static final String IS_CODE_GRANTED = "rsc_004";
    public static final String GET_APPLICATION_DOMAINS = "rsc_005";
    public static final String GET_GRANTED_DOMAINS = "rsc_006";
    public static final String NULL_ROLE_NAME = "rsc_007";
    public static final String GRANT_USER_PERMISSION = "rsc_008";
    public static final String GRANT_GROUP_PERMISSION = "rsc_009";
    public static final String CLEAR_GROUP_PERMISSION = "rsc_010";
    public static final String CLEAR_USER_PERMISSION = "rsc_011";
    public static final String GET_ALL_ROLES = "rsc_012";

    public BaseRemoteException(String key) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, null);
    }

    public BaseRemoteException(String key, Object[] args) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, null);
    }

    public BaseRemoteException(String key, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, linkedException);
    }

    public BaseRemoteException(String key, Object[] args, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, linkedException);
    }

    public Throwable initCause(Throwable throwable) {
        if (this.info == null) {
            return null;
        }
        return this.info.initCause(throwable);
    }

    public Throwable getCause() {
        return this.info.getCause();
    }

    public String getMessage() {
        if (this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return this.info.getLocalizedMessage();
    }

    public LocalizableText getLocalizableMessage() {
        return this.info.getLocalizableMessage();
    }

    public String getLocalizedMessage() {
        return this.info.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.info.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(TimeZone zone) {
        return this.info.getLocalizedMessage(zone);
    }

    public String getLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getLocalizedMessage(locale, zone);
    }

    public String getNestedLocalizedMessage() {
        return this.info.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale locale) {
        return this.info.getNestedLocalizedMessage(locale);
    }

    public String getNestedLocalizedMessage(TimeZone zone) {
        return this.info.getNestedLocalizedMessage(zone);
    }

    public String getNestedLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getNestedLocalizedMessage(locale, zone);
    }

    public void finallyLocalize() {
        this.info.finallyLocalize();
    }

    public void finallyLocalize(Locale locale) {
        this.info.finallyLocalize(locale);
    }

    public void finallyLocalize(TimeZone zone) {
        this.info.finallyLocalize(zone);
    }

    public void finallyLocalize(Locale locale, TimeZone zone) {
        this.info.finallyLocalize(locale, zone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.info.getNestedStackTraceString();
    }

    public void printStackTrace() {
        this.info.printStackTrace();
    }

    public void printStackTrace(PrintStream stream) {
        this.info.printStackTrace(stream);
    }

    public void printStackTrace(PrintWriter writer) {
        this.info.printStackTrace(writer);
    }

    public void setLogSettings(Category category, int i, Location location) {
        this.info.setLogSettings(category, i, location);
    }

    public void log() {
        this.info.log();
    }

    private Object writeReplace() {
        StringWriter stringWriter = new StringWriter();
        this.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return new RemoteException(stringWriter.toString(), this.detail);
    }
}

