/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.exceptions;

import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.exception.BaseExceptionInfo;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.KeyStoreException;
import java.util.Locale;
import java.util.TimeZone;

public class BaseKeystoreException
extends KeyStoreException
implements IBaseException {
    private BaseExceptionInfo info = null;
    public static final String EXISTS_FAILED = "es_0001";
    public static final String ALIASES_FAILED = "es_0002";
    public static final String DELETE_ENTRY_FAILED = "es_0003";
    public static final String FIND_ALIAS_FAILED = "es_0004";
    public static final String READ_ENTRY_FAILED = "es_0005";
    public static final String SIZE_FAILED = "es_0006";
    public static final String WRITE_ENTRY_FAILED = "es_0007";
    public static final String IS_KEY_FAILED = "es_0008";
    public static final String RENAME_ENTRY_FAILED = "es_0009";
    public static final String GET_VIEW_PROPERTIES = "ps_0000";
    public static final String SET_VIEW_PROPERTY = "ps_0001";
    public static final String REMOVE_VIEW_PROPERTY = "ps_0002";
    public static final String GET_VIEW_PROPERTY = "ps_0003";
    public static final String SM_INIT_FAILED = "sm_0000";
    public static final String DEFAULT_VIEW_NOT_CREATED = "sm_0001";
    public static final String GET_VIEW = "sm_0003";
    public static final String EXIST_ENTRY = "sm_0004";
    public static final String ENTRY_ALIASES = "sm_0005";
    public static final String RENAME_ENTRY_NEW_ALREADY_EXISTS = "sm_0006";
    public static final String RENAME_ENTRY_OLD_ALREADY_NOT_EXISTS = "sm_0007";
    public static final String RENAME_ENTRY = "sm_0008";
    public static final String VIEW_NOT_FOUND = "sm_0009";
    public static final String DELETE_ENTRY = "sm_0010";
    public static final String FIND_ALIAS = "sm_0011";
    public static final String READ_ENTRY = "sm_0012";
    public static final String WRITE_ENTRY = "sm_0013";
    public static final String IS_KEY_ENTRY = "sm_0014";
    public static final String EXIST_VIEW = "sm_0015";
    public static final String SIZE_OF_VIEW = "sm_0016";
    public static final String GET_VIEW_NAME = "sm_0017";
    public static final String CREATE_VIEW = "sm_0018";
    public static final String DESTROY_VIEW = "sm_0019";
    public static final String REMOVE_PROPERTY = "sm_0020";
    public static final String SET_PROPERTY = "sm_0021";
    public static final String GET_PROPERTY = "sm_0022";
    public static final String VIEW_ALREADY_EXISTS = "sm_0023";
    public static final String CHECK_USER_PERMISSIONS = "rc_000";
    public static final String CHECK_CODE_PERMISSIONS = "rc_001";
    public static final String CHECK_PERMISSIONS = "rc_002";
    public static final String CREATE_VIEW_PERMISSIONS = "rc_003";
    public static final String DESTROY_VIEW_PERMISSIONS = "rc_004";
    public static final String DESTROY_PROPERTY_PERMISSIONS = "rc_005";
    public static final String CREATE_PROPERTY_PERMISSIONS = "rc_006";
    public static final String MODIFY_PROPERTY_PERMISSIONS = "rc_007";
    public static final String MODIFY_ENTRY_PERMISSIONS = "rc_008";
    public static final String CREATE_ENTRY_PERMISSIONS = "rc_009";
    public static final String DELETE_ENTRY_PERMISSIONS = "rc_010";
    public static final String RENAME_ENTRY_PERMISSIONS = "rc_011";
    public static final String GET_ADMIN_USER = "rc_012";
    public static final String GET_SECURITY_LOCK_TIMEOUT = "rc_013";
    public static final String CODE_BASED_CHECK_FAILED = "CODE_BASED_CHECK_FAILED";

    public BaseKeystoreException(String key) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, null);
    }

    public BaseKeystoreException(String key, int severity) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, severity, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, null);
    }

    public BaseKeystoreException(String key, Object[] args) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, null);
    }

    public BaseKeystoreException(String key, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, linkedException);
    }

    public BaseKeystoreException(String key, int severity, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, severity, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, null), (Throwable)this, linkedException);
    }

    public BaseKeystoreException(String key, Object[] args, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, 500, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, linkedException);
    }

    public BaseKeystoreException(String key, int severity, Object[] args, Throwable linkedException) {
        super(key);
        this.info = new BaseExceptionInfo(KeystoreResourceAccessor.category, severity, KeystoreResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(KeystoreResourceAccessor.getResourceAccessor(), key, args), (Throwable)this, linkedException);
    }

    public Throwable initCause(Throwable throwable) {
        return this.info.initCause(throwable);
    }

    public Throwable getCause() {
        return this.info.getCause();
    }

    public String getMessage() {
        if (this.getCause() != null) {
            return this.getCause().getMessage();
        }
        return this.info.getLocalizedMessage();
    }

    public LocalizableText getLocalizableMessage() {
        return this.info.getLocalizableMessage();
    }

    public String getLocalizedMessage() {
        return this.info.getLocalizedMessage();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.info.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(TimeZone zone) {
        return this.info.getLocalizedMessage(zone);
    }

    public String getLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getLocalizedMessage(locale, zone);
    }

    public String getNestedLocalizedMessage() {
        return this.info.getNestedLocalizedMessage();
    }

    public String getNestedLocalizedMessage(Locale locale) {
        return this.info.getNestedLocalizedMessage(locale);
    }

    public String getNestedLocalizedMessage(TimeZone zone) {
        return this.info.getNestedLocalizedMessage(zone);
    }

    public String getNestedLocalizedMessage(Locale locale, TimeZone zone) {
        return this.info.getNestedLocalizedMessage(locale, zone);
    }

    public void finallyLocalize() {
        this.info.finallyLocalize();
    }

    public void finallyLocalize(Locale locale) {
        this.info.finallyLocalize(locale);
    }

    public void finallyLocalize(TimeZone zone) {
        this.info.finallyLocalize(zone);
    }

    public void finallyLocalize(Locale locale, TimeZone zone) {
        this.info.finallyLocalize(locale, zone);
    }

    public String getSystemStackTraceString() {
        StringWriter s = new StringWriter();
        super.printStackTrace(new PrintWriter(s));
        return s.toString();
    }

    public String getStackTraceString() {
        return this.info.getStackTraceString();
    }

    public String getNestedStackTraceString() {
        return this.info.getNestedStackTraceString();
    }

    public void printStackTrace() {
        this.info.printStackTrace();
    }

    public void printStackTrace(PrintStream stream) {
        this.info.printStackTrace(stream);
    }

    public void printStackTrace(PrintWriter writer) {
        this.info.printStackTrace(writer);
    }

    public void setLogSettings(Category category, int i, Location location) {
        this.info.setLogSettings(category, i, location);
    }

    public void log() {
        this.info.log();
    }

    private Object writeReplace() {
        StringWriter stringWriter = new StringWriter();
        this.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return new KeyStoreException(stringWriter.toString());
    }
}

