/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.dispatcher;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.services.keystore.dispatcher.Commands;
import com.sap.engine.services.keystore.dispatcher.DispatcherContainerEventListener;
import com.sap.engine.services.keystore.dispatcher.DispatcherKeystoreManagerWrapperImpl;
import com.sap.engine.services.keystore.exceptions.KeystoreResourceAccessor;
import com.sap.engine.services.keystore.impl.EntriesReadCache;
import com.sap.engine.services.keystore.impl.StorageManager;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import com.sap.engine.services.keystore.server.ServerKeyStoreSpi;
import java.util.HashSet;

public class DispatcherKeyStore
implements CommunicationServiceFrame {
    private CommunicationServiceContext serviceContext = null;
    private DispatcherContainerEventListener containerEventListener = null;
    private static final String UNEXPECTED_SERVICE_NOT_STARTED = "unexpected_service_exception";
    private static final String UNEXPECTED_SERVICE_STOP_PROBLEM = "unexpected_service_stop_problem";

    public void start(CommunicationServiceContext serviceContext) throws ServiceException {
        KeystoreResourceAccessor.getResourceAccessor();
        try {
            this.serviceContext = serviceContext;
            StorageManager local = new StorageManager(serviceContext.getCoreContext().getConfigurationHandlerFactory(), false);
            EntriesReadCache cache = new EntriesReadCache(local);
            DispatcherKeystoreManagerWrapperImpl keystoreManagerWrapperImpl = null;
            if (local.registerCache(cache)) {
                keystoreManagerWrapperImpl = new DispatcherKeystoreManagerWrapperImpl(cache);
                KeystoreResourceAccessor.trace(300, "EntriesCache used");
            } else {
                keystoreManagerWrapperImpl = new DispatcherKeystoreManagerWrapperImpl(local);
                KeystoreResourceAccessor.trace(400, "EntriesCache not used");
            }
            this.containerEventListener = new DispatcherContainerEventListener(new Commands(keystoreManagerWrapperImpl).getAvailableCommands());
            int mask = 192;
            HashSet<String> names = new HashSet<String>(1);
            names.add("shell");
            serviceContext.getServiceState().registerContainerEventListener(mask, names, this.containerEventListener);
            serviceContext.getContainerContext().getObjectRegistry().registerInterface(keystoreManagerWrapperImpl);
            ServerKeyStoreSpi.setKeystoreManager(keystoreManagerWrapperImpl);
            KeyStoreProvider provider = KeyStoreProvider.getProvider();
            provider.put("KeyStore.EBSDKS", "com.sap.engine.services.keystore.server.ServerKeyStoreSpi");
            provider.install();
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(600, e, UNEXPECTED_SERVICE_NOT_STARTED);
            KeystoreResourceAccessor.traceThrowable(600, "Service not started", e);
            try {
                this.stop();
            }
            catch (Exception _) {
                KeystoreResourceAccessor.traceThrowable(600, "Stop() after failed start()", e);
            }
            throw new ServiceException(UNEXPECTED_SERVICE_NOT_STARTED, null, e);
        }
    }

    public void stop() throws ServiceRuntimeException {
        try {
            this.serviceContext.getContainerContext().getObjectRegistry().unregisterInterface();
            this.serviceContext.getServiceState().unregisterContainerEventListener();
            this.serviceContext.getServiceState().unregisterServiceEventListener();
            this.containerEventListener.stop();
            KeyStoreProvider provider = KeyStoreProvider.getProvider();
            provider.shutdown();
        }
        catch (Exception e) {
            KeystoreResourceAccessor.log(400, e, UNEXPECTED_SERVICE_STOP_PROBLEM);
            KeystoreResourceAccessor.traceThrowable(400, UNEXPECTED_SERVICE_STOP_PROBLEM, null, e);
            throw new ServiceRuntimeException(UNEXPECTED_SERVICE_STOP_PROBLEM, null, e);
        }
    }
}

