/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

class ViewsButtonPanel
extends JPanel
implements KeystoreGUIComponent,
ActionListener {
    JButton createButton = new JButton("Create View");
    JButton deleteButton = new JButton("Delete View");
    KeystoreManagerListener listener = null;
    static String CREATE_KEYSTORE_VIEW = "create_kv";
    static String DELETE_KEYSTORE_VIEW = "delete_kv";

    public void placeComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.createButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
        this.add((Component)this.deleteButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(8, 5, 5, 5), 0, 0));
    }

    public void setFrame(Frame frame) {
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
        this.createButton.setActionCommand(CREATE_KEYSTORE_VIEW);
        this.createButton.addActionListener(this);
        this.deleteButton.setActionCommand(DELETE_KEYSTORE_VIEW);
        this.deleteButton.addActionListener(this);
        this.listener = listener;
    }

    public void refresh() {
        this.deleteButton.setEnabled(false);
        this.createButton.setEnabled(true);
    }

    public void refresh(Object obj) {
        this.refresh();
        String keystoreViewAlias = (String)obj;
        if (keystoreViewAlias.equals("DEFAULT") || keystoreViewAlias.equals("DBMS_User_Store")) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
    }

    public synchronized void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action == null) {
            return;
        }
        if (action.equals(CREATE_KEYSTORE_VIEW)) {
            ViewsButtonPanel.dump("CREATE_BUTTON");
            this.listener.createNewKeystoreView();
        } else if (action.equals(DELETE_KEYSTORE_VIEW)) {
            ViewsButtonPanel.dump("DELETE_BUTTON");
            this.listener.deleteKeystoreView();
        }
    }

    private static void dump(Object msg) {
    }
}

