/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.gui.editorproperties.PropertiesTableModel;
import com.sap.engine.gui.editorproperties.PropertyEditorView;
import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;

public class ViewPropertiesPanel
extends PropertyEditorView
implements KeystoreGUIComponent {
    protected PropertiesTableModel tableModel;
    protected Properties props;
    private KeystoreManagerManagement keystoreManager = null;
    private String keystoreViewAlias = null;
    private Frame frame = null;

    public ViewPropertiesPanel(KeystoreManagerManagement keystoreManager) {
        this.tableModel = new PropertiesTableModel();
        this.keystoreManager = keystoreManager;
        this.initEditor();
    }

    public ViewPropertiesPanel(String keyColumnName, String valueColumnName) {
        this.tableModel = new PropertiesTableModel(keyColumnName, valueColumnName);
        this.keyLabel.setText(keyColumnName + " :");
        this.valueLabel.setText(valueColumnName + " :");
        this.initEditor();
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private void initEditor() {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.keyTextField.addKeyListener(this);
        this.valueTextField.addKeyListener(this);
    }

    public synchronized void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
        }
        if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
        }
    }

    private void addBtnAction() {
        if (this.keyTextField.getText().trim().length() == 0) {
            return;
        }
        if (this.keystoreViewAlias != null) {
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.keystoreManager.setProperty(this.keystoreViewAlias, this.keyTextField.getText(), this.valueTextField.getText());
                    Object var2_1 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
                this.tableModel.addRow(this.keyTextField.getText(), this.valueTextField.getText());
                this.keyTextField.requestFocus();
                this.keyTextField.setText("");
                this.valueTextField.setText("");
            }
            catch (RemoteException re) {
                JOptionPane.showMessageDialog(this.frame, "setProperty(): " + re.getMessage(), "Error!", 0);
            }
        }
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        String key = (String)this.tableModel.getValueAt(selRow, 0);
        if (this.keystoreViewAlias != null) {
            try {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.keystoreManager.removeProperty(this.keystoreViewAlias, key);
                    Object var4_3 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    this.setCursor(Cursor.getDefaultCursor());
                    throw throwable;
                }
            }
            catch (RemoteException re) {
                JOptionPane.showMessageDialog(this.frame, "removeProperty(): " + re.getMessage(), "Error!", 0);
                return;
            }
        }
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
        this.keyTextField.setText("");
        this.valueTextField.setText("");
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.removeButton.setEnabled(false);
            return;
        }
        this.removeButton.setEnabled(true);
        this.keyTextField.setText((String)this.tableModel.getValueAt(row, 0));
        this.valueTextField.setText((String)this.tableModel.getValueAt(row, 1));
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void initProperties(Properties properties) {
        this.tableModel.clearAll();
        this.keyTextField.setText("");
        this.valueTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        if (properties == null) {
            return;
        }
        this.props = properties;
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String key = (String)propNames.nextElement();
            this.tableModel.addRow(key, properties.getProperty(key));
        }
    }

    public Properties getProps() {
        Properties properties = new Properties();
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            properties.setProperty((String)this.tableModel.getValueAt(i, 0), (String)this.tableModel.getValueAt(i, 1));
            ++i;
        }
        return properties;
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
    }

    public synchronized void refresh() throws Exception {
        if (this.keystoreViewAlias == null) {
            this.initEditor();
        } else {
            Properties props = this.keystoreManager.getKeystoreViewProperties(this.keystoreViewAlias);
            this.initProperties(props);
        }
    }

    public synchronized void refresh(Object value) throws Exception {
        this.keystoreViewAlias = (String)value;
        this.refresh();
    }

    public void placeComponents() {
    }
}

