/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.KeystoreContentPanel;
import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.admin.gui.SecurityManagementPanel;
import com.sap.engine.services.keystore.admin.gui.ViewPropertiesPanel;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.Frame;
import javax.swing.JTabbedPane;

public class SingleKeystoreViewPanel
extends JTabbedPane
implements KeystoreGUIComponent {
    private ViewPropertiesPanel propertiesPanel = null;
    private KeystoreContentPanel contentPanel = null;
    SecurityManagementPanel securityPanel = null;
    KeystoreManagerListener listener = null;
    private Frame frame = null;

    ViewPropertiesPanel getViewPropertiesPanel() {
        return this.propertiesPanel;
    }

    KeystoreContentPanel getKeystoreContentPanel() {
        return this.contentPanel;
    }

    public SingleKeystoreViewPanel(KeystoreManagerManagement keystoreManager) {
        this.propertiesPanel = new ViewPropertiesPanel(keystoreManager);
        this.contentPanel = new KeystoreContentPanel(keystoreManager);
        this.securityPanel = new SecurityManagementPanel(keystoreManager);
    }

    public void placeComponents() {
        this.add("Content", this.contentPanel);
        this.add("Properties", this.propertiesPanel);
        this.setTabPlacement(3);
        this.propertiesPanel.placeComponents();
        this.contentPanel.placeComponents();
        this.securityPanel.placeComponents();
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
        this.contentPanel.registerKeystoreManagerListener(listener);
    }

    public synchronized void refresh() throws Exception {
        this.propertiesPanel.refresh();
        this.contentPanel.refresh();
        this.securityPanel.refresh();
    }

    public synchronized void refresh(Object keystoreViewAlias) throws Exception {
        this.propertiesPanel.refresh(keystoreViewAlias);
        this.contentPanel.refresh(keystoreViewAlias);
        this.securityPanel.refresh(keystoreViewAlias);
    }

    private static final void dump(Object msg) {
        System.out.println("[ SINGLE_KS_PANEL ]: " + msg);
    }
}

