/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.interfaces.keystore.SecurityConnector;
import com.sap.engine.services.keystore.admin.gui.CodeSecurityManagementPanel;
import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SecurityManagementPanel
extends JPanel
implements KeystoreGUIComponent,
ListSelectionListener,
ItemListener {
    private CodeSecurityManagementPanel codeSecurityPanel = null;
    private JTabbedPane permissionsPane = null;
    private JPanel actionsPanel = null;
    private SecurityConnector securityConnector = null;
    private KeystoreManagerManagement keystoreManager = null;
    private JList views = null;
    private JComboBox commands = null;
    private JList properties = null;
    private JList entries = null;
    private String selectedCommand = null;
    private String selectedView = null;
    private String selectedEntry = null;
    private String selectedProperty = null;
    static final String SEPARATOR = "    ";
    static final int SEPARATOR_TYPE = 0;
    static final int CREATE_VIEW_TYPE = 1;
    static final int VIEW_TYPE = 2;
    static final int ENTRY_TYPE = 3;
    static final int PROPERTY_TYPE = 4;
    static final int UNKNOWN_TYPE = 5;

    public SecurityManagementPanel(KeystoreManagerManagement keystoreManager) {
        try {
            this.keystoreManager = keystoreManager;
            this.securityConnector = keystoreManager.getSecurityConnector();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new RuntimeException(e.toString());
        }
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
    }

    public void refresh() throws Exception {
        this.setVisible(false);
        this.setVisible(true);
        this.repaint();
    }

    public void refresh(Object value) throws Exception {
    }

    public void placeComponents() {
        try {
            JSplitPane splitPane = new JSplitPane();
            this.actionsPanel = new JPanel();
            this.actionsPanel.setLayout(new GridBagLayout());
            this.commands = new JComboBox(this.getCommands());
            String[] viewAliases = this.keystoreManager.getKeystoreViewAliases();
            this.views = new JList<String>(viewAliases);
            this.views.setVisibleRowCount(5);
            this.selectedView = (String)this.views.getModel().getElementAt(0);
            this.entries = new JList<String>(this.getEntries());
            this.entries.setVisibleRowCount(5);
            this.entries.setSelectionMode(0);
            this.properties = new JList(this.getProperties());
            this.properties.setVisibleRowCount(5);
            this.properties.setSelectionMode(0);
            if (this.entries.getModel().getSize() > 0) {
                this.selectedEntry = (String)this.entries.getModel().getElementAt(0);
            }
            if (this.properties.getModel().getSize() > 0) {
                this.selectedProperty = (String)this.properties.getModel().getElementAt(0);
            }
            JScrollPane view_scroll_pane = new JScrollPane(this.views);
            view_scroll_pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Views "));
            JScrollPane entries_scroll_pane = new JScrollPane(this.entries);
            entries_scroll_pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Entries "));
            JScrollPane props_scroll_pane = new JScrollPane(this.properties);
            props_scroll_pane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Properties "));
            this.actionsPanel.add((Component)this.commands, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 2, new Insets(5, 1, 5, 1), 0, 0));
            this.actionsPanel.add((Component)view_scroll_pane, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 1, 5, 1), 0, 0));
            this.actionsPanel.add((Component)entries_scroll_pane, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 1, 5, 1), 0, 0));
            this.actionsPanel.add((Component)props_scroll_pane, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.1, 17, 1, new Insets(5, 1, 5, 1), 0, 0));
            this.actionsPanel.add((Component)new JPanel(), new GridBagConstraints(0, 4, 1, 1, 0.1, 1.0, 13, 1, new Insets(5, 1, 5, 1), 0, 0));
            this.commands.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Actions "));
            JScrollPane scrollableActions = new JScrollPane(this.actionsPanel);
            this.commands.addItemListener(this);
            this.views.addListSelectionListener(this);
            this.entries.addListSelectionListener(this);
            this.properties.addListSelectionListener(this);
            this.codeSecurityPanel = new CodeSecurityManagementPanel(this.keystoreManager);
            this.permissionsPane = new JTabbedPane();
            this.permissionsPane.add("Code", this.codeSecurityPanel);
            splitPane.setLeftComponent(scrollableActions);
            splitPane.setRightComponent(this.permissionsPane);
            this.setLayout(new GridBagLayout());
            this.add((Component)splitPane, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 1, 5, 1), 0, 0));
            this.commandIsChanged((String)this.commands.getItemAt(0));
            this.refresh();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setFrame(Frame frame) {
    }

    private Vector getCommands() {
        Vector<String> result = new Vector<String>();
        result.add("CREATE_VIEW");
        result.add("DESTROY_VIEW");
        result.add("GET_VIEW");
        result.add("GET_VIEW_PROPERTIES");
        result.add("SET_VIEW_PROPERTY");
        result.add("SIZE_OF_VIEW");
        result.add("LIST_VIEW");
        result.add("IS_VIEW_EXISTS");
        result.add("FIND_ALIAS");
        result.add("VIEW_ALIASES");
        result.add("CREATE_ENTRY_AT_VIEW");
        result.add("GET_PROPERTY");
        result.add("LIST_PROPERTY");
        result.add("REMOVE_PROPERTY");
        result.add("UPDATE_PROPERTY");
        result.add("LIST_ENTRY");
        result.add("WRITE_ENTRY");
        result.add("REMOVE_ENTRY");
        result.add("READ_ENTRY");
        result.add("IS_ENTRY_A_KEY");
        result.add("IS_ENTRY_EXISTS");
        result.add("RENAME_ENTRY");
        return result;
    }

    public void itemStateChanged(ItemEvent e) {
        this.commandIsChanged((String)e.getItem());
    }

    private void commandIsChanged(String newCommand) {
        this.selectedCommand = newCommand;
        switch (SecurityManagementPanel.getCommandType(this.selectedCommand)) {
            case 0: {
                break;
            }
            case 1: {
                this.views.setEnabled(false);
                this.entries.setEnabled(false);
                this.properties.setEnabled(false);
                try {
                    this.clearViews();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                break;
            }
            case 2: {
                this.views.setEnabled(true);
                this.entries.setEnabled(false);
                this.properties.setEnabled(false);
                if (this.selectedView == null) {
                    try {
                        this.initViews();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                this.selectedEntry = null;
                this.selectedProperty = null;
                break;
            }
            case 3: {
                this.views.setEnabled(true);
                this.entries.setEnabled(true);
                this.properties.setEnabled(false);
                if (this.selectedView == null) {
                    try {
                        this.initViews();
                        this.initEntries();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                this.selectedProperty = null;
                break;
            }
            case 4: {
                this.views.setEnabled(true);
                this.entries.setEnabled(false);
                this.properties.setEnabled(true);
                if (this.selectedView == null) {
                    try {
                        this.initViews();
                        this.initProperties();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                }
                this.selectedEntry = null;
                break;
            }
        }
        try {
            this.codeSecurityPanel.setParams(this.selectedCommand, this.selectedView, this.selectedEntry, this.selectedProperty);
        }
        catch (RemoteException e1) {
            e1.printStackTrace(System.err);
        }
    }

    private String[] getEntries() throws RemoteException {
        if (this.selectedView == null) {
            return new String[0];
        }
        return this.keystoreManager.aliases(this.selectedView);
    }

    private Vector getProperties() throws RemoteException {
        if (this.selectedView == null) {
            return new Vector();
        }
        Set keys = ((Hashtable)this.keystoreManager.getKeystoreViewProperties(this.selectedView)).keySet();
        Vector result = new Vector(keys);
        return result;
    }

    static int getCommandType(String command) {
        if (command.equals(SEPARATOR)) {
            return 0;
        }
        if (command.equals("CREATE_VIEW")) {
            return 1;
        }
        if (command.equals("DESTROY_VIEW") || command.equals("GET_VIEW") || command.equals("GET_VIEW_PROPERTIES") || command.equals("SET_VIEW_PROPERTY") || command.equals("SIZE_OF_VIEW") || command.equals("LIST_VIEW") || command.equals("IS_VIEW_EXISTS") || command.equals("FIND_ALIAS") || command.equals("VIEW_ALIASES") || command.equals("CREATE_ENTRY_AT_VIEW")) {
            return 2;
        }
        if (command.equals("GET_PROPERTY") || command.equals("LIST_PROPERTY") || command.equals("REMOVE_PROPERTY") || command.equals("UPDATE_PROPERTY")) {
            return 4;
        }
        if (command.equals("LIST_ENTRY") || command.equals("WRITE_ENTRY") || command.equals("REMOVE_ENTRY") || command.equals("READ_ENTRY") || command.equals("IS_ENTRY_A_KEY") || command.equals("IS_ENTRY_EXISTS") || command.equals("IS_VIEW_EXISTS") || command.equals("RENAME_ENTRY")) {
            return 3;
        }
        return 5;
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.views) {
                this.selectedView = (String)this.views.getSelectedValue();
                int commandType = SecurityManagementPanel.getCommandType(this.selectedCommand);
                if (commandType == 3) {
                    this.initEntries();
                } else if (commandType == 4) {
                    this.initProperties();
                }
            } else if (source == this.entries) {
                this.selectedEntry = (String)this.entries.getSelectedValue();
            } else if (source == this.properties) {
                this.selectedProperty = (String)this.properties.getSelectedValue();
            }
            this.codeSecurityPanel.setParams(this.selectedCommand, this.selectedView, this.selectedEntry, this.selectedProperty);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    private void initViews() throws RemoteException {
        this.views.removeAll();
        String[] viewAliases = this.keystoreManager.getKeystoreViewAliases();
        this.views.setListData(viewAliases);
        this.views.setSelectedIndex(0);
        if (viewAliases.length > 0) {
            this.selectedView = viewAliases[0];
        }
    }

    private void clearViews() {
        this.entries.removeAll();
        this.properties.removeAll();
        this.views.removeAll();
        this.selectedView = null;
        this.selectedEntry = null;
        this.selectedProperty = null;
        this.entries.setEnabled(false);
        this.views.setEnabled(false);
        this.properties.setEnabled(false);
    }

    private void initEntries() throws RemoteException {
        this.entries.removeAll();
        this.entries.setListData(this.getEntries());
        if (this.entries.getModel().getSize() > 0) {
            this.selectedEntry = (String)this.entries.getModel().getElementAt(0);
            this.entries.setSelectedIndex(0);
        }
    }

    private void initProperties() throws RemoteException {
        this.properties.removeAll();
        this.properties.setListData(this.getProperties());
        if (this.properties.getModel().getSize() > 0) {
            this.selectedProperty = (String)this.properties.getModel().getElementAt(0);
            this.properties.setSelectedIndex(0);
        }
    }
}

