/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListenerImpl;
import com.sap.engine.services.keystore.admin.gui.SingleKeystoreViewPanel;
import com.sap.engine.services.keystore.admin.gui.ViewsPanel;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public class KeystoreManagerPanel
extends JSplitPane {
    private ViewsPanel keystores = null;
    private SingleKeystoreViewPanel singleKeystorePanel = null;
    private KeystoreManagerListenerImpl keystoreListener = null;
    private Frame frame = null;

    SingleKeystoreViewPanel getSingleKeystoreViewPanel() {
        return this.singleKeystorePanel;
    }

    ViewsPanel getViewsPanel() {
        return this.keystores;
    }

    public KeystoreManagerPanel() {
    }

    public KeystoreManagerPanel(KeystoreManagerManagement keystoreManager) {
        this.keystores = new ViewsPanel(keystoreManager);
        this.singleKeystorePanel = new SingleKeystoreViewPanel(keystoreManager);
        this.keystoreListener = new KeystoreManagerListenerImpl(keystoreManager, this);
        this.keystores.registerKeystoreManagerListener(this.keystoreListener);
        this.singleKeystorePanel.registerKeystoreManagerListener(this.keystoreListener);
        this.placeComponents();
        this.keystores.refresh();
        if (this.frame != null) {
            this.setFrame(this.frame);
        }
    }

    void placeComponents() {
        this.singleKeystorePanel.placeComponents();
        this.keystores.placeComponents();
        this.setRightComponent(this.singleKeystorePanel);
        this.setLeftComponent(this.keystores);
    }

    public JComponent getPanel() {
        JTabbedPane runtime = new JTabbedPane();
        runtime.add("Data", this);
        runtime.add("Security", this.singleKeystorePanel.securityPanel);
        runtime.setTabPlacement(3);
        return runtime;
    }

    public final String getTitle() {
        return "Keystore views admin";
    }

    public void setFrame(Frame frame) {
        if (this.keystoreListener != null) {
            this.keystoreListener.setFrame(frame);
            this.singleKeystorePanel.getViewPropertiesPanel().setFrame(frame);
        } else {
            this.frame = frame;
        }
    }

    public void setKeystoreManager(KeystoreManagerManagement keystoreManager) {
        this.keystores = new ViewsPanel(keystoreManager);
        this.singleKeystorePanel = new SingleKeystoreViewPanel(keystoreManager);
        this.keystoreListener = new KeystoreManagerListenerImpl(keystoreManager, this);
        this.keystores.registerKeystoreManagerListener(this.keystoreListener);
        this.singleKeystorePanel.registerKeystoreManagerListener(this.keystoreListener);
        this.placeComponents();
        this.keystores.refresh();
        if (this.frame != null) {
            this.setFrame(this.frame);
        }
    }

    public void refresh() {
        try {
            this.getSingleKeystoreViewPanel().refresh();
            this.getViewsPanel().refresh();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }
}

