/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.filechooser.FileFilter;
import com.sap.engine.services.keystore.admin.cert.CSRCoder;
import com.sap.engine.services.keystore.admin.gui.EntryCreateDialog;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerPanel;
import com.sap.engine.services.keystore.admin.gui.MultipleEntriesSelector;
import com.sap.engine.services.keystore.impl.KeyStoreEntry;
import com.sap.engine.services.keystore.interfaces.KeyStoreEntryCoder;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import com.sap.engine.services.keystore.interfaces.KeyStoreSpiEntry;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import iaik.asn1.structures.AlgorithmID;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.rmi.RemoteException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class KeystoreManagerListenerImpl
implements KeystoreManagerListener {
    private String selectedKeystoreViewAlias = null;
    private String selectedKeystoreEntryAlias = null;
    private Frame frame = null;
    private KeystoreManagerManagement keystoreManager = null;
    private KeystoreManagerPanel keystoreManagerPanel = null;
    final int KEY = 0;
    final int CHAIN = 1;
    final int BOTH = 2;
    final int PKCS12 = 3;
    private CFileChooser fileChooser;
    private CFileChooser chainCertFileChooser;
    private CFileChooser loadFileChooser;
    private CFileChooser storeCertFileChooser;
    private CFileChooser storeKeyFileChooser;
    private static final FileFilter CERTIFICATE_REQUEST = new FileFilter("Certificate Signing Request (*.csr)", ".csr");
    private static final FileFilter BASE64_CERTIFICATE = new FileFilter("Base64 Encoded Certificate (*.cert)", ".cert");
    private static final FileFilter BASE64_PRIVATE_KEY = new FileFilter("Base64 Encoded Private Key (*.key)", ".key");
    private static final FileFilter PKCS8_PRIVATE_KEY = new FileFilter("PKCS#8 Private Key (*.p8)", ".p8");
    private static final FileFilter PKCS12_PRIVATE_KEY = new FileFilter("PKCS#12 Key (*.p12)", ".p12");
    private static final FileFilter X509_CERTIFICATE = new FileFilter("X.509 Certificate (*.crt)", ".crt");
    private static final FileFilter VIEW = new FileFilter("View Content (*.view)", ".view");

    public KeystoreManagerListenerImpl(KeystoreManagerManagement keystoreManager, Frame frame, KeystoreManagerPanel keystoreManagerPanel) {
        this(keystoreManager, keystoreManagerPanel);
        this.setFrame(frame);
    }

    public KeystoreManagerListenerImpl(KeystoreManagerManagement keystoreManager, KeystoreManagerPanel keystoreManagerPanel) {
        this.keystoreManager = keystoreManager;
        this.keystoreManagerPanel = keystoreManagerPanel;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        this.initChoosers();
    }

    private void initChoosers() {
        this.fileChooser = new CFileChooser(this.frame);
        this.fileChooser.addFileFilter(CERTIFICATE_REQUEST);
        LookAndFeelHandler.add(this.fileChooser);
        this.chainCertFileChooser = new CFileChooser(this.frame);
        this.chainCertFileChooser.addFileFilter(X509_CERTIFICATE);
        LookAndFeelHandler.add(this.chainCertFileChooser);
        this.storeCertFileChooser = new CFileChooser(this.frame);
        this.storeCertFileChooser.addFileFilter(BASE64_CERTIFICATE);
        this.storeCertFileChooser.addFileFilter(X509_CERTIFICATE);
        LookAndFeelHandler.add(this.storeCertFileChooser);
        this.storeKeyFileChooser = new CFileChooser(this.frame);
        this.storeKeyFileChooser.addFileFilter(BASE64_PRIVATE_KEY);
        this.storeKeyFileChooser.addFileFilter(PKCS8_PRIVATE_KEY);
        this.storeKeyFileChooser.addFileFilter(PKCS12_PRIVATE_KEY);
        LookAndFeelHandler.add(this.storeKeyFileChooser);
        this.loadFileChooser = new CFileChooser(this.frame);
        this.loadFileChooser.addFileFilter(BASE64_CERTIFICATE);
        this.loadFileChooser.addFileFilter(BASE64_PRIVATE_KEY);
        this.loadFileChooser.addFileFilter(PKCS8_PRIVATE_KEY);
        this.loadFileChooser.addFileFilter(PKCS12_PRIVATE_KEY);
        this.loadFileChooser.addFileFilter(X509_CERTIFICATE);
    }

    public synchronized void createNewKeystoreView() {
        try {
            block4: {
                try {
                    this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    String alias = JOptionPane.showInputDialog("Enter an alias:");
                    Properties props = new Properties();
                    if (alias == null || alias.trim().equals("")) break block4;
                    this.keystoreManager.createKeystoreView(alias, props);
                    this.keystoreManagerPanel.getViewsPanel().refresh();
                }
                catch (Exception e) {
                    this.dumpErrorMessage("createNewKeystoreView: ", e);
                    Object var4_5 = null;
                    this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
            Object var4_4 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public synchronized void deleteKeystoreView() {
        try {
            try {
                this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.keystoreManager.destroyKeystoreView(this.selectedKeystoreViewAlias);
                this.keystoreManagerPanel.getViewsPanel().refresh();
            }
            catch (Exception e) {
                this.dumpErrorMessage("deleteKeystoreView: ", e);
                Object var3_2 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            }
            Object var3_1 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public synchronized void selectedKeystoreView(String keystoreViewAlias) {
        try {
            try {
                this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.selectedKeystoreViewAlias = keystoreViewAlias;
                this.selectedKeystoreEntryAlias = null;
                this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh(keystoreViewAlias);
                this.keystoreManagerPanel.getViewsPanel().getButtonsPanel().refresh(keystoreViewAlias);
            }
            catch (Exception e) {
                this.dumpErrorMessage("selectedKeystoreView: ", e);
                Object var4_3 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            }
            Object var4_2 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public synchronized void selectedKeystoreEntry(String keystoreEntryAlias) {
        try {
            try {
                this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.selectedKeystoreEntryAlias = keystoreEntryAlias;
                this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().getEntriesButtonPanel().refresh(new String[]{this.selectedKeystoreViewAlias, this.selectedKeystoreEntryAlias});
            }
            catch (Exception e) {
                this.dumpErrorMessage("Select entry: ", e);
                Object var4_3 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            }
            Object var4_2 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public synchronized void deleteEntry() {
        try {
            try {
                this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.keystoreManager.deleteEntry(this.selectedKeystoreViewAlias, this.selectedKeystoreEntryAlias);
                this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh(this.selectedKeystoreViewAlias);
            }
            catch (Exception e) {
                this.dumpErrorMessage("Delete entry: ", e);
                Object var3_2 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            }
            Object var3_1 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    public synchronized void createEntry() {
        try {
            new EntryCreateDialog(this.frame, this.keystoreManager, this.selectedKeystoreViewAlias);
            try {
                this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh(this.selectedKeystoreViewAlias);
                Object var2_1 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
        }
        catch (Exception e) {
            this.dumpErrorMessage("Create entry: ", e);
        }
    }

    public synchronized void loadEntry() {
        try {
            this.load();
            this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh(this.selectedKeystoreViewAlias);
        }
        catch (Exception e) {
            this.dumpErrorMessage("Load entry: ", e);
        }
    }

    public synchronized void storeEntry() {
        try {
            this.store();
        }
        catch (Exception e) {
            this.dumpErrorMessage("Store: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void renameEntry() {
        String newAlias = null;
        try {
            try {
                newAlias = (String)JOptionPane.showInputDialog(this.keystoreManagerPanel.getSingleKeystoreViewPanel(), "Enter the new alias:", "Enter the new alias:", 3, null, null, this.selectedKeystoreEntryAlias);
                if (newAlias != null && !newAlias.trim().equals("")) {
                    if (newAlias.equals(this.selectedKeystoreEntryAlias)) {
                        JOptionPane.showMessageDialog(this.frame, "Warning!", "incorrect alias: NULL or empty string", 0);
                        Object var4_2 = null;
                        this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    this.keystoreManager.renameEntry(this.selectedKeystoreViewAlias, this.selectedKeystoreEntryAlias, newAlias);
                    this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().refresh(this.selectedKeystoreViewAlias);
                }
                this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
            }
            catch (Exception e) {
                this.dumpErrorMessage("Rename entry: ", e);
                Object var4_4 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
        Object var4_3 = null;
        this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
    }

    public synchronized void writeEntry() {
        try {
            this.write();
        }
        catch (Exception e) {
            this.dumpErrorMessage("writeEntry:", e);
        }
    }

    public synchronized void importFromView() {
        String status = "";
        MultipleEntriesSelector selector = null;
        try {
            selector = new MultipleEntriesSelector(this.frame, "Select entries to import..", this.selectedKeystoreViewAlias, this.keystoreManager, true, 2);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.frame, e, "Import from view: ", 0);
            return;
        }
        try {
            this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
            String importView = selector.getSelectedView();
            String[] importEntries = selector.getSelectedEntries();
            if (importView != null && importEntries != null) {
                int i = 0;
                while (i < importEntries.length) {
                    block16: {
                        KeyStoreEntry entry = null;
                        try {
                            entry = (KeyStoreEntry)this.keystoreManager.readEntry(importView, importEntries[i]);
                        }
                        catch (RemoteException re) {
                            status = status + "  read entry[" + importEntries[i] + "] from view[" + importView + "] failed: " + re.getMessage() + "\n";
                            break block16;
                        }
                        try {
                            this.keystoreManager.writeEntry(this.selectedKeystoreViewAlias, importEntries[i], entry);
                        }
                        catch (RemoteException re) {
                            status = status + "  write entry[" + importEntries[i] + "] to view[" + importView + "] failed: " + re.getMessage() + "\n";
                        }
                    }
                    ++i;
                }
            }
            Object var9_12 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
        if (status.length() != 0) {
            JOptionPane.showMessageDialog(this.frame, "Error at import: \n" + status, "Import from view: ", 0);
        } else {
            try {
                try {
                    this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().refresh(this.selectedKeystoreViewAlias);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this.frame, e, "Warning 2 !!!", 0);
                    Object var11_16 = null;
                    this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                }
                Object var11_15 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
        }
    }

    public synchronized void generateCSR() {
        String filename = null;
        String alias = this.selectedKeystoreEntryAlias;
        String[] files = this.fileChooser.showFileDialog("", CFileChooser.LAST_DIR, false);
        try {
            block5: {
                try {
                    this.keystoreManagerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    if (files == null || files[0] == null) break block5;
                    filename = files[0];
                    if (this.fileChooser.getSelectedFileFilter().equals(CERTIFICATE_REQUEST)) {
                        filename = filename + CERTIFICATE_REQUEST.getExtension();
                    }
                    CSRCoder csr = new CSRCoder(alias, KeyStoreProvider.getKeyStore(this.selectedKeystoreViewAlias));
                    csr.generateRequest(new FileOutputStream(filename));
                }
                catch (Exception e) {
                    this.dumpErrorMessage("Could not generate CSR for the entry. ", e);
                    Object var6_7 = null;
                    this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
            Object var6_6 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.keystoreManagerPanel.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void signKey() {
        block26: {
            block20: {
                block25: {
                    block19: {
                        try {
                            try {
                                block23: {
                                    block22: {
                                        this.chainCertFileChooser.addFileFilter(KeystoreManagerListenerImpl.BASE64_CERTIFICATE);
                                        files = this.chainCertFileChooser.showFileDialog("Load certificate chain", CFileChooser.LAST_DIR, false);
                                        if (files == null) break block22;
                                        if (files[0] != null) break block23;
                                    }
                                    var9_3 = null;
                                    break block19;
                                }
                                certChain = new Vector<Certificate>();
                                cert = null;
                                try {
                                    fis = new FileInputStream(files[0]);
                                    coder = KeyStoreEntryCoder.getCoder("BASE64_X509");
                                    try {
                                        coder.decode(fis).getCertificate();
                                    }
                                    catch (Exception e) {
                                        coder = KeyStoreEntryCoder.getCoder("X509");
                                    }
                                    fis = new FileInputStream(files[0]);
                                    while (fis.available() > 0) {
                                        cert = coder.decode(fis).getCertificate();
                                        certChain.add(cert);
                                    }
                                }
                                catch (Exception e) {
                                    this.dumpErrorMessage("Load error", new Exception("ID21181: " + e.getMessage()));
                                }
                                chain = new Certificate[certChain.size()];
                                i = 0;
                                while (true) {
                                    if (i >= chain.length) {
                                        cert = chain[0];
                                        keyStore = KeyStoreProvider.getKeyStore(this.selectedKeystoreViewAlias);
                                        pk = keyStore.getKey(this.selectedKeystoreEntryAlias, null);
                                        if (!this.verify(cert, pk)) break;
                                        keyStore.deleteEntry(this.selectedKeystoreEntryAlias);
                                        keyStore.setKeyEntry(this.selectedKeystoreEntryAlias, pk, null, chain);
                                        break block20;
                                    }
                                    chain[i] = (Certificate)certChain.elementAt(i);
                                    ++i;
                                }
                                JOptionPane.showMessageDialog(this.frame, "The selected key entry doesn't match to the specified CSR responce!", "Verification failed", 0);
                                break block20;
                            }
                            catch (Exception e) {
                                kse = new KeyStoreException("ID21141: KeyStore error. " + e.getMessage());
                                this.dumpErrorMessage("Load error", kse);
                                var9_5 = null;
                                try {
                                    this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().refresh(this.selectedKeystoreViewAlias);
                                }
                                catch (Exception e) {
                                    this.dumpErrorMessage("Warning: ", e);
                                }
                                this.frame.setCursor(Cursor.getDefaultCursor());
                                return;
                            }
                        }
                        catch (Throwable var8_21) {
                            block24: {
                                var9_6 = null;
                                ** try [egrp 4[TRYBLOCK] [4 : 349->369)] { 
lbl65:
                                // 1 sources

                                this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().refresh(this.selectedKeystoreViewAlias);
                                break block24;
lbl67:
                                // 1 sources

                                catch (Exception e) {
                                    this.dumpErrorMessage("Warning: ", e);
                                }
                            }
                            this.frame.setCursor(Cursor.getDefaultCursor());
                            throw var8_21;
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [4 : 349->369)] { 
lbl74:
                    // 1 sources

                    this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().refresh(this.selectedKeystoreViewAlias);
                    break block25;
lbl76:
                    // 1 sources

                    catch (Exception e) {
                        this.dumpErrorMessage("Warning: ", e);
                    }
                }
                this.frame.setCursor(Cursor.getDefaultCursor());
                return;
            }
            var9_4 = null;
            ** try [egrp 4[TRYBLOCK] [4 : 349->369)] { 
lbl84:
            // 1 sources

            this.keystoreManagerPanel.getSingleKeystoreViewPanel().getKeystoreContentPanel().refresh(this.selectedKeystoreViewAlias);
            break block26;
lbl86:
            // 1 sources

            catch (Exception e) {
                this.dumpErrorMessage("Warning: ", e);
            }
        }
        this.frame.setCursor(Cursor.getDefaultCursor());
    }

    private boolean verify(Certificate cert, Key pk) throws Exception {
        byte[] rawdata = "plain_text".getBytes();
        Signature signature = null;
        signature = pk.getAlgorithm().equals("DSA") ? AlgorithmID.dsa.getSignatureInstance() : AlgorithmID.md5WithRSAEncryption.getSignatureInstance();
        signature.initSign((PrivateKey)pk);
        signature.update(rawdata);
        byte[] signed = signature.sign();
        signature.initVerify(cert.getPublicKey());
        signature.update(rawdata);
        return signature.verify(signed);
    }

    private void load_single_entry(String file, String params, String alias, Certificate[] chain) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            KeyStore keyStore = KeyStoreProvider.getKeyStore(this.selectedKeystoreViewAlias);
            keyStore.load(fis, params.toCharArray());
            if (chain != null) {
                Key pk = keyStore.getKey(alias, new char[0]);
                keyStore.deleteEntry(alias);
                keyStore.setKeyEntry(alias, pk, new char[0], chain);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            fis.close();
            throw throwable;
        }
        fis.close();
    }

    private Certificate[] load_chain_for_single_entry() {
        boolean goon = true;
        int index = 1;
        Certificate cert = null;
        Certificate[] chain = null;
        Vector<Certificate> vector = new Vector<Certificate>(10, 10);
        while (goon) {
            cert = this.loadChainCertificate(index);
            if (cert != null) {
                vector.add(cert);
                ++index;
                continue;
            }
            goon = false;
        }
        chain = new Certificate[vector.size()];
        int i = 0;
        while (i < chain.length) {
            chain[i] = (Certificate)vector.elementAt(i);
            ++i;
        }
        return chain;
    }

    private String get_PKCS_12_password(JDialog dialog) {
        final JDialog pass = new JDialog((Dialog)dialog, true);
        JPasswordField pass1 = new JPasswordField();
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                pass.hide();
                pass.dispose();
            }
        });
        Container box = pass.getContentPane();
        box.setLayout(new GridLayout(2, 2));
        box.add(new JLabel("Enter password:"));
        box.add(pass1);
        box.add(button);
        box.add(new JLabel(""));
        ((Component)pass).setSize(300, 70);
        pass.setResizable(false);
        pass.setLocationRelativeTo(dialog);
        pass.show();
        pass.dispose();
        return "PKCS12;password=" + new String(pass1.getPassword()) + ';';
    }

    /*
     * Loose catch block
     */
    private void load() {
        block24: {
            JDialog dialog = new JDialog(this.frame, true);
            String[] files = this.loadFileChooser.showFileDialog("", CFileChooser.LAST_DIR, false);
            FileFilter fileType = null;
            boolean loadChain = false;
            if (files == null || files[0] == null) {
                return;
            }
            String alias = files[0];
            if (alias.indexOf(File.separator) >= 0) {
                alias = alias.substring(alias.lastIndexOf(File.separator) + 1);
            }
            if (alias.indexOf(".") >= 0) {
                alias = alias.substring(0, alias.lastIndexOf("."));
            }
            String params = "alias=" + alias + ';' + "format" + '=';
            String postfix = ";password=;";
            fileType = this.loadFileChooser.getSelectedFileFilter();
            if (fileType == BASE64_CERTIFICATE) {
                params = params + "BASE64_X509" + postfix;
            } else if (fileType == BASE64_PRIVATE_KEY) {
                params = params + "BASE64_PKCS8" + postfix;
                loadChain = true;
            } else if (fileType == PKCS8_PRIVATE_KEY) {
                params = params + "PKCS8" + postfix;
                loadChain = true;
            } else if (fileType == X509_CERTIFICATE) {
                params = params + "X509" + postfix;
            } else if (fileType == PKCS12_PRIVATE_KEY) {
                params = params + this.get_PKCS_12_password(dialog);
            } else {
                this.loadUnknownType(alias, files[0], dialog);
                if (this.loadUnknownType(alias, files[0], dialog)) {
                    return;
                }
            }
            Certificate[] chain = null;
            if (loadChain) {
                chain = this.load_chain_for_single_entry();
            }
            this.load_single_entry(files[0], params, alias, chain);
            Object var10_10 = null;
            try {
                this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh();
            }
            catch (Exception e2) {
                this.dumpErrorMessage("SingleKeystoreViewPanel.refresh(): ", e2);
            }
            this.frame.setCursor(Cursor.getDefaultCursor());
            {
                break block24;
                catch (Exception e) {
                    this.dumpErrorMessage("Load error", e);
                    Object var10_11 = null;
                    try {
                        this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh();
                    }
                    catch (Exception e2) {
                        this.dumpErrorMessage("SingleKeystoreViewPanel.refresh(): ", e2);
                    }
                    this.frame.setCursor(Cursor.getDefaultCursor());
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh();
                }
                catch (Exception e2) {
                    this.dumpErrorMessage("SingleKeystoreViewPanel.refresh(): ", e2);
                }
                this.frame.setCursor(Cursor.getDefaultCursor());
                throw throwable;
            }
        }
    }

    private boolean loadUnknownType(String alias, String fileName, JDialog dialog) {
        String prefix = "alias=" + alias + ';' + "format" + '=';
        String postfix = ";password=;";
        String prms = null;
        prms = prefix + "BASE64_X509" + postfix;
        try {
            this.load_single_entry(fileName, prms, alias, null);
            return true;
        }
        catch (Exception _) {
            prms = prefix + "X509" + postfix;
            try {
                this.load_single_entry(fileName, prms, alias, null);
                return true;
            }
            catch (Exception _1) {
                prms = prefix + this.get_PKCS_12_password(dialog);
                try {
                    this.load_single_entry(fileName, prms, alias, null);
                    return true;
                }
                catch (Exception _2) {
                    Certificate[] chain = this.load_chain_for_single_entry();
                    prms = prefix + "BASE64_PKCS8" + postfix;
                    try {
                        this.load_single_entry(fileName, prms, alias, chain);
                        return true;
                    }
                    catch (Exception _3) {
                        prms = prefix + "PKCS8" + postfix;
                        try {
                            this.load_single_entry(fileName, prms, alias, chain);
                            return true;
                        }
                        catch (Exception _4) {
                            this.dumpErrorMessage("Unknown format: ", _4);
                            return false;
                        }
                    }
                }
            }
        }
    }

    private Certificate loadChainCertificate(int index) {
        String[] files = this.chainCertFileChooser.showFileDialog("Load chain certificate #" + index + " from", CFileChooser.LAST_DIR, false);
        if (files == null || files[0] == null) {
            return null;
        }
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            return factory.generateCertificate(new FileInputStream(files[0]));
        }
        catch (FileNotFoundException fnfe) {
            this.dumpErrorMessage("Load error", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
        }
        catch (CertificateException cex) {
            this.dumpErrorMessage("Load error", new CertificateException("ID21143: " + cex.getMessage()));
        }
        return null;
    }

    private boolean storeChainCertificate(Certificate certificate, int index) {
        String[] files = this.chainCertFileChooser.showFileDialog("Store chain certificate #" + index + " in", CFileChooser.LAST_DIR, false);
        if (files == null || files[0] == null) {
            return false;
        }
        byte[] data = null;
        String filename = files[0];
        String extension = this.chainCertFileChooser.getSelectedFileFilter().getExtension();
        if (filename.indexOf(".") < 0 && extension != null && !"*".equals(extension)) {
            filename = filename + this.chainCertFileChooser.getSelectedFileFilter().getExtension();
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            data = certificate.getEncoded();
            fos.write(data);
            fos.close();
            return true;
        }
        catch (Exception e) {
            KeyStoreException kse = new KeyStoreException("ID21141: KeyStore error. " + e.getMessage());
            this.dumpErrorMessage("Store error", kse);
            return false;
        }
    }

    private void storeKeyEntry(CFileChooser fileChooser, String alias, String params) {
        String filename;
        ByteArrayOutputStream baos;
        byte[] data;
        block18: {
            JDialog dialog = new JDialog(this.frame, true);
            String[] files = fileChooser.showFileDialog("Store key entry", CFileChooser.LAST_DIR, false);
            if (files == null || files[0] == null) {
                return;
            }
            data = null;
            baos = new ByteArrayOutputStream();
            filename = files[0];
            try {
                String description = fileChooser.getSelectedFileFilter().getDescription();
                if (description.startsWith("Base64")) {
                    int findex = params.indexOf("format=") + 7;
                    params = params.substring(0, findex) + "BASE64_" + params.substring(findex);
                }
                if (description.startsWith("PKCS#12")) {
                    final JDialog pass = new JDialog((Dialog)dialog, true);
                    final JPasswordField pass1 = new JPasswordField();
                    final JPasswordField pass2 = new JPasswordField();
                    JButton button = new JButton("OK");
                    JButton label = new JButton("");
                    boolean passIsOk = false;
                    label.setEnabled(false);
                    button.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent event) {
                            if (pass1.getPassword().length != 0 && Arrays.equals(pass1.getPassword(), pass2.getPassword())) {
                                pass.hide();
                                pass.dispose();
                            } else {
                                ((JTextComponent)pass1).setText("");
                                ((JTextComponent)pass2).setText("");
                            }
                        }
                    });
                    Container box = pass.getContentPane();
                    box.setLayout(new GridLayout(3, 2));
                    box.add(new JLabel("Enter password:"));
                    box.add(pass1);
                    box.add(new JLabel("Confirm password:"));
                    box.add(pass2);
                    box.add(button);
                    box.add(label);
                    ((Component)pass).setSize(300, 100);
                    pass.setResizable(false);
                    pass.setLocationRelativeTo(dialog);
                    while (!passIsOk) {
                        pass.show();
                        pass.dispose();
                        passIsOk = new String(pass1.getPassword()).equals(new String(pass2.getPassword()));
                        if (passIsOk) continue;
                        label.setText("No match");
                    }
                    label.setText("");
                    int findex = params.indexOf("format=") + 7;
                    int toindex = params.indexOf(59, findex);
                    params = params.substring(0, findex) + "PKCS12" + params.substring(toindex) + new String(pass1.getPassword());
                    break block18;
                }
                try {
                    KeyStore keyStore = KeyStoreProvider.getKeyStore(this.selectedKeystoreViewAlias);
                    if (keyStore.isKeyEntry(alias)) {
                        Certificate[] chain = keyStore.getCertificateChain(alias);
                        int i = 0;
                        while (i < chain.length) {
                            this.storeChainCertificate(chain[i], i + 1);
                            ++i;
                        }
                    }
                }
                catch (Exception cee) {
                    this.dumpErrorMessage("Store error", new KeyStoreException("ID21107: Encoding exception. "));
                    return;
                }
            }
            catch (Exception e) {
                this.dumpErrorMessage("Error: ", e);
            }
        }
        try {
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
            try {
                KeyStore keyStore = KeyStoreProvider.getKeyStore(this.selectedKeystoreViewAlias);
                keyStore.store(baos, params.toCharArray());
            }
            catch (Exception e) {
                KeyStoreException kse = new KeyStoreException("ID21141: KeyStore error. " + e.getMessage());
                this.dumpErrorMessage("Store error", kse);
                Object var20_27 = null;
                this.frame.setCursor(Cursor.getDefaultCursor());
                return;
            }
            data = baos.toByteArray();
            if (filename.indexOf(".") < 0 && fileChooser.getSelectedFileFilter().getExtension() != null && !"*".equals(fileChooser.getSelectedFileFilter().getExtension())) {
                filename = filename + fileChooser.getSelectedFileFilter().getExtension();
            }
            try {
                FileOutputStream fos = new FileOutputStream(filename);
                fos.write(data);
                fos.close();
            }
            catch (FileNotFoundException fnfe) {
                this.dumpErrorMessage("Error:", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
                Object var20_28 = null;
                this.frame.setCursor(Cursor.getDefaultCursor());
                return;
            }
            catch (IOException ioe) {
                this.dumpErrorMessage("IO error:", ioe);
                Object var20_29 = null;
                this.frame.setCursor(Cursor.getDefaultCursor());
                return;
            }
            Object var20_30 = null;
            this.frame.setCursor(Cursor.getDefaultCursor());
        }
        catch (Throwable throwable) {
            Object var20_31 = null;
            this.frame.setCursor(Cursor.getDefaultCursor());
            throw throwable;
        }
    }

    private void store() {
        boolean isCertificate = false;
        KeystoreManagerListenerImpl.dump("store{ " + this.selectedKeystoreViewAlias + ", " + this.selectedKeystoreEntryAlias);
        try {
            isCertificate = !this.keystoreManager.isKeyEntry(this.selectedKeystoreViewAlias, this.selectedKeystoreEntryAlias);
        }
        catch (Exception kse) {
            KeystoreManagerListenerImpl.dump("store } EXC: " + kse);
            this.dumpErrorMessage("Can not determine the type of the entry. ", kse);
            return;
        }
        if (isCertificate) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("alias=");
            buffer.append(this.selectedKeystoreEntryAlias + ';');
            buffer.append("format=X509;");
            buffer.append("password=");
            this.storeKeyEntry(this.storeCertFileChooser, this.selectedKeystoreEntryAlias, buffer.toString());
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("alias=");
            buffer.append(this.selectedKeystoreEntryAlias + ';');
            buffer.append("format=PKCS8;");
            buffer.append("password=");
            this.storeKeyEntry(this.storeKeyFileChooser, this.selectedKeystoreEntryAlias, buffer.toString());
        }
    }

    /*
     * Loose catch block
     */
    public void write() {
        block19: {
            block18: {
                boolean bool = false;
                File f = null;
                RandomAccessFile raf = null;
                try {
                    bool = !this.keystoreManager.isKeyEntry(this.selectedKeystoreViewAlias, this.selectedKeystoreEntryAlias);
                }
                catch (Exception kse) {
                    this.dumpErrorMessage("Unexpected error: ", kse);
                    return;
                }
                if (!bool) break block18;
                String filename = JOptionPane.showInputDialog(this.frame, (Object)"Select or enter the name of the file: ");
                if (filename == null) {
                    return;
                }
                f = new File(filename);
                raf = new RandomAccessFile(f, "rw");
                KeyStoreEntry entry = (KeyStoreEntry)this.keystoreManager.readEntry(this.selectedKeystoreViewAlias, this.selectedKeystoreEntryAlias);
                raf.write(entry.getCertificate().toString().getBytes());
                Object var9_10 = null;
                try {
                    raf.close();
                }
                catch (IOException io) {
                    this.dumpErrorMessage("Warning: ", io);
                }
                break block19;
                {
                    catch (FileNotFoundException fnfe) {
                        this.dumpErrorMessage("Write error", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
                        Object var9_11 = null;
                        try {
                            raf.close();
                        }
                        catch (IOException io) {
                            this.dumpErrorMessage("Warning: ", io);
                        }
                        return;
                    }
                    catch (IOException ioe) {
                        this.dumpErrorMessage("Write error", new IOException("ID21182: " + ioe.getMessage()));
                        Object var9_12 = null;
                        try {
                            raf.close();
                        }
                        catch (IOException io) {
                            this.dumpErrorMessage("Warning: ", io);
                        }
                        return;
                    }
                    catch (Exception cee) {
                        this.dumpErrorMessage("Write error", new KeyStoreException("ID21107: Encoding exception."));
                        Object var9_13 = null;
                        try {
                            raf.close();
                        }
                        catch (IOException io) {
                            this.dumpErrorMessage("Warning: ", io);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_14 = null;
                    try {
                        raf.close();
                    }
                    catch (IOException io) {
                        this.dumpErrorMessage("Warning: ", io);
                    }
                    throw throwable;
                }
            }
            final JDialog dialog = new JDialog(this.frame, true);
            dialog.setTitle("Write key");
            final JComboBox<String> combo = new JComboBox<String>(new String[]{"Key", "Chain", "Both"});
            JLabel combolabel = new JLabel("Write:");
            JLabel filelabel = new JLabel("Filename:");
            final JTextField filename = new JTextField();
            JButton btn = new JButton("Write");
            btn.addActionListener(new ActionListener(){

                /*
                 * Unable to fully structure code
                 */
                public void actionPerformed(ActionEvent event) {
                    file = null;
                    raf1 = null;
                    flag = false;
                    switch (combo.getSelectedIndex()) {
                        case 2: {
                            flag = true;
                        }
                        case 0: {
                            try {
                                file = new File(filename.getText());
                                raf1 = new RandomAccessFile(file, "rw");
                            }
                            catch (FileNotFoundException fnfe) {
                                KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Write error", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
                                return;
                            }
                            catch (Exception ioe) {
                                KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Write error", new IOException("ID21182: " + ioe.getMessage()));
                            }
                            entry = (KeyStoreEntry)KeystoreManagerListenerImpl.access$300(KeystoreManagerListenerImpl.this).readEntry(KeystoreManagerListenerImpl.access$100(KeystoreManagerListenerImpl.this), KeystoreManagerListenerImpl.access$200(KeystoreManagerListenerImpl.this));
                            raf1.write(entry.getKey().toString().getBytes());
                            var8_11 = null;
                            try {
                                raf1.close();
                            }
                            catch (IOException io) {
                                KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                            }
                            ** GOTO lbl48
                            {
                                catch (Exception kse) {
                                    KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Write error. ", kse);
                                    var8_11 = null;
                                    try {
                                        raf1.close();
                                    }
                                    catch (IOException io) {
                                        KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                                    }
                                }
                            }
                            catch (Throwable var7_16) {
                                var8_12 = null;
                                try {
                                    raf1.close();
                                }
                                catch (IOException io) {
                                    KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                                }
                                throw var7_16;
                            }
lbl48:
                            // 4 sources

                            if (!flag) break;
                        }
                        case 1: {
                            chain = null;
                            entry = (KeyStoreEntry)KeystoreManagerListenerImpl.access$300(KeystoreManagerListenerImpl.this).readEntry(KeystoreManagerListenerImpl.access$100(KeystoreManagerListenerImpl.this), KeystoreManagerListenerImpl.access$200(KeystoreManagerListenerImpl.this));
                            chain = entry.getCertificateChain();
                            file = new File(filename.getText());
                            raf1 = new RandomAccessFile(file, "rw");
                            i = 0;
                            while (i < chain.length) {
                                raf1.write((chain[i].toString() + "\r\n").getBytes());
                                ++i;
                            }
                            var11_19 = null;
                            try {
                                raf1.close();
                            }
                            catch (Exception io) {
                                KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                            }
                            break;
                            {
                                catch (FileNotFoundException fnfe) {
                                    KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Write error", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
                                    var11_20 = null;
                                    try {
                                        raf1.close();
                                    }
                                    catch (Exception io) {
                                        KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                                    }
                                    return;
                                }
                                catch (IOException ioe) {
                                    KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Write error", new IOException("ID21182: " + ioe.getMessage()));
                                    var11_21 = null;
                                    try {
                                        raf1.close();
                                    }
                                    catch (Exception io) {
                                        KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                                    }
                                    return;
                                }
                                catch (Exception cee) {
                                    KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Write error", new KeyStoreException("ID21107: Encoding exception. "));
                                    var11_22 = null;
                                    try {
                                        raf1.close();
                                    }
                                    catch (Exception io) {
                                        KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                                    }
                                    return;
                                }
                            }
                            catch (Throwable var10_29) {
                                var11_23 = null;
                                try {
                                    raf1.close();
                                }
                                catch (Exception io) {
                                    KeystoreManagerListenerImpl.access$000(KeystoreManagerListenerImpl.this, "Warning: ", io);
                                }
                                throw var10_29;
                            }
                        }
                    }
                    dialog.dispose();
                }
            });
            Container box = dialog.getContentPane();
            box.setLayout(new GridLayout(3, 2));
            box.add(combolabel);
            box.add(combo);
            box.add(filelabel);
            box.add(filename);
            box.add(btn);
            ((Component)dialog).setSize(300, 100);
            dialog.setResizable(false);
            dialog.setLocationRelativeTo(this.frame);
            dialog.show();
        }
    }

    public void backup() {
        CFileChooser fileChooser = new CFileChooser(this.frame);
        fileChooser.addFileFilter(VIEW);
        String[] files = fileChooser.showFileDialog("Save view to file", CFileChooser.LAST_DIR, false);
        if (files == null || files[0] == null) {
            return;
        }
        String filename = files[0];
        if (filename == null) {
            return;
        }
        if (fileChooser.getSelectedFileFilter().equals(VIEW)) {
            filename = filename + fileChooser.getSelectedFileFilter().getExtension();
        }
        FileOutputStream fos = null;
        KeyStore keyStore = null;
        try {
            fos = new FileOutputStream(filename);
        }
        catch (FileNotFoundException fnfe) {
            this.dumpErrorMessage("Error", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
            return;
        }
        try {
            keyStore = KeyStoreProvider.getKeyStore(this.selectedKeystoreViewAlias);
            Enumeration<String> all = keyStore.aliases();
            while (all.hasMoreElements()) {
                String name = all.nextElement();
                try {
                    int i = 0;
                    while (i < name.length()) {
                        fos.write(name.charAt(i));
                        ++i;
                    }
                    fos.write(61);
                    keyStore.store(fos, ("alias=" + name + ';' + "format" + '=' + "EBSDKS" + ';').toCharArray());
                }
                catch (Exception e) {
                    throw new IOException("Cannot store the entry[" + name + "]: " + e);
                }
            }
            fos.flush();
        }
        catch (KeyStoreException ex) {
            this.dumpErrorMessage("Error: ", ex);
        }
        catch (Exception e) {
            this.dumpErrorMessage("Error:", e);
            return;
        }
    }

    /*
     * Loose catch block
     */
    public void backdown() {
        block12: {
            CFileChooser fileChooser = new CFileChooser(this.frame);
            fileChooser.addFileFilter(VIEW);
            String[] files = fileChooser.showFileDialog("Load view from file", CFileChooser.LAST_DIR, false);
            if (files == null || files[0] == null) {
                return;
            }
            String filename = files[0];
            if (filename == null) {
                return;
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(filename);
            }
            catch (FileNotFoundException fnfe) {
                this.dumpErrorMessage("Error:", new FileNotFoundException("ID21181: " + fnfe.getMessage()));
                return;
            }
            this.loadEntries(fis);
            this.keystoreManagerPanel.getSingleKeystoreViewPanel().refresh(this.selectedKeystoreViewAlias);
            Object var7_7 = null;
            try {
                fis.close();
            }
            catch (Exception e) {
                fis = null;
            }
            break block12;
            {
                catch (Exception kse) {
                    this.dumpErrorMessage("Error: ", kse);
                    Object var7_8 = null;
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        fis = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    fis.close();
                }
                catch (Exception e) {
                    fis = null;
                }
                throw throwable;
            }
        }
    }

    private void dumpErrorMessage(String message, Exception e) {
        String show = e != null ? e.getClass().getName() : "";
        int position = show.lastIndexOf(".") + 1;
        int end = show.lastIndexOf("Exception");
        StringBuffer buffer = new StringBuffer(show.length() - position);
        buffer.append(show.charAt(position));
        ++position;
        end = end < 0 ? show.length() : end;
        while (position < end) {
            if (Character.isUpperCase(show.charAt(position))) {
                buffer.append(" ");
                buffer.append(Character.toLowerCase(show.charAt(position)));
            } else {
                buffer.append(show.charAt(position));
            }
            ++position;
        }
        buffer.append(":\n");
        buffer.append(e.getMessage());
        JOptionPane.showMessageDialog(this.frame, buffer.toString(), message, 0);
    }

    private static final void dump(Object msg) {
    }

    private void loadEntries(InputStream stream) throws IOException {
        String name = null;
        while (stream.available() > 0) {
            name = "";
            char ch = (char)stream.read();
            while (ch != '\uffffffff' && ch != '=') {
                name = name + ch;
                ch = (char)stream.read();
            }
            try {
                Properties p = new Properties();
                KeyStoreSpiEntry entry = null;
                KeyStoreEntryCoder coder = KeyStoreEntryCoder.getCoder("EBSDKS");
                KeyStoreEntryCoder.setProperties(p);
                entry = coder.decode(stream);
                if (entry == null) continue;
                this.keystoreManager.writeEntry(this.selectedKeystoreViewAlias, name, entry);
            }
            catch (Exception e) {
                throw new IOException("Cannot load credential entry[" + name + "]: " + e);
            }
        }
    }

    static /* synthetic */ void access$000(KeystoreManagerListenerImpl x0, String x1, Exception x2) {
        x0.dumpErrorMessage(x1, x2);
    }

    static /* synthetic */ String access$100(KeystoreManagerListenerImpl x0) {
        return x0.selectedKeystoreViewAlias;
    }

    static /* synthetic */ String access$200(KeystoreManagerListenerImpl x0) {
        return x0.selectedKeystoreEntryAlias;
    }

    static /* synthetic */ KeystoreManagerManagement access$300(KeystoreManagerListenerImpl x0) {
        return x0.keystoreManager;
    }
}

