/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.gui.UserNode;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerPanel;
import com.sap.engine.services.keystore.interfaces.KeyStoreProvider;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import iaik.security.provider.IAIK;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KeyStoreControl
implements ChangeListener,
VisualRuntimeControl {
    private KeyStoreProvider ksprovider = null;
    private KeystoreManagerPanel keystoreManager = null;
    private boolean isInitialized = false;
    private Throwable iaik_install_error = null;

    public KeyStoreControl() {
        try {
            this.ksprovider = new KeyStoreProvider();
            this.ksprovider.install();
            IAIK.addAsJDK14Provider();
        }
        catch (Throwable err) {
            this.iaik_install_error = err;
        }
        this.keystoreManager = new KeystoreManagerPanel();
    }

    public JComponent getRuntimeControlComponent() {
        return this.keystoreManager.getPanel();
    }

    public JButton[] getRuntimeButtons() {
        return null;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public synchronized void setFrame(Frame frame) {
        this.keystoreManager.setFrame(frame);
        if (this.iaik_install_error != null) {
            JOptionPane.showMessageDialog(frame, this.iaik_install_error.toString(), "IAIK security library not found!", 0);
        }
    }

    public void freeResources() {
    }

    public void setUserTree(UserNode root) {
    }

    public void setTaskManager(EditorViewManager manager) {
    }

    public void setEnvironment(String editorToolName, Object environment) {
    }

    public synchronized void show(ManagementInterface ri) {
        if (!this.isInitialized) {
            this.keystoreManager.setKeystoreManager((KeystoreManagerManagement)ri);
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (this.keystoreManager != null) {
            this.keystoreManager.refresh();
        }
    }
}

