/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.KeystoreGUIComponent;
import com.sap.engine.services.keystore.admin.gui.KeystoreManagerListener;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Key;
import java.security.PrivateKey;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

class EntriesButtonPanel
extends JPanel
implements KeystoreGUIComponent,
ActionListener {
    static final String DELETE_BUTTON = "delete";
    static final String LOAD_BUTTON = "load";
    static final String STORE_BUTTON = "store";
    static final String BACKUP_BUTTON = "backup";
    static final String BACKDOWN_BUTTON = "backdown";
    static final String GENERATE_CSR_BUTTON = "generateCSR";
    static final String CREATE_BUTTON = "create";
    static final String RENAME_BUTTON = "rename";
    static final String SIGN_BUTTON = "sign";
    static final String IMPORT_BUTTON = "import";
    JButton deleteButton = null;
    JButton generateCSRButton = null;
    JButton loadButton = null;
    JButton storeButton = null;
    JButton backupButton = null;
    JButton backdownButton = null;
    JButton renameButton = null;
    JButton signButton = null;
    JButton importButton = null;
    JButton createButton = null;
    KeystoreManagerManagement keystoreManager = null;
    KeystoreManagerListener listener = null;

    public EntriesButtonPanel(KeystoreManagerManagement keystoreManager) {
        this.keystoreManager = keystoreManager;
        this.deleteButton = new JButton("Delete");
        this.generateCSRButton = new JButton("Generate CSR Request");
        this.loadButton = new JButton("Load");
        this.storeButton = new JButton("Export");
        this.backupButton = new JButton("Save to File");
        this.backdownButton = new JButton("Load from File");
        this.renameButton = new JButton("Rename");
        this.signButton = new JButton("Import CSR Response");
        this.importButton = new JButton("Import from Other");
        this.createButton = new JButton("Create");
    }

    public void registerKeystoreManagerListener(KeystoreManagerListener listener) {
        this.listener = listener;
        this.deleteButton.setActionCommand(DELETE_BUTTON);
        this.deleteButton.addActionListener(this);
        this.renameButton.setActionCommand(RENAME_BUTTON);
        this.renameButton.addActionListener(this);
        this.loadButton.setActionCommand(LOAD_BUTTON);
        this.loadButton.addActionListener(this);
        this.storeButton.setActionCommand(STORE_BUTTON);
        this.storeButton.addActionListener(this);
        this.backupButton.setActionCommand(BACKUP_BUTTON);
        this.backupButton.addActionListener(this);
        this.backdownButton.setActionCommand(BACKDOWN_BUTTON);
        this.backdownButton.addActionListener(this);
        this.generateCSRButton.setEnabled(false);
        this.generateCSRButton.setActionCommand(GENERATE_CSR_BUTTON);
        this.generateCSRButton.addActionListener(this);
        this.signButton.setActionCommand(SIGN_BUTTON);
        this.signButton.addActionListener(this);
        this.importButton.setActionCommand(IMPORT_BUTTON);
        this.importButton.addActionListener(this);
        this.createButton.setActionCommand(CREATE_BUTTON);
        this.createButton.addActionListener(this);
    }

    public void refresh() {
    }

    public void refresh(Object obj) {
        String[] viewAndEntry = (String[])obj;
        if ("DBMS_User_Store".equals(viewAndEntry[0])) {
            this.deleteButton.setEnabled(false);
            this.generateCSRButton.setEnabled(false);
            this.loadButton.setEnabled(false);
            this.backdownButton.setEnabled(false);
            this.renameButton.setEnabled(false);
            this.signButton.setEnabled(false);
            this.importButton.setEnabled(false);
            this.createButton.setEnabled(false);
            this.backupButton.setEnabled(true);
            if (viewAndEntry.length == 1) {
                this.storeButton.setEnabled(false);
            } else {
                this.storeButton.setEnabled(true);
            }
        } else if (viewAndEntry.length == 1) {
            this.enableAllButtons(false);
            this.backdownButton.setEnabled(true);
            this.loadButton.setEnabled(true);
            this.importButton.setEnabled(true);
            this.createButton.setEnabled(true);
            this.importButton.setEnabled(true);
        } else {
            boolean isKey;
            block10: {
                this.enableAllButtons(true);
                String keystoreViewAlias = viewAndEntry[0];
                String keystoreEntryAlias = viewAndEntry[1];
                isKey = false;
                Key key = null;
                try {
                    isKey = this.keystoreManager.isKeyEntry(keystoreViewAlias, keystoreEntryAlias);
                    if (!isKey) break block10;
                    key = this.keystoreManager.readEntry(keystoreViewAlias, keystoreEntryAlias).getKey();
                    boolean isPrivateKey = false;
                    try {
                        key = (PrivateKey)key;
                        isPrivateKey = true;
                    }
                    catch (ClassCastException _) {
                        isPrivateKey = false;
                    }
                    this.storeButton.setEnabled(isPrivateKey);
                }
                catch (Exception re) {
                    this.generateCSRButton.setEnabled(false);
                    this.signButton.setEnabled(false);
                }
            }
            this.generateCSRButton.setEnabled(isKey);
            this.signButton.setEnabled(isKey);
            this.createButton.setEnabled(true);
            this.importButton.setEnabled(true);
        }
    }

    public void placeComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ""));
        JPanel entryButtons = new JPanel();
        entryButtons.setLayout(new GridBagLayout());
        entryButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Entry "));
        entryButtons.add((Component)this.createButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        entryButtons.add((Component)this.renameButton, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        entryButtons.add((Component)this.deleteButton, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        entryButtons.add((Component)this.loadButton, new GridBagConstraints(0, 3, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        entryButtons.add((Component)this.storeButton, new GridBagConstraints(0, 4, 1, 1, 0.1, 0.1, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        JPanel viewButtons = new JPanel();
        viewButtons.setLayout(new GridBagLayout());
        viewButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " View "));
        viewButtons.add((Component)this.backupButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        viewButtons.add((Component)this.backdownButton, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        viewButtons.add((Component)this.importButton, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel csrButtons = new JPanel();
        csrButtons.setLayout(new GridBagLayout());
        csrButtons.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " CSR "));
        csrButtons.add((Component)this.generateCSRButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        csrButtons.add((Component)this.signButton, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)entryButtons, new GridBagConstraints(0, 0, 1, 2, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)viewButtons, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)csrButtons, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setFrame(Frame frame) {
    }

    public void actionPerformed(ActionEvent action) {
        String act = action.getActionCommand();
        if (act.equals(DELETE_BUTTON)) {
            this.listener.deleteEntry();
        } else if (act.equals(LOAD_BUTTON)) {
            this.listener.loadEntry();
        } else if (act.equals(STORE_BUTTON)) {
            this.listener.storeEntry();
        } else if (act.equals(BACKUP_BUTTON)) {
            this.listener.backup();
        } else if (act.equals(BACKDOWN_BUTTON)) {
            this.listener.backdown();
        } else if (act.equals(GENERATE_CSR_BUTTON)) {
            this.listener.generateCSR();
        } else if (act.equals(RENAME_BUTTON)) {
            this.listener.renameEntry();
        } else if (act.equals(SIGN_BUTTON)) {
            this.listener.signKey();
        } else if (act.equals(IMPORT_BUTTON)) {
            this.listener.importFromView();
        } else if (act.equals(CREATE_BUTTON)) {
            this.listener.createEntry();
        }
    }

    private void enableAllButtons(boolean isEnabled) {
        this.deleteButton.setEnabled(isEnabled);
        this.loadButton.setEnabled(isEnabled);
        this.storeButton.setEnabled(isEnabled);
        this.backupButton.setEnabled(isEnabled);
        this.backdownButton.setEnabled(isEnabled);
        this.generateCSRButton.setEnabled(isEnabled);
        this.renameButton.setEnabled(isEnabled);
        this.signButton.setEnabled(isEnabled);
        this.createButton.setEnabled(isEnabled);
        this.importButton.setEnabled(isEnabled);
    }
}

