/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.keystore.admin.gui;

import com.sap.engine.services.keystore.admin.gui.SecurityManagementPanel;
import com.sap.engine.services.keystore.interfaces.KeystoreManagerManagement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CodeSecurityManagementPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private KeystoreManagerManagement keystoreManager = null;
    private JList grantedDomains = null;
    private JList aviableDomains = null;
    private JButton grantButton = null;
    private JButton clearButton = null;
    private String selectedGrantedDomain = null;
    private String selectedAviableDomain = null;
    private String[] params = null;

    public CodeSecurityManagementPanel(KeystoreManagerManagement keystoreManager) throws RemoteException {
        this.keystoreManager = keystoreManager;
        this.grantedDomains = new JList();
        this.aviableDomains = new JList<String>(keystoreManager.getSecurityConnector().getApplicationDomainNames());
        this.grantedDomains.setSelectionMode(0);
        this.aviableDomains.setSelectionMode(0);
        this.grantedDomains.addListSelectionListener(this);
        this.aviableDomains.addListSelectionListener(this);
        this.grantButton = new JButton("Grant");
        this.clearButton = new JButton("Clear");
        this.grantButton.setActionCommand("Grant");
        this.grantButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.clearButton.setActionCommand("Clear");
        this.grantButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        JSplitPane listsPane = new JSplitPane();
        JScrollPane srollableGrantedDomains = new JScrollPane(this.grantedDomains);
        JScrollPane srollableAviableDomains = new JScrollPane(this.aviableDomains);
        srollableGrantedDomains.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " Granted Domains "));
        srollableAviableDomains.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), " All Domains "));
        listsPane.setLeftComponent(srollableGrantedDomains);
        listsPane.setRightComponent(srollableAviableDomains);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        buttonsPanel.add((Component)this.grantButton, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        buttonsPanel.add((Component)this.clearButton, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.setLayout(new BorderLayout());
        this.add((Component)listsPane, "Center");
        this.add((Component)buttonsPanel, "South");
    }

    public void setParams(String selectedCommand, String selectedView, String selectedEntry, String selectedProperty) throws RemoteException {
        try {
            int commandType = SecurityManagementPanel.getCommandType(selectedCommand);
            switch (commandType) {
                case 0: {
                    this.params = null;
                    this.grantButton.setEnabled(false);
                    this.clearButton.setEnabled(false);
                    break;
                }
                case 1: {
                    this.params = new String[]{selectedCommand};
                    break;
                }
                case 2: {
                    this.params = new String[]{selectedCommand, selectedView};
                    break;
                }
                case 3: {
                    this.params = new String[]{selectedCommand, selectedView, selectedEntry};
                    this.grantButton.setEnabled(selectedEntry != null);
                    this.clearButton.setEnabled(selectedEntry != null);
                    break;
                }
                case 4: {
                    this.params = new String[]{selectedCommand, selectedView, selectedProperty};
                    this.grantButton.setEnabled(selectedProperty != null);
                    this.clearButton.setEnabled(selectedProperty != null);
                    break;
                }
            }
            this.grantedDomains.removeAll();
            this.grantedDomains.setListData(this.getGrantedDomains(this.params));
            if (this.grantedDomains.getModel().getSize() > 0) {
                this.grantedDomains.setSelectedIndex(0);
                this.selectedGrantedDomain = (String)this.grantedDomains.getSelectedValue();
            }
            this.clearButton.setEnabled(this.grantedDomains.getModel().getSize() > 0);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private String[] getGrantedDomains(String[] params) {
        if (params[params.length - 1] == null) {
            return new String[0];
        }
        try {
            return this.keystoreManager.getSecurityConnector().getGrantedDomains(params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return new String[0];
        }
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.grantButton) {
                this.keystoreManager.getSecurityConnector().grantCodePermission(this.selectedAviableDomain, this.params);
            } else {
                this.keystoreManager.getSecurityConnector().clearCodePermission(this.selectedGrantedDomain, this.params);
            }
            this.grantedDomains.removeAll();
            this.grantedDomains.setListData(this.getGrantedDomains(this.params));
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        try {
            Object source = e.getSource();
            if (source == this.grantedDomains) {
                this.selectedGrantedDomain = (String)this.grantedDomains.getSelectedValue();
            } else {
                this.selectedAviableDomain = (String)this.aviableDomains.getSelectedValue();
            }
            this.grantButton.setEnabled(this.selectedAviableDomain != null);
            this.clearButton.setEnabled(this.selectedGrantedDomain != null);
            if (this.selectedGrantedDomain != null && this.selectedAviableDomain != null) {
                this.grantButton.setEnabled(!this.selectedAviableDomain.equals(this.selectedGrantedDomain));
            }
            if (this.params[this.params.length - 1] == null) {
                this.grantButton.setEnabled(false);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace(System.err);
        }
    }
}

