/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class JNDIUnbindServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length == 0 || s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        try {
            String loc;
            if (s.length == 1) {
                loc = s[0];
                loc = utl.modifyPath(loc);
                this.writer.println("[Shell -> UNBIND] Location : " + loc);
                if (ServCLUtils.ctx == null) {
                    this.writer.println("Trying to connect... ");
                    Properties p = new Properties();
                    ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                    ServCLUtils.ctx = new InitialDirContext(p);
                    this.writer.println("Connected.");
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
            ServCLUtils.ctx.unbind(loc);
            this.writer.println("[Shell -> UNBIND] Unbound.");
            this.writer.println();
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> UNBIND] NamingException");
            this.errorStream.println("[Shell -> UNBIND] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "UNBIND";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Unbinds the specified context." + ServCLUtils.newLineSeparator + "    Usage: UNBIND <location>" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the path to the location.";
    }
}

