/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class JNDIMSubServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length == 0 || s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        try {
            String loc;
            if (s.length == 1) {
                loc = s[0];
                loc = utl.modifyPath(loc);
                this.writer.println("[Shell -> MSUB] Location : " + loc);
                if (ServCLUtils.ctx == null) {
                    this.writer.println("Trying to connect... ");
                    Properties p = new Properties();
                    ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                    ServCLUtils.ctx = new InitialDirContext(p);
                    this.writer.println("Connected.");
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
            ServCLUtils.ctx.createSubcontext(loc, (Attributes)ServCLUtils.attributes);
            this.writer.println("[Shell -> MSUB] Created : " + loc);
            this.writer.println();
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> MSUB] NamingException");
            this.errorStream.println("[Shell -> MSUB] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "MSUB";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Creates a subcontext." + ServCLUtils.newLineSeparator + "    Usage: MSUB <location>" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the name of the new subcontext";
    }
}

