/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class JNDIMEnvServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        try {
            if (ServCLUtils.ctx == null) {
                this.writer.println("Trying to connect... ");
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ServCLUtils.ctx = new InitialDirContext(p);
                this.writer.println("Connected.");
            }
            if (s.length == 3) {
                if (s[0].equalsIgnoreCase("-a")) {
                    ServCLUtils.ctx.addToEnvironment(s[1], new String(s[2]));
                    this.writer.println("[Shell -> MENV] Added to environment \"" + s[1] + "\" with value \"" + s[2] + "\".");
                } else {
                    this.errorStream.println("[Shell -> MENV] Parameters not in the expected format !" + ServCLUtils.newLineSeparator);
                    this.writer.println(this.getHelpMessage());
                }
            } else if (s.length == 2) {
                if (s[0].equalsIgnoreCase("-r")) {
                    ServCLUtils.ctx.removeFromEnvironment(s[1]);
                    this.writer.println("[Shell - MENV] Removed from environment \"" + s[1] + "\" !");
                } else if (s[0].equalsIgnoreCase("-a")) {
                    ServCLUtils.ctx.addToEnvironment(s[1], new String());
                    this.writer.println("[Shell -> MENV] Added to environment \"" + s[1] + "\" as empty string !");
                } else {
                    this.errorStream.println("[Shell -> MENV] Parameters not in the expected format !" + ServCLUtils.newLineSeparator);
                    this.writer.println(this.getHelpMessage());
                }
            } else if (s.length == 1) {
                if (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
                    this.writer.println(this.getHelpMessage());
                } else {
                    this.errorStream.println("[Shell -> MENV] Parameters not in the expected format !" + ServCLUtils.newLineSeparator);
                    this.writer.println(this.getHelpMessage());
                }
            } else {
                Hashtable<?, ?> e = ServCLUtils.ctx.getEnvironment();
                if (e.size() != 0) {
                    this.writer.println("[Shell -> MENV] Prining the environment :" + ServCLUtils.newLineSeparator);
                    Enumeration<?> elEnum = e.elements();
                    Enumeration<?> kEnum = e.keys();
                    while (kEnum.hasMoreElements()) {
                        this.writer.println(kEnum.nextElement() + "=" + elEnum.nextElement());
                    }
                    this.writer.println();
                } else {
                    this.writer.println("[Shell -> MENV] The environment is empty !");
                }
            }
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> MENV] NamingException");
            this.errorStream.println("[Shell -> MENV] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "MENV";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Modifies or prints the JNDI's environment." + ServCLUtils.newLineSeparator + "    Usage: MENV [<-a|-r> <entry> [text]]" + ServCLUtils.newLineSeparator + "      Parameters:" + ServCLUtils.newLineSeparator + "        -a - Adds the entry." + ServCLUtils.newLineSeparator + "        -r - Removes the entry." + ServCLUtils.newLineSeparator + "        <entry> - Name of the item" + ServCLUtils.newLineSeparator + "        <text> - Value of the entry." + ServCLUtils.newLineSeparator + "    If no parameters specified prints the environment.";
    }
}

