/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.util.ArrayObject;
import com.sap.engine.lib.util.Stack;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;

public class JNDILsServ
implements Command {
    private NamingEnumeration ne = null;
    private String dummy = new String();
    private Stack st = null;
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();
    private static final int MAX_COLS = 80;

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length > 0 && (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?"))) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        try {
            Object ctx;
            String loc = null;
            boolean fullNames = false;
            boolean attributes = false;
            boolean details = false;
            if (s.length == 0) {
                loc = ServCLUtils.relativePath;
            } else {
                int i = 0;
                while (i < s.length) {
                    if (s[i].equalsIgnoreCase("-f")) {
                        if (!details) {
                            this.writer.println(this.getHelpMessage());
                            return;
                        }
                        fullNames = true;
                    } else if (s[i].equalsIgnoreCase("-a")) {
                        if (!details) {
                            this.writer.println(this.getHelpMessage());
                            return;
                        }
                        attributes = true;
                    } else if (s[i].equalsIgnoreCase("-l")) {
                        details = true;
                    } else if (loc == null) {
                        loc = s[i];
                        if (s.length > i + 1) {
                            this.writer.println(this.getHelpMessage());
                            return;
                        }
                    }
                    ++i;
                }
            }
            if (loc == null) {
                loc = ServCLUtils.relativePath;
            }
            loc = utl.modifyPath(loc);
            this.writer.println("[Shell -> LS] Location : " + loc);
            if (ServCLUtils.ctx == null) {
                this.writer.println("Trying to connect... ");
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ServCLUtils.ctx = new InitialDirContext(p);
                this.writer.println("Connected.");
            }
            if ((ctx = ServCLUtils.ctx.lookup(loc)) instanceof Context || ctx instanceof DirContext) {
                if (details) {
                    if (loc.charAt(0) == '/') {
                        loc = loc.substring(1);
                    }
                    this.writer.println();
                    this.printContext(loc, fullNames, attributes);
                    this.writer.println();
                } else {
                    this.printShort((DirContext)ctx);
                }
            } else {
                this.errorStream.println("[Shell -> LS] '" + loc + "' is not a context !");
            }
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> LS] NamingException");
            this.errorStream.println("[Shell -> LS] Reason : " + eNaming.getExplanation());
        }
    }

    public void printShort(DirContext ctx) throws NamingException {
        ArrayObject arr = new ArrayObject(10, 10);
        NamingEnumeration<NameClassPair> namingEnumeration = ctx.list("");
        int max = 0;
        while (namingEnumeration.hasMore()) {
            int lng;
            NameClassPair item = namingEnumeration.next();
            if (utl.isContext(item.getClassName())) {
                lng = item.getName().length() + 2;
                if (lng > max) {
                    max = lng;
                }
                arr.add("[" + item.getName() + "]");
                continue;
            }
            lng = item.getName().length();
            if (lng > max) {
                max = lng;
            }
            arr.add(item.getName());
        }
        if (arr.size() > 0) {
            this.outputFormatted(arr, max);
        } else {
            this.writer.println("[Shell -> LS] Context '" + ctx.getNameInNamespace() + "' is empty !");
        }
    }

    public void outputFormatted(ArrayObject array, int maxLong) {
        int columns = 79 / maxLong;
        int colWidth = 80 / columns;
        int printedSoFar = 0;
        this.writer.println();
        int i = 0;
        while (i < array.size()) {
            if (printedSoFar++ < columns) {
                String item = (String)array.elementAt(i);
                this.writer.print(item);
                int j = item.length();
                while (j < colWidth) {
                    this.writer.print(" ");
                    ++j;
                }
            } else {
                printedSoFar = 0;
                this.writer.println();
            }
            ++i;
        }
        this.writer.println();
    }

    void outputAttr(String kwo) throws NamingException {
        NamingEnumeration<? extends Attribute> atrbs = ServCLUtils.ctx.getAttributes(kwo).getAll();
        String atrName = new String();
        while (atrbs.hasMore()) {
            atrName = atrbs.next().toString();
            this.writer.print(atrName);
            if (!atrbs.hasMore()) continue;
            this.writer.print("; ");
        }
    }

    private void prnt(String nm, boolean fullNames, boolean showAttr) {
        try {
            while (this.ne.hasMoreElements()) {
                int i;
                int j;
                NameClassPair item = (NameClassPair)this.ne.next();
                if (utl.isContext(item.getClassName())) {
                    this.dummy = nm + "/" + item.getName();
                    j = utl.countDirNum(this.dummy) - 1;
                    i = 0;
                    while (i <= j) {
                        this.writer.print("  ");
                        ++i;
                    }
                    if (fullNames) {
                        this.writer.print(this.dummy + " *");
                    } else {
                        this.writer.print(item.getName() + " *");
                    }
                    if (showAttr) {
                        this.writer.print(" [");
                        this.outputAttr(this.dummy);
                        this.writer.println("]");
                    } else {
                        this.writer.println();
                    }
                    this.st.push(this.ne);
                    this.ne = ServCLUtils.ctx.list(this.dummy);
                    this.prnt(this.dummy, fullNames, showAttr);
                    this.ne = (NamingEnumeration)this.st.pop();
                    this.dummy = nm;
                    continue;
                }
                j = 0;
                if (this.dummy.length() != 0) {
                    j = utl.countDirNum(this.dummy) - 1;
                    this.writer.print("  ");
                }
                i = 0;
                while (i <= j) {
                    this.writer.print("  ");
                    ++i;
                }
                if (fullNames) {
                    if (this.dummy.length() != 0) {
                        this.writer.print(this.dummy + "/" + item.getName());
                    } else {
                        this.writer.print(item.getName());
                    }
                } else {
                    this.writer.print(item.getName());
                }
                if (showAttr) {
                    this.writer.print(" [");
                    this.outputAttr(this.dummy + '/' + item.getName());
                    this.writer.println("]");
                    continue;
                }
                this.writer.println();
            }
        }
        catch (NamingException e) {
            this.errorStream.println(ServCLUtils.newLineSeparator + "[Shell -> LS] Error when printing the tree !");
            this.errorStream.println("Reason : " + e.getExplanation() + ServCLUtils.newLineSeparator);
        }
        catch (NullPointerException ex) {
            this.errorStream.println(ServCLUtils.newLineSeparator + "[Shell -> LS] No such subcontext !");
        }
    }

    public void printContext(String nm, boolean full, boolean attrs) {
        try {
            if (ServCLUtils.ctx.lookup(nm) instanceof Context) {
                this.ne = ServCLUtils.ctx.list(nm);
                this.st = new Stack();
                if (nm.length() != 0) {
                    this.writer.print("  ");
                }
                this.writer.println("/" + nm + " *");
                this.dummy = nm;
                this.prnt(nm, full, attrs);
            } else {
                System.out.println(ServCLUtils.newLineSeparator + "[Shell -> LS] Not a subcontext !");
                System.out.println("[Shell -> LS] Object contains : " + ServCLUtils.ctx.lookup(nm));
            }
        }
        catch (NamingException e) {
            this.errorStream.println(ServCLUtils.newLineSeparator + "[Shell -> LS] Error while printing the tree !");
            this.errorStream.println("Reason : " + e.getExplanation() + ServCLUtils.newLineSeparator);
        }
        catch (NullPointerException ex) {
            this.errorStream.println(ServCLUtils.newLineSeparator + "[Shell -> LS] No such subcontext !");
        }
    }

    public String getName() {
        return "LS";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Lists the contents of the current context." + ServCLUtils.newLineSeparator + "     Usage: LS [-l [-a] [-f]] [location]" + ServCLUtils.newLineSeparator + "     Parameters:" + ServCLUtils.newLineSeparator + "       [-l] - Lists details." + ServCLUtils.newLineSeparator + "         [-a] - Shows the attributes. Can be used only with -l parameter." + ServCLUtils.newLineSeparator + "         [-f] - Shows the full names. Can be used only with -l parameter." + ServCLUtils.newLineSeparator + "       [location] - the path to the location." + ServCLUtils.newLineSeparator + "       If no parameters are specified, the current context is listed.";
    }
}

