/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class JNDIFindServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        try {
            String loc = new String("");
            String filter = new String("");
            int scope = 2;
            int count = 0;
            if (s.length == 0) {
                this.writer.println(this.getHelpMessage());
                return;
            }
            if (s.length == 1) {
                if (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
                    this.writer.println(this.getHelpMessage());
                    return;
                }
            } else {
                loc = s[0];
                filter = s[1];
                this.writer.println("[Shell -> FIND] Filter set to : \"" + filter + "\" !");
            }
            if (s.length == 4 || s.length == 6 || s.length == 2) {
                int i = 2;
                while (i < s.length) {
                    if (s[i].equalsIgnoreCase("-s")) {
                        String scopeStr = s[i + 1];
                        if (scopeStr.equalsIgnoreCase("OBJECT")) {
                            scope = 0;
                            this.writer.println("[Shell -> FIND] Object scope selected !");
                        }
                        if (scopeStr.equalsIgnoreCase("ONELEVEL")) {
                            scope = 1;
                            this.writer.println("[Shell -> FIND] One level scope selected !");
                        }
                        if (scopeStr.equalsIgnoreCase("SUBTREE")) {
                            scope = 2;
                            this.writer.println("[Shell -> FIND] Sub-tree scope selected !");
                        }
                    }
                    if (s[i].equalsIgnoreCase("-c")) {
                        try {
                            count = Integer.parseInt(s[i + 1]);
                            if (count != 0) {
                                this.writer.println("[Shell -> FIND] About to return " + count + " objects !");
                            } else {
                                this.writer.println("[Shell -> FIND] About to return all objects !");
                            }
                        }
                        catch (NumberFormatException e) {
                            count = 0;
                            this.writer.println("[Shell -> FIND] About to return all objects !");
                        }
                    }
                    ++i;
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
            if (ServCLUtils.ctx == null) {
                this.writer.println("Trying to connect... ");
                Properties p = new Properties();
                ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                ServCLUtils.ctx = new InitialDirContext(p);
                this.writer.println("Connected.");
            }
            loc = utl.modifyPath(loc);
            this.writer.println("[Shell -> FIND] Location : " + loc);
            if (ServCLUtils.ctx.lookup(loc) instanceof DirContext || ServCLUtils.ctx.lookup(loc) instanceof Context || scope == 0) {
                NamingEnumeration<SearchResult> ne = ServCLUtils.ctx.search(loc, filter, new SearchControls(scope, count, 0, null, true, false));
                this.writer.println(ServCLUtils.newLineSeparator + "[Shell -> FIND] Found :");
                while (ne.hasMore()) {
                    SearchResult sr = ne.next();
                    this.writer.println("+ " + sr.getName() + ServCLUtils.newLineSeparator + "  [Class name] " + sr.getClassName() + ServCLUtils.newLineSeparator + "  [Attributes] " + sr.getAttributes());
                }
            } else {
                this.writer.println(ServCLUtils.newLineSeparator + "[JNDIShell] Not a subcontext !");
            }
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> FIND] NamingException");
            this.errorStream.println("[Shell -> FIND] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "FIND";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Searches a location for matches with the attributes from ATTR." + ServCLUtils.newLineSeparator + "    Usage: FIND <location> <filter> [-s <scope>] [-c <count>]" + ServCLUtils.newLineSeparator + "    Parameters:" + ServCLUtils.newLineSeparator + "      <location> - the path to the location." + ServCLUtils.newLineSeparator + "      <filter> - Filter to use" + ServCLUtils.newLineSeparator + "      -s <scope> - Scope to search with (OBJECT, ONELEVEL, SUBTREE)" + ServCLUtils.newLineSeparator + "      -c <count> - Number of the returned items.";
    }
}

