/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.lib.util.RandomGenerator;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import com.sap.engine.services.jndi.shellcmd.shellutils.MyLRObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class JNDIBindServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();
    private RandomGenerator rnd = new RandomGenerator();

    public void exec(Environment env, InputStream is, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length == 0 || s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
            this.writer.println(this.getHelpMessage());
            return;
        }
        try {
            if (s.length == 2) {
                String loc = null;
                String txt = null;
                loc = s[0];
                txt = s[1];
                loc = utl.modifyPath(loc);
                this.writer.println("[Shell -> BIND] Location : " + loc);
                this.writer.println("[Shell -> BIND] Text : " + txt);
                if (ServCLUtils.ctx == null) {
                    this.writer.println("Trying to connect... ");
                    Properties p = new Properties();
                    ((Hashtable)p).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
                    ServCLUtils.ctx = new InitialDirContext(p);
                    this.writer.println("Connected.");
                }
                if (txt == null) {
                    ServCLUtils.ctx.bind(loc, null, (Attributes)ServCLUtils.attributes);
                    this.writer.println("[Shell -> BIND] Binded (EMPTY).");
                } else if (txt.toUpperCase().indexOf("CPO") != -1) {
                    ServCLUtils.ctx.bind(loc, ServCLUtils.ctx.lookup("naming"), (Attributes)ServCLUtils.attributes);
                    this.writer.println("[Shell -> BIND] Bound (CPO) Object.");
                } else if (txt.toUpperCase().indexOf("LRO") != -1) {
                    ServCLUtils.ctx.bind(loc, (Object)new MyLRObject(this.rnd.nextInt()), (Attributes)ServCLUtils.attributes);
                    this.writer.println("[Shell -> BIND] Bound (LRO) Object.");
                } else {
                    ServCLUtils.ctx.bind(loc, (Object)new String(txt), (Attributes)ServCLUtils.attributes);
                    this.writer.println("[Shell -> BIND] Bound (String).");
                }
            } else {
                this.writer.println(this.getHelpMessage());
                return;
            }
            this.writer.println();
        }
        catch (NamingException eNaming) {
            this.errorStream.println("[Shell -> BIND] NamingException");
            this.errorStream.println("[Shell -> BIND] Reason : " + eNaming.getExplanation());
        }
    }

    public String getName() {
        return "BIND";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Binds a string to the specified location." + ServCLUtils.newLineSeparator + "    Usage: BIND <location> <string>" + ServCLUtils.newLineSeparator + "      Parameters:" + ServCLUtils.newLineSeparator + "        <location> - the path to the location." + ServCLUtils.newLineSeparator + "        <string> - the text to bind.";
    }
}

