/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.shellcmd;

import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.Environment;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttributes;

public class JNDIAttrServ
implements Command {
    private PrintStream writer;
    private PrintStream errorStream;
    private static ServCLUtils utl = new ServCLUtils();

    public void exec(Environment env, InputStream input, OutputStream os, String[] s) {
        this.errorStream = new PrintStream(env.getErrorStream());
        this.writer = new PrintStream(os);
        if (s.length == 3) {
            if (s[0].equalsIgnoreCase("-a")) {
                if (ServCLUtils.attributes.get(s[1]) == null) {
                    ServCLUtils.attributes.put(s[1], s[2]);
                    this.writer.println("[Shell -> ATTR] Attribute \"" + s[1] + "\" is set to \"" + s[2] + "\".");
                } else {
                    ServCLUtils.attributes.get(s[1]).add(s[2]);
                    this.writer.println("[Shell -> ATTR] Added value : \"" + s[2] + "\" to attribute \"" + s[1] + "\".");
                }
            } else if (s[0].equalsIgnoreCase("-r")) {
                ServCLUtils.attributes.get(s[1]).remove(s[2]);
                this.writer.println("[Shell -> ATTR] Removed value : \"" + s[2] + "\" from attribute \"" + s[1] + "\".");
            } else {
                this.errorStream.println("[Shell -> ATTR] Parameters not in the expected format !" + ServCLUtils.newLineSeparator);
            }
        } else if (s.length == 2) {
            if (s[0].equalsIgnoreCase("-a")) {
                if (ServCLUtils.attributes.get(s[1]) == null) {
                    ServCLUtils.attributes.put(s[1], null);
                    this.writer.println("[Shell -> ATTR] Attribute \"" + s[1] + "\" is set. It has no values !");
                } else {
                    ServCLUtils.attributes.get(s[1]).clear();
                    this.writer.println("[Shell -> ATTR] Attribute \"" + s[1] + "\" is cleared !");
                }
            } else if (s[0].equalsIgnoreCase("-r")) {
                ServCLUtils.attributes.remove(s[1]);
                this.writer.println("[Shell -> ATTR] Attribute \"" + s[1] + "\" was removed !");
            } else {
                this.errorStream.println("[Shell -> ATTR] Parameters not in the expected format !" + ServCLUtils.newLineSeparator);
            }
        } else if (s.length == 1) {
            if (s[0].equalsIgnoreCase("-h") || s[0].equalsIgnoreCase("-help") || s[0].equals("-?")) {
                this.writer.println(this.getHelpMessage());
            } else if (s[0].equalsIgnoreCase("-r")) {
                ServCLUtils.attributes = new BasicAttributes();
            } else {
                this.writer.print("[Shell -> ATTR] Printing attribute ");
                if (ServCLUtils.attributes.get(s[0]) != null) {
                    this.writer.println(ServCLUtils.attributes.get(s[0]));
                } else {
                    this.writer.println();
                }
            }
        } else if (s.length == 0) {
            if (ServCLUtils.attributes.size() > 0) {
                this.writer.println("[Shell -> ATTR] Printing attributes : ");
                try {
                    NamingEnumeration<Attribute> namingEnumeration = ServCLUtils.attributes.getAll();
                    while (namingEnumeration.hasMore()) {
                        this.writer.print(ServCLUtils.newLineSeparator + "[Shell -> ATTR] Attribute " + namingEnumeration.next().toString());
                    }
                    this.writer.println();
                }
                catch (NamingException ne) {
                    this.writer.println();
                }
            } else {
                this.writer.println("[Shell -> ATTR] No attributes to print !");
            }
        } else {
            this.errorStream.println("[Shell -> ATTR] Parametes not in the expected format !" + ServCLUtils.newLineSeparator);
        }
        this.writer.println();
    }

    public String getName() {
        return "ATTR";
    }

    public String getGroup() {
        return "NAMING";
    }

    public String[] getSupportedShellProviderNames() {
        return new String[]{"InQMyShell"};
    }

    public String getHelpMessage() {
        return "  Modifies or prints the \"fake\" attributes." + ServCLUtils.newLineSeparator + "    Usage: ATTR [<attribute>|<-a|-r attibute [value]>|<-r>]" + ServCLUtils.newLineSeparator + "      Parameters:" + ServCLUtils.newLineSeparator + "        -a - Sets attribute or adds a value to attribute." + ServCLUtils.newLineSeparator + "        -r - Removes value/attribute/all attributes." + ServCLUtils.newLineSeparator + "        <attribute> - Attribute to modify or print." + ServCLUtils.newLineSeparator + "        <value> - Value to set/add/remove." + ServCLUtils.newLineSeparator + "      If no parameters are specified lists the attributes.";
    }
}

