/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.providerimpl;

import com.sap.engine.system.naming.provider.IResolver;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.StateFactory;

public class DefaultResolver
implements IResolver {
    private static Hashtable initialContextFactories = new Hashtable();
    private static Hashtable urlContextFactories = new Hashtable();
    private static Hashtable objectFactories = new Hashtable();
    private static Hashtable stateFactories = new Hashtable();

    public static void addInitialContextFactoryImpl(InitialContextFactory initialContextFactory) {
        String className = initialContextFactory.getClass().getName();
        if (initialContextFactories.get(className) == null) {
            initialContextFactories.put(className, initialContextFactory);
        }
    }

    public static void addURLContextFactoryImpl(ObjectFactory urlContextFactory) {
        String className = urlContextFactory.getClass().getName();
        if (urlContextFactories.get(className) == null) {
            urlContextFactories.put(className, urlContextFactory);
        }
    }

    public static void addObjectFactoryImpl(ObjectFactory objectFactory) {
        String className = objectFactory.getClass().getName();
        if (objectFactories.get(className) == null) {
            objectFactories.put(className, objectFactory);
        }
    }

    public static void addStateFactoryImpl(StateFactory stateFactory) {
        String className = stateFactory.getClass().getName();
        if (stateFactories.get(className) == null) {
            stateFactories.put(className, stateFactory);
        }
    }

    public InitialContextFactory getInitialContextFactory(Hashtable environment) throws NamingException {
        String factoryName = environment != null ? (String)environment.get("java.naming.factory.initial") : null;
        InitialContextFactory initialFactory = null;
        if (factoryName != null) {
            Hashtable hashtable = initialContextFactories;
            synchronized (hashtable) {
                initialFactory = (InitialContextFactory)initialContextFactories.get(factoryName);
            }
        }
        return initialFactory;
    }

    public ObjectFactory getURLContextFactory(String scheme, Hashtable env) throws NamingException {
        ObjectFactory factory = null;
        Hashtable hashtable = urlContextFactories;
        synchronized (hashtable) {
            factory = (ObjectFactory)urlContextFactories.get(scheme);
        }
        return factory;
    }

    public ObjectFactory getObjectFactory(String name) throws NamingException {
        ObjectFactory factory = null;
        Hashtable hashtable = objectFactories;
        synchronized (hashtable) {
            factory = (ObjectFactory)objectFactories.get(name);
        }
        return factory;
    }

    public StateFactory getStateFactory(String name) throws NamingException {
        StateFactory factory = null;
        Hashtable hashtable = stateFactories;
        synchronized (hashtable) {
            factory = (StateFactory)stateFactories.get(name);
        }
        return factory;
    }
}

