/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.pool;

import com.sap.engine.services.jndi.cache.HandleItem;
import com.sap.engine.services.jndi.persistent.exceptions.IllegalArgumentException;

public final class HandleItemPool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private HandleItem[] arrayOfHandles;

    public HandleItemPool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_INIT_SIZE_OR_RESIZE_PARAMETER, new Object[]{new Integer(initSize), new Integer(step)});
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfHandles = new HandleItem[this.initialSize];
        int i = 0;
        while (i < this.initialSize) {
            this.arrayOfHandles[i] = new HandleItem();
            ++i;
        }
        this.pos = this.initialSize - 1;
    }

    public synchronized HandleItem getObject() {
        return new HandleItem();
    }

    public synchronized void releaseObject(HandleItem han) {
    }

    public synchronized void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_RESIZE_PARAMETER, new Object[]{new Integer(step)});
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public synchronized void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException(IllegalArgumentException.WRONG_INIT_SIZE_PARAMETER, new Object[]{new Integer(initSize)});
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        int i = 0;
        while (i < this.pos) {
            this.arrayOfHandles[i] = null;
            ++i;
        }
    }

    public synchronized void forceShrink() {
        int usedElements = this.arrayOfHandles.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfHandles = new HandleItem[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfHandles.length != this.initialSize) {
            HandleItem[] tempArr = new HandleItem[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfHandles, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfHandles, 0, tempArr, 0, this.pos + 1);
                }
                int i = this.pos + 1;
                while (i < newPos) {
                    tempArr[i] = new HandleItem();
                    ++i;
                }
            }
            this.arrayOfHandles = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() {
        HandleItem[] tempArr = new HandleItem[this.arrayOfHandles.length + this.resizeStep];
        int i = 0;
        while (i < this.resizeStep) {
            tempArr[i] = new HandleItem();
            ++i;
        }
        this.arrayOfHandles = tempArr;
        this.pos = this.resizeStep - 1;
    }
}

