/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistentimpl.memory;

import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import java.io.Serializable;

public class JNDIHandleImpl
implements JNDIHandle,
Serializable {
    long cid;
    long oid;
    static final long serialVersionUID = 4523052135409476957L;

    public JNDIHandleImpl(long cid, long oid) {
        this.cid = cid;
        this.oid = oid;
    }

    public long getContainerID() {
        return this.cid;
    }

    public long getObjectID() {
        return this.oid;
    }

    public void setContainerID(long id) {
        this.cid = id;
    }

    public void setObjectID(long id) {
        this.oid = id;
    }

    public boolean isContainer() {
        return this.oid == -1L;
    }

    public JNDIHandle read(byte[] data) throws JNDIException {
        return (JNDIHandle)Serializator.toObject(data);
    }

    public byte[] write(JNDIHandle j) throws JNDIException {
        return Serializator.toByteArray(j);
    }

    public boolean isValidHandle() throws JNDIException {
        return true;
    }

    public int hashCode() {
        if (this.oid != -1L) {
            return (int)(this.cid + this.oid);
        }
        return (int)this.cid;
    }

    public boolean equals(Object obj) {
        return ((JNDIHandle)obj).getContainerID() == this.cid & ((JNDIHandle)obj).getObjectID() == this.oid;
    }
}

