/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistentimpl.memory;

public class IDGenerator {
    private int initialSize = 1000;
    private int[] initialIDs = null;
    private int counter = 1000;
    private int numberOfElementsInArray = 1000;

    public IDGenerator(int initialSize, int counterValue, int elementsInArray) {
        this.initialSize = initialSize;
        this.counter = counterValue;
        this.initialIDs = new int[initialSize];
        this.numberOfElementsInArray = elementsInArray;
        this.initArray();
    }

    private void initArray() {
        int i = 0;
        while (i < this.numberOfElementsInArray) {
            this.initialIDs[i] = i;
            ++i;
        }
    }

    public synchronized int getID() {
        if (this.numberOfElementsInArray != 0) {
            --this.numberOfElementsInArray;
            return this.initialIDs[this.numberOfElementsInArray];
        }
        this.initialIDs = new int[this.counter + 1];
        return this.counter++;
    }

    public synchronized void releaseID(int id) {
        if (this.numberOfElementsInArray < this.initialIDs.length) {
            this.initialIDs[this.numberOfElementsInArray] = id;
            ++this.numberOfElementsInArray;
        }
    }
}

