/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistent.exceptions;

import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.exception.BaseException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;

public class JNDIException
extends BaseException {
    public static final byte COMMON = -1;
    public static final byte NAME_ALREADY_BOUND = 0;
    private byte exceptionType;
    public static String CAN_NOT_ALLOW_OPERATION = "jndi_registry_0000";
    public static String GROUP_NOT_DEFINED_ON_THE_SERVER = "jndi_registry_0001";
    public static String USER_NOT_DEFINED_ON_THE_SERVER = "jndi_registry_0002";
    public static String PERMISSION_NOT_DEFINED_ON_THE_SERVER = "jndi_registry_0003";
    public static String CAN_NOT_DENY_OPERATION = "jndi_registry_0004";
    public static String CAN_NOT_GET_PRINCIPLES_FOR_PERMISSION = "jndi_registry_0005";
    public static String CAN_NOT_SERIALIZE_OBJECT = "jndi_registry_0006";
    public static String CAN_NOT_DESERIALIZE_OBJECT = "jndi_registry_0007";
    public static String OBJECT_ALREADY_BOUND = "jndi_registry_0008";
    public static String CAN_NOT_BIND_OBJECT = "jndi_registry_0009";
    public static String CAN_NOT_UNBIND_OBJECT = "jndi_registry_0010";
    public static String CAN_NOT_REBIND_OBJECT = "jndi_registry_0011";
    public static String CAN_NOT_RENAME_OBJECT = "jndi_registry_0012";
    public static String CAN_NOT_MOVE_OBJECT = "jndi_registry_0013";

    public JNDIException(String errorString) {
        super(JNDIResourceAccessor.category, 400, JNDIResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), errorString), null);
        this.exceptionType = (byte)-1;
    }

    public JNDIException(String errorString, Object[] args) {
        super(JNDIResourceAccessor.category, 400, JNDIResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), errorString, args), null);
        this.exceptionType = (byte)-1;
    }

    public JNDIException(String errorString, Object[] args, Throwable tr) {
        super(JNDIResourceAccessor.category, 400, JNDIResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), errorString, args), tr);
        this.exceptionType = (byte)-1;
    }

    public JNDIException(String errorString, Throwable tr) {
        super(JNDIResourceAccessor.category, 400, JNDIResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), errorString), tr);
        this.exceptionType = (byte)-1;
    }

    public JNDIException(String errorString, Object[] args, byte type) {
        super(JNDIResourceAccessor.category, 400, JNDIResourceAccessor.location, (LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), errorString, args), null);
        this.exceptionType = type;
    }

    public byte getExceptionType() {
        return this.exceptionType;
    }

    public void setExceptionType(byte type) {
        if (this.exceptionType == -1) {
            this.exceptionType = type;
        }
    }
}

