/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistent;

import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.system.naming.provider.LogHelper;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

public class JNDILogger
implements LogHelper {
    Location loc = null;
    Category cat = null;

    public JNDILogger(Location loc, Category cat) {
        this.loc = loc;
        this.cat = cat;
    }

    public boolean toLogPathInCategory() {
        return this.cat.bePath();
    }

    public boolean toLogPathInLocation() {
        return this.loc.bePath();
    }

    public boolean toLogInfoInCategory() {
        return this.cat.beInfo();
    }

    public boolean toLogInfoInLocation() {
        return this.loc.beInfo();
    }

    public boolean toLogErrorInCategory() {
        return this.cat.beError();
    }

    public boolean toLogErrorInLocation() {
        return this.loc.beError();
    }

    public boolean toLogFatalInCategory() {
        return this.cat.beFatal();
    }

    public boolean toLogFatalInLocation() {
        return this.loc.beFatal();
    }

    public boolean toLogDebugInCategory() {
        return this.cat.beDebug();
    }

    public boolean toLogDebugInLocation() {
        return this.loc.beDebug();
    }

    public boolean toLogWarningInCategory() {
        return this.cat.beWarning();
    }

    public boolean toLogWarningInLocation() {
        return this.loc.beWarning();
    }

    public void errorT(String message) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.cat.errorT(this.loc, formater.toString());
        }
    }

    public void errorT(String key, Object[] parameters) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.cat.errorT(this.loc, formater.toString());
        }
    }

    public void infoT(String message) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.cat.infoT(this.loc, formater.toString());
        }
    }

    public void infoT(String key, Object[] parameters) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.cat.infoT(this.loc, formater.toString());
        }
    }

    public void warningT(String message) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.cat.warningT(this.loc, formater.toString());
        }
    }

    public void warningT(String key, Object[] parameters) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.cat.warningT(this.loc, formater.toString());
        }
    }

    public void fatalT(String message) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.cat.fatalT(this.loc, formater.toString());
        }
    }

    public void fatalT(String key, Object[] parameters) {
        if (this.cat != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.cat.fatalT(this.loc, formater.toString());
        }
    }

    public void logError(String message) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.loc.errorT(formater.toString());
        }
    }

    public void logError(String key, Object[] parameters) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.loc.errorT(formater.toString());
        }
    }

    public void logInfo(String message) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.loc.infoT(formater.toString());
        }
    }

    public void logInfo(String key, Object[] parameters) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.loc.infoT(formater.toString());
        }
    }

    public void logDebug(String message) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.loc.debugT(formater.toString());
        }
    }

    public void logDEbug(String key, Object[] parameters) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.loc.debugT(formater.toString());
        }
    }

    public void logWarning(String message) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.loc.warningT(formater.toString());
        }
    }

    public void logWarning(String key, Object[] parameters) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.loc.warningT(formater.toString());
        }
    }

    public void logPath(String message) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), message);
            this.loc.pathT(formater.toString());
        }
    }

    public void logPath(String key, Object[] parameters) {
        if (this.loc != null) {
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), key, parameters);
            this.loc.pathT(formater.toString());
        }
    }

    public void logThrowable(Throwable throwable) {
        if (this.loc != null) {
            this.loc.throwing(throwable);
        }
    }

    public void logCatching(Throwable throwable) {
        if (this.loc != null) {
            this.loc.catching(throwable);
        }
    }

    public void logStringInPath(String s) {
        if (this.loc != null) {
            this.loc.infoT(s);
        }
    }

    public void logStringInInfo(String s) {
        if (this.loc != null) {
            this.loc.pathT(s);
        }
    }
}

