/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.persistent;

import com.sap.engine.interfaces.cross.ObjectReference;
import com.sap.engine.interfaces.cross.ObjectReferenceImpl;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.implclient.OffsetClientContext;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public abstract class CPOInputStream
extends ObjectInputStream {
    protected ClientContext context = null;

    public CPOInputStream(ByteArrayInputStream bais, ClientContext cc) throws IOException {
        super(bais);
        this.context = cc;
        this.enableResolveObject(true);
    }

    public Object resolveObject(Object obj) {
        try {
            if (obj instanceof ObjectReference) {
                this.context.setLastObj(true);
                if (this.context.referenceFactory != null && obj instanceof ObjectReferenceImpl) {
                    ((ObjectReferenceImpl)obj).setProtocolName(this.context.referenceFactory.protocolName());
                }
                Object robj = null;
                if (this.context instanceof OffsetClientContext) {
                    ClassLoader applicationClassLoader = ((OffsetClientContext)this.context).getApplicationClassLoader();
                    ClassLoader additionalClassLoader = ((OffsetClientContext)this.context).getAdditionalClassLoader();
                    if (additionalClassLoader != null) {
                        robj = ((ObjectReference)obj).toObject(additionalClassLoader, this.context.getRemoteContext());
                    }
                    if (robj == null && (robj = ((ObjectReference)obj).toObject(applicationClassLoader, this.context.getRemoteContext())) == null && (robj = ((ObjectReference)obj).toObject(this.getClass().getClassLoader(), this.context.getRemoteContext())) == null) {
                        robj = ((ObjectReference)obj).toObject(this.context.commonLoader, this.context.getRemoteContext());
                    }
                } else {
                    robj = ((ObjectReference)obj).toObject(this.getClass().getClassLoader(), this.context.getRemoteContext());
                    if (robj == null) {
                        robj = ((ObjectReference)obj).toObject(this.context.commonLoader, this.context.getRemoteContext());
                    }
                }
                if (robj == null) {
                    robj = ((ObjectReference)obj).toObject(Thread.currentThread().getContextClassLoader(), this.context.getRemoteContext());
                }
                return robj == null ? obj : robj;
            }
            return obj;
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            return obj;
        }
    }

    protected abstract Class resolveClass(ObjectStreamClass var1) throws IOException, ClassNotFoundException;

    protected final void readStreamHeader() throws IOException {
    }

    protected final Object readObjectOverride() throws ClassNotFoundException, IOException {
        Object obj = this.readObject();
        return obj;
    }
}

