/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implserver;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.implserver.ServerContextRedirectableImpl;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.persistent.JNDIHandle;
import com.sap.engine.services.jndi.persistent.JNDIHandleEnumeration;
import com.sap.engine.services.jndi.persistent.JNDIPersistentRepository;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.NoSuchElementException;
import java.rmi.RemoteException;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.rmi.PortableRemoteObject;

class ServerNamingEnumImpl
extends PortableRemoteObject
implements ServerNamingEnum {
    public static final byte TYPE_UNDEFINED = 0;
    public static final byte TYPE_BINDING = 1;
    public static final byte TYPE_NAMECLASSPAIR = 2;
    private boolean moreElements = true;
    private boolean remote;
    private Binding nextBinding = null;
    private NameClassPair nextNameClassPair = null;
    private Name rootName = null;
    JNDIHandleEnumeration je = null;
    JNDIPersistentRepository persistent = null;
    private byte type = 0;
    private boolean onlyLookupAllowed = false;
    private boolean redirectableContext = false;

    public ServerNamingEnumImpl(JNDIPersistentRepository persistent, JNDIHandleEnumeration je, byte type, Name rootName, boolean onlyLookupAllowed, boolean remote, boolean redirectable) throws RemoteException {
        this.remote = remote;
        this.onlyLookupAllowed = onlyLookupAllowed;
        this.je = je;
        this.type = type;
        this.persistent = persistent;
        this.rootName = rootName;
        this.redirectableContext = redirectable;
        try {
            this.next();
        }
        catch (javax.naming.NamingException ne) {
            JNDIFrame.log.logCatching(ne);
            com.sap.engine.services.jndi.persistent.exceptions.RemoteException re = new com.sap.engine.services.jndi.persistent.exceptions.RemoteException(com.sap.engine.services.jndi.persistent.exceptions.RemoteException.CANNOT_LIST_OR_LIST_BINDINGS, ne);
            re.log();
            throw re;
        }
    }

    public Object next() throws RemoteException, javax.naming.NamingException {
        if (!this.moreElements) {
            throw new NoSuchElementException(NoSuchElementException.NO_MORE_ELEMENTS_IN_ENUMERATION);
        }
        while (this.je.hasMoreElements()) {
            try {
                JNDIHandle jh = null;
                String objName = null;
                String className = null;
                Object object = null;
                jh = this.je.nextObject();
                objName = this.persistent.getObjectName(jh);
                if (objName == null) continue;
                byte[] dirObj = this.persistent.readObject(jh);
                JNDIHandle linkedContainer = this.persistent.getLinkedContainer(jh);
                if (linkedContainer != null) {
                    if (this.redirectableContext) {
                        object = new ServerContextRedirectableImpl(this.persistent.getNewConnection(), jh, linkedContainer, ((Name)this.rootName.clone()).add(objName), this.remote);
                        ((ServerContextRedirectableImpl)object).onlyLookUpAllowed = this.onlyLookupAllowed;
                    } else {
                        object = new ServerContextImpl(this.persistent.getNewConnection(), jh, linkedContainer, ((Name)this.rootName.clone()).add(objName), this.remote);
                        ((ServerContextImpl)object).onlyLookUpAllowed = this.onlyLookupAllowed;
                    }
                    className = "javax.naming.Context";
                } else {
                    object = dirObj;
                    className = DirObject.getClassName(object);
                }
                Binding oldBinding = this.nextBinding;
                NameClassPair oldNameClassPair = this.nextNameClassPair;
                this.nextBinding = new Binding(objName, null, object, true);
                this.nextNameClassPair = new NameClassPair(objName, className, true);
                switch (this.type) {
                    case 1: {
                        return oldBinding;
                    }
                    case 2: {
                        return oldNameClassPair;
                    }
                }
                return null;
            }
            catch (JNDIException e) {
                JNDIFrame.log.logCatching((Throwable)((Object)e));
                NamingException re = new NamingException(NamingException.CANNOT_LIST_OR_LIST_BINDINGS, (Throwable)((Object)e));
                re.log();
                throw re;
            }
        }
        this.je.closeEnumeration();
        this.moreElements = false;
        switch (this.type) {
            case 1: {
                return this.nextBinding;
            }
            case 2: {
                return this.nextNameClassPair;
            }
        }
        return null;
    }

    public boolean hasMore() throws RemoteException, javax.naming.NamingException {
        return this.moreElements;
    }

    public void close() throws RemoteException {
        this.je.closeEnumeration();
    }

    public void dump(String s) {
        System.out.println("type " + this.type + "  " + s);
    }
}

