/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implclient;

import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.persistent.exceptions.OperationNotSupportedException;
import java.util.Hashtable;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;

public class SynchronizedClientContext
implements DirContext {
    private ClientContext logicalSuper = null;

    public SynchronizedClientContext(ClientContext logicalSuper) {
        this.logicalSuper = logicalSuper;
    }

    protected static Name parse(String name) throws NamingException {
        return new CompositeName(name);
    }

    public synchronized Object lookup(Name name) throws NamingException {
        Object result = this.logicalSuper.lookup(name);
        if (result instanceof ClientContext) {
            return new SynchronizedClientContext((ClientContext)result);
        }
        return result;
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(SynchronizedClientContext.parse(name));
    }

    public void bind(String name, Object object, Attributes attributes) throws NamingException {
        this.bind(SynchronizedClientContext.parse(name), object, attributes);
    }

    public synchronized void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.logicalSuper.bind(name, object, attributes);
    }

    public void bind(String name, Object object) throws NamingException {
        this.bind(name, object, null);
    }

    public void bind(Name name, Object object) throws NamingException {
        this.bind(name, object, null);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name, object, null);
    }

    public void rebind(String name, Object object) throws NamingException {
        this.rebind(SynchronizedClientContext.parse(name), object, null);
    }

    public synchronized void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.logicalSuper.rebind(name, object, attributes);
    }

    public void rebind(String name, Object object, Attributes attributes) throws NamingException {
        this.rebind(SynchronizedClientContext.parse(name), object, attributes);
    }

    public synchronized void unbind(Name name) throws NamingException {
        this.logicalSuper.unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(SynchronizedClientContext.parse(name));
    }

    public synchronized void rename(Name oldName, Name newName) throws NamingException {
        this.logicalSuper.rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(SynchronizedClientContext.parse(oldName), SynchronizedClientContext.parse(newName));
    }

    public synchronized NamingEnumeration list(Name name) throws NamingException {
        return this.logicalSuper.list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(SynchronizedClientContext.parse(name));
    }

    public synchronized NamingEnumeration listBindings(Name name) throws NamingException {
        return this.logicalSuper.listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(SynchronizedClientContext.parse(name));
    }

    public synchronized void destroySubcontext(Name name) throws NamingException {
        this.logicalSuper.destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(SynchronizedClientContext.parse(name));
    }

    public synchronized DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return new SynchronizedClientContext((ClientContext)this.logicalSuper.createSubcontext(name, attributes));
    }

    public DirContext createSubcontext(String name, Attributes attributes) throws NamingException {
        return this.createSubcontext(SynchronizedClientContext.parse(name), attributes);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name, null);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(SynchronizedClientContext.parse(name), null);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(SynchronizedClientContext.parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public synchronized Attributes getAttributes(Name name) throws NamingException {
        return this.logicalSuper.getAttributes(name);
    }

    public synchronized Attributes getAttributes(Name name, String[] attributeIDs) throws NamingException {
        return this.logicalSuper.getAttributes(name, attributeIDs);
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(SynchronizedClientContext.parse(name));
    }

    public Attributes getAttributes(String name, String[] attributeIDs) throws NamingException {
        if (attributeIDs == null) {
            return this.getAttributes(SynchronizedClientContext.parse(name));
        }
        return this.getAttributes(SynchronizedClientContext.parse(name), attributeIDs);
    }

    public synchronized void modifyAttributes(Name name, int modificationOption, Attributes attributes) throws NamingException {
        this.logicalSuper.modifyAttributes(name, modificationOption, attributes);
    }

    public synchronized void modifyAttributes(Name name, ModificationItem[] modificationItems) throws NamingException {
        this.logicalSuper.modifyAttributes(name, modificationItems);
    }

    public void modifyAttributes(String name, int modificationOption, Attributes attrs) throws NamingException {
        this.modifyAttributes(SynchronizedClientContext.parse(name), modificationOption, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] modificationItems) throws NamingException {
        this.modifyAttributes(SynchronizedClientContext.parse(name), modificationItems);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(SynchronizedClientContext.parse(name), matchingAttributes, null);
    }

    public synchronized NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.logicalSuper.search(name, matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(SynchronizedClientContext.parse(name), matchingAttributes, attributesToReturn);
    }

    public synchronized NamingEnumeration search(Name name, String filterExpression, Object[] filterArguments, SearchControls searchControls) throws NamingException {
        return this.logicalSuper.search(name, filterExpression, filterArguments, searchControls);
    }

    public NamingEnumeration search(String name, String filterExpression, Object[] filterArguments, SearchControls searchControls) throws NamingException {
        return this.search(SynchronizedClientContext.parse(name), filterExpression, filterArguments, searchControls);
    }

    public NamingEnumeration search(Name name, String filterExpression, SearchControls searchControls) throws NamingException {
        return this.search(name, filterExpression, null, searchControls);
    }

    public NamingEnumeration search(String name, String filterExpression, SearchControls searchControls) throws NamingException {
        return this.search(SynchronizedClientContext.parse(name), filterExpression, null, searchControls);
    }

    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public synchronized Object addToEnvironment(String propertyName, Object propertyVal) throws NamingException {
        return this.logicalSuper.addToEnvironment(propertyName, propertyVal);
    }

    public synchronized Object removeFromEnvironment(String propertyName) throws NamingException {
        return this.logicalSuper.removeFromEnvironment(propertyName);
    }

    public synchronized Hashtable getEnvironment() throws NamingException {
        return this.logicalSuper.getEnvironment();
    }

    public synchronized void close() throws NamingException {
        this.logicalSuper.close();
    }

    public synchronized String getNameInNamespace() throws NamingException {
        return this.logicalSuper.getNameInNamespace();
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public synchronized Name composeName(Name name, Name prefix) throws NamingException {
        return this.logicalSuper.composeName(name, prefix);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(SynchronizedClientContext.parse(name));
    }

    public synchronized NameParser getNameParser(Name name) throws NamingException {
        return this.logicalSuper.getNameParser(name);
    }

    public boolean targetMustExist() {
        return true;
    }
}

