/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implclient;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.interfaces.security.auth.RemoteLoginContextFactory;
import com.sap.engine.interfaces.security.auth.RemoteLoginContextInterface;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.NamingCallbackHandler;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException;
import com.sap.engine.services.security.remote.login.RemoteLoginContext;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class LoginHelper {
    private RemoteLoginContextInterface loginContext;
    private LoginContext serverLoginContext;
    private int serverId = 0;

    public void serverSideLogin(Hashtable env) throws NoPermissionException {
        if (JNDIFrame.loginContext != null) {
            try {
                String user = (String)env.get("java.naming.security.principal");
                String pass = (String)env.get("java.naming.security.credentials");
                if (user == null && pass == null) {
                    user = SystemProperties.getProperty("_java.naming.security.principal");
                    pass = SystemProperties.getProperty("_java.naming.security.credentials");
                }
                if (JNDIFrame.loginContext != null && !this.checkForNullCredentials(env)) {
                    this.serverLoginContext = JNDIFrame.loginContext.getLoginContext(null, new NamingCallbackHandler(env));
                    this.serverLoginContext.login();
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_LOGIN, new Object[]{env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
                    }
                }
            }
            catch (LoginException le) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NoPermissionException.LOGIN_EXCEPTION_IN_GETTING_INITIAL_CONTEXT);
                    JNDIFrame.log.logCatching(le);
                }
                NoPermissionException npe = new NoPermissionException(NoPermissionException.LOGIN_EXCEPTION_IN_GETTING_INITIAL_CONTEXT, le);
                npe.setRootCause(le);
                npe.log();
                throw npe;
            }
        }
    }

    public void clientSideLogin(Hashtable env, String connType, String host, int port) throws LoginException {
        if (!this.checkForNullCredentials(env)) {
            this.loginContext = new RemoteLoginContext(new NamingCallbackHandler(env), "service.naming", connType, host, port);
            this.loginContext.login();
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_LOGIN, new Object[]{env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
            }
        }
    }

    public void serverSideLogin(Hashtable env, String connType, String host, int port) throws LoginException {
        if (!this.checkForNullCredentials(env)) {
            this.loginContext = RemoteLoginContextFactory.getFactory().getRemoteLoginContext(new NamingCallbackHandler(env), "service.naming", connType, host, port);
            this.loginContext.login();
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_LOGIN, new Object[]{env.get("java.naming.security.principal") != null ? env.get("java.naming.security.principal") : "N/A"});
            }
        }
    }

    public void logout() throws NoPermissionException {
        try {
            if (this.loginContext != null) {
                this.loginContext.logout();
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_LOGOUT);
                }
            } else if (this.serverLoginContext != null) {
                this.serverLoginContext.logout();
            }
        }
        catch (LoginException le) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.FAILED_TO_LOGOUT);
                JNDIFrame.log.logCatching(le);
            }
            NoPermissionException npe = new NoPermissionException(JNDILogConstants.FAILED_TO_LOGOUT, le);
            npe.setRootCause(le);
            npe.log();
            throw npe;
        }
    }

    private boolean checkForNullCredentials(Hashtable env) {
        if (env.get("java.naming.security.principal") == null && env.get("java.naming.security.credentials") == null) {
            String key = null;
            Enumeration properties = env.keys();
            while (properties.hasMoreElements()) {
                key = (String)properties.nextElement();
                if (!key.startsWith("sap.security.credential.") || env.get(key) == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int getServerId() {
        if (this.loginContext != null) {
            try {
                this.serverId = this.loginContext.getServerId();
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                this.serverId = 0;
            }
        }
        return this.serverId;
    }
}

