/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implclient;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.RemoteServiceReference;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.implclient.LoginHelper;
import com.sap.engine.services.jndi.implserver.ServerContextInface;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.NoSuchElementException;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchResult;

public class ClientNamingEnum
implements Enumeration,
NamingEnumeration,
Serializable {
    static final long serialVersionUID = -3548747230052206539L;
    ServerNamingEnum serverEnum = null;
    ClientContext context;
    Name rootName = null;
    Hashtable env = null;
    boolean onServer = false;
    boolean alreadyClosed = false;
    public LoginHelper loginContext = null;

    public ClientNamingEnum(ClientContext context, ServerNamingEnum serverEnum, Name rootName, Hashtable env, boolean onServer, LoginHelper loginCtx) {
        this.context = context;
        this.serverEnum = serverEnum;
        this.rootName = rootName;
        this.env = env;
        this.onServer = onServer;
        this.loginContext = loginCtx;
    }

    public void close() throws javax.naming.NamingException {
        if (!this.alreadyClosed) {
            try {
                this.serverEnum.close();
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
        }
    }

    public boolean hasMoreElements() {
        try {
            if (!this.serverEnum.hasMore()) {
                this.alreadyClosed = true;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            JNDIFrame.log.logCatching(ex);
            return false;
        }
    }

    public Object nextElement() {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException(NoSuchElementException.NO_MORE_ELEMENTS_IN_ENUMERATION);
        }
        try {
            Object obj = this.next();
            return obj;
        }
        catch (javax.naming.NamingException e) {
            if (JNDIFrame.log.toLogInfoInLocation()) {
                JNDIFrame.log.logInfo(RuntimeExceptionConstants.ERROR_IN_NAMING_ENUMERATION);
                JNDIFrame.log.logCatching(e);
            }
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.ERROR_IN_NAMING_ENUMERATION), (Throwable)e);
            bre.log();
            throw bre;
        }
    }

    public boolean hasMore() throws javax.naming.NamingException {
        try {
            if (!this.serverEnum.hasMore()) {
                this.alreadyClosed = true;
                return false;
            }
            return true;
        }
        catch (RemoteException ex) {
            if (JNDIFrame.log.toLogInfoInLocation()) {
                JNDIFrame.log.logInfo(RuntimeExceptionConstants.ERROR_IN_NAMING_ENUMERATION);
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.ERROR_IN_NAMING_ENUMERATION, ex);
            ne.log();
            throw ne;
        }
    }

    public Object next() throws javax.naming.NamingException {
        try {
            if (!this.hasMore()) {
                throw new NoSuchElementException(NoSuchElementException.NO_MORE_ELEMENTS_IN_ENUMERATION);
            }
            Object obj = this.serverEnum.next();
            if (obj instanceof SearchResult) {
                String classname;
                String name;
                Object object;
                block40: {
                    object = ((SearchResult)obj).getObject();
                    name = ((SearchResult)obj).getName();
                    classname = ((SearchResult)obj).getClassName();
                    if (object instanceof ServerContextInface) {
                        object = this.env != null ? new ClientContext((Hashtable)this.env.clone(), (ServerContextInface)object, ((Name)this.rootName.clone()).add(name), this.onServer, this.context.referenceFactory, this.loginContext) : new ClientContext(new Hashtable(), (ServerContextInface)object, ((Name)this.rootName.clone()).add(name), this.onServer, this.context.referenceFactory, this.loginContext);
                        classname = object.getClass().getName();
                    } else if (object != null) {
                        try {
                            if (object instanceof byte[]) {
                                object = this.context.deserializeDirObject((byte[])object);
                            }
                            try {
                                classname = ((DirObject)object).getClassName();
                                object = ((DirObject)object).getObject();
                                if (object instanceof RemoteServiceReference) {
                                    RemoteServiceReference rSR = null;
                                    try {
                                        rSR = (RemoteServiceReference)object;
                                        object = null;
                                        object = rSR.getServiceInterface();
                                        if (object == null) {
                                            object = rSR.isService() ? JNDIFrame.containerContext.getObjectRegistry().getServiceInterface(name) : JNDIFrame.containerContext.getObjectRegistry().getProvidedInterface(name);
                                        }
                                    }
                                    catch (Exception e) {
                                        JNDIFrame.log.logCatching(e);
                                        try {
                                            if (object == null) {
                                                object = rSR.isService() ? JNDIFrame.containerContext.getObjectRegistry().getServiceInterface(name) : JNDIFrame.containerContext.getObjectRegistry().getProvidedInterface(name);
                                            }
                                        }
                                        catch (Exception e2) {
                                            if (JNDIFrame.log.toLogInfoInLocation()) {
                                                JNDIFrame.log.logInfo(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name});
                                                JNDIFrame.log.logCatching(e2);
                                            }
                                            NamingException ne = new NamingException(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name}, e);
                                            ne.log();
                                            object = null;
                                        }
                                    }
                                }
                                if (object != null) {
                                    classname = object.getClass().getName();
                                    break block40;
                                }
                                classname = null;
                            }
                            catch (Exception e) {
                                JNDIFrame.log.logCatching(e);
                                object = null;
                            }
                        }
                        catch (Exception e) {
                            JNDIFrame.log.logCatching(e);
                            object = null;
                        }
                    }
                }
                obj = new SearchResult(name, classname, object, ((SearchResult)obj).getAttributes(), ((SearchResult)obj).isRelative());
            } else if (obj instanceof Binding) {
                Object object = ((Binding)obj).getObject();
                String name = ((Binding)obj).getName();
                String classname = "";
                if (object instanceof ServerContextInface) {
                    object = this.env != null ? new ClientContext((Hashtable)this.env.clone(), (ServerContextInface)object, ((Name)this.rootName.clone()).add(name), this.onServer, this.context.referenceFactory, this.loginContext) : new ClientContext(new Hashtable(), (ServerContextInface)object, ((Name)this.rootName.clone()).add(name), this.onServer, this.context.referenceFactory, this.loginContext);
                    classname = object.getClass().getName();
                } else {
                    try {
                        if (object instanceof byte[]) {
                            classname = DirObject.getClassName((byte[])object);
                            object = this.context.deserializeDirObject((byte[])object);
                        } else {
                            classname = ((DirObject)object).getClassName();
                        }
                        object = ((DirObject)object).getObject();
                        if (object instanceof RemoteServiceReference) {
                            RemoteServiceReference rSR = null;
                            try {
                                rSR = (RemoteServiceReference)object;
                                object = null;
                                object = rSR.getServiceInterface();
                                if (object == null) {
                                    object = rSR.isService() ? JNDIFrame.containerContext.getObjectRegistry().getServiceInterface(name) : JNDIFrame.containerContext.getObjectRegistry().getProvidedInterface(name);
                                }
                            }
                            catch (Exception e) {
                                JNDIFrame.log.logCatching(e);
                                try {
                                    if (object == null) {
                                        object = rSR.isService() ? JNDIFrame.containerContext.getObjectRegistry().getServiceInterface(name) : JNDIFrame.containerContext.getObjectRegistry().getProvidedInterface(name);
                                    }
                                }
                                catch (Exception e2) {
                                    if (JNDIFrame.log.toLogInfoInLocation()) {
                                        JNDIFrame.log.logInfo(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name});
                                        JNDIFrame.log.logCatching(e2);
                                    }
                                    NamingException ne = new NamingException(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name}, e);
                                    ne.log();
                                    object = null;
                                }
                            }
                        }
                        classname = object != null ? object.getClass().getName() : null;
                    }
                    catch (Exception e) {
                        JNDIFrame.log.logCatching(e);
                        object = null;
                        classname = "null";
                    }
                }
                obj = new Binding(name, classname, object, ((Binding)obj).isRelative());
            } else if (obj instanceof NameClassPair) {
                // empty if block
            }
            return obj;
        }
        catch (RemoteException e) {
            if (JNDIFrame.log.toLogInfoInLocation()) {
                JNDIFrame.log.infoT(NamingException.ERROR_IN_GETTING_NEXT_ELEMENT_OF_NAMING_ENUMERATION);
                JNDIFrame.log.logCatching(e);
            }
            NamingException ne = new NamingException(NamingException.ERROR_IN_GETTING_NEXT_ELEMENT_OF_NAMING_ENUMERATION, e);
            ne.log();
            throw ne;
        }
    }
}

