/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.implclient;

import com.sap.engine.lib.util.ConcurrentArrayObject;
import com.sap.engine.lib.util.ConcurrentHashMapObjectObject;
import com.sap.engine.services.jndi.ContextAdminInterface;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.RemoteServiceReference;
import com.sap.engine.services.jndi.cluster.DirObject;
import com.sap.engine.services.jndi.implclient.ClientNameParser;
import com.sap.engine.services.jndi.implclient.ClientNamingEnum;
import com.sap.engine.services.jndi.implclient.FullClientNamingEnum;
import com.sap.engine.services.jndi.implclient.LoginHelper;
import com.sap.engine.services.jndi.implclient.RemoteObjectReferenceFactory;
import com.sap.engine.services.jndi.implclient.Schema;
import com.sap.engine.services.jndi.implserver.ModifyAttributes;
import com.sap.engine.services.jndi.implserver.SearchFilter;
import com.sap.engine.services.jndi.implserver.ServerContextInface;
import com.sap.engine.services.jndi.implserver.ServerNamingEnum;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.RemoteSerializator;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.InvalidNameException;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.NameAlreadyBoundException;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import com.sap.engine.services.jndi.persistent.exceptions.OperationNotSupportedException;
import com.sap.engine.services.rmi_p4.P4ConnectionException;
import com.sap.engine.services.rmi_p4.P4RuntimeException;
import com.sap.localization.LocalizableTextFormatter;
import java.io.PrintStream;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NoPermissionException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.DirStateFactory;
import javax.naming.spi.DirectoryManager;
import javax.naming.spi.NamingManager;
import javax.rmi.PortableRemoteObject;

public class ClientContext
implements DirContext,
ContextAdminInterface,
Serializable {
    static final long serialVersionUID = 2116043629778868483L;
    private static final boolean DUMP_REFERENCES = false;
    private Hashtable localEnvironment;
    public ClassLoader commonLoader = null;
    protected Name fullNameInSpace = new CompositeName();
    protected ServerContextInface remoteContext;
    private static ConcurrentHashMapObjectObject referenceHash;
    public ConcurrentHashMapObjectObject remoteReferenceHash = null;
    public RemoteObjectReferenceFactory referenceFactory = null;
    private static ConcurrentHashMapObjectObject syntax;
    private boolean runOnServer = false;
    private boolean lastobj = true;
    public LoginHelper loginContext = null;
    static /* synthetic */ Class class$com$sap$engine$services$jndi$implclient$Schema;

    protected static Name parse(String name) throws javax.naming.NamingException {
        try {
            Schema sch = new Schema(name);
            return sch;
        }
        catch (javax.naming.NamingException ne) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name});
                JNDIFrame.log.logCatching(ne);
            }
            throw new NamingException(NamingException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name}, ne);
        }
    }

    public ClientContext(Hashtable environment, ServerContextInface remoteContext, Name name, boolean runOnServer, RemoteObjectReferenceFactory refrenceFactory, LoginHelper loginContext) throws javax.naming.NamingException {
        this.runOnServer = runOnServer;
        this.localEnvironment = environment != null ? (Hashtable)environment.clone() : null;
        this.remoteContext = remoteContext;
        this.fullNameInSpace = name;
        this.referenceFactory = refrenceFactory;
        this.loginContext = loginContext;
    }

    public ClientContext(Hashtable environment, ServerContextInface remoteContext, String name, boolean runOnServer, RemoteObjectReferenceFactory refrenceFactory, LoginHelper loginCtx) throws javax.naming.NamingException {
        this(environment, remoteContext, ClientContext.parse(name), runOnServer, refrenceFactory, loginCtx);
    }

    public ClientContext(Hashtable environment, ServerContextInface remoteContext, boolean runOnServer, RemoteObjectReferenceFactory refrenceFactory, LoginHelper loginCtx) throws javax.naming.NamingException {
        this.runOnServer = runOnServer;
        this.localEnvironment = environment != null ? (Hashtable)environment.clone() : null;
        this.remoteContext = remoteContext;
        this.fullNameInSpace = null;
        this.referenceFactory = refrenceFactory;
        this.loginContext = loginCtx;
    }

    /*
     * Unable to fully structure code
     */
    protected Name transformName(Name name) {
        if (name.size() != 0) ** GOTO lbl10
        return name;
lbl-1000:
        // 1 sources

        {
            try {
                name.remove(name.size() - 1);
                continue;
            }
            catch (Exception ex) {
                JNDIFrame.log.logCatching(ex);
                break;
            }
lbl10:
            // 2 sources

            ** while (name.size() > 0 && name.get((int)(name.size() - 1)).trim().equals((Object)""))
        }
lbl11:
        // 2 sources

        return name;
    }

    protected short checkOperation(Name name) {
        block6: {
            this.transformName(name);
            try {
                if (name.size() == 0) {
                    return 3;
                }
                String tempString = name.get(0).trim();
                if (tempString.length() == 0) {
                    name.remove(0);
                    return 3;
                }
                String toReplicate = (String)this.localEnvironment.get("Replicate");
                if (toReplicate != null && toReplicate.equals("true")) {
                    return 2;
                }
                if (tempString.equals("^") || tempString.equals("+")) {
                    name.remove(0);
                    return 3;
                }
            }
            catch (javax.naming.InvalidNameException e) {
                if (!JNDIFrame.log.toLogInfoInCategory()) break block6;
                JNDIFrame.log.infoT(NamingException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name});
                JNDIFrame.log.logCatching(e);
            }
        }
        return 3;
    }

    protected void verifyName(Name name) throws javax.naming.NamingException {
        if (name.size() > 0 && name.get(0).trim().equals("")) {
            try {
                name.remove(0);
            }
            catch (javax.naming.InvalidNameException ine) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name});
                    JNDIFrame.log.logCatching(ine);
                }
                throw new InvalidNameException(InvalidNameException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name}, ine);
            }
        }
        int i = 0;
        while (i < name.size()) {
            if (name.get(i).trim().equals("")) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name});
                }
                throw new InvalidNameException(InvalidNameException.NOT_CORRECT_NAME_PARAMETER, new Object[]{name});
            }
            ++i;
        }
    }

    public void setServerContext(ServerContextInface remoteContext) {
        this.remoteContext = remoteContext;
    }

    public Object lookup(Name name) throws javax.naming.NamingException {
        if ((class$com$sap$engine$services$jndi$implclient$Schema == null ? (class$com$sap$engine$services$jndi$implclient$Schema = ClientContext.class$("com.sap.engine.services.jndi.implclient.Schema")) : class$com$sap$engine$services$jndi$implclient$Schema).isAssignableFrom(name.getClass()) && ((Schema)name).isCname) {
            return this.lookupFromCosNaming(((Schema)name).getName());
        }
        name = this.transformName(name);
        this.verifyName(name);
        try {
            if (this.remoteContext == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                }
                throw new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            }
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            obj = (DirObject)RemoteSerializator.LROTable.get(fullPath);
            if (obj != null) {
                return obj.getObject();
            }
            short operationType = this.checkOperation(name);
            Object object = null;
            object = this.remoteContext.lookup(name, operationType);
            if (object instanceof ServerContextInface) {
                if (this.localEnvironment != null) {
                    Name fullName = (Name)(this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace).clone();
                    if (name.size() != 0) {
                        fullName.addAll(name);
                    }
                    object = new ClientContext((Hashtable)this.localEnvironment.clone(), (ServerContextInface)object, fullName, this.runOnServer, this.referenceFactory, this.loginContext);
                } else {
                    Name fullName = (Name)(this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace).clone();
                    if (name.size() != 0) {
                        fullName.addAll(name);
                    }
                    object = new ClientContext(new Hashtable(), (ServerContextInface)object, fullName, this.runOnServer, this.referenceFactory, this.loginContext);
                }
                return object;
            }
            if (object != null) {
                block59: {
                    block58: {
                        try {
                            byte[] data = (byte[])object;
                            DirObject dobj = this.deserializeDirObject(data);
                            object = dobj != null ? dobj.getObject() : null;
                        }
                        catch (Exception e) {
                            if (!JNDIFrame.log.toLogInfoInLocation()) break block58;
                            JNDIFrame.log.logInfo(JNDILogConstants.CANNOT_LOOKUP, new Object[]{name});
                            JNDIFrame.log.logCatching(e);
                        }
                    }
                    if (object instanceof Reference) {
                        Object temp = null;
                        try {
                            if (this.localEnvironment.get("server") != null) {
                                Thread thisThread = Thread.currentThread();
                                ClassLoader oldClassLoader = thisThread.getContextClassLoader();
                                String classLoaderName = ((Reference)object).getFactoryClassLocation();
                                ClassLoader loader = JNDIFrame.getClassLoader(classLoaderName != null ? classLoaderName : "");
                                if (classLoaderName != null && loader != null) {
                                    thisThread.setContextClassLoader(loader);
                                    try {
                                        temp = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                                        if (temp.equals(object)) {
                                            thisThread.setContextClassLoader(oldClassLoader);
                                            temp = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                                            if (temp.equals(object)) {
                                                ClassLoader namingClassLoader = this.getClass().getClassLoader();
                                                thisThread.setContextClassLoader(namingClassLoader);
                                                temp = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                                                if (temp.equals(object)) {
                                                    if (JNDIFrame.log.toLogInfoInCategory()) {
                                                        JNDIFrame.log.infoT(JNDILogConstants.CAN_NOT_LOAD_OBJECT_FACTORY, new Object[]{name, ((Reference)object).getFactoryClassLocation(), ((Reference)object).getFactoryClassName()});
                                                    }
                                                    if (JNDIFrame.log.toLogWarningInLocation()) {
                                                        JNDIFrame.log.logWarning(JNDILogConstants.CAN_NOT_LOAD_OBJECT_FACTORY, new Object[]{name, ((Reference)object).getFactoryClassLocation(), ((Reference)object).getFactoryClassName()});
                                                    }
                                                } else {
                                                    object = temp;
                                                }
                                            } else {
                                                object = temp;
                                            }
                                        } else {
                                            object = temp;
                                        }
                                        Object var13_30 = null;
                                        thisThread.setContextClassLoader(oldClassLoader);
                                        break block59;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_31 = null;
                                        thisThread.setContextClassLoader(oldClassLoader);
                                        throw throwable;
                                    }
                                }
                                try {
                                    temp = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                                    if (temp.equals(object)) {
                                        ClassLoader newClassLoader = this.getClass().getClassLoader();
                                        thisThread.setContextClassLoader(newClassLoader);
                                        temp = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                                        if (temp.equals(object)) {
                                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                                JNDIFrame.log.infoT(JNDILogConstants.CAN_NOT_LOAD_OBJECT_FACTORY, new Object[]{name, ((Reference)object).getFactoryClassLocation(), ((Reference)object).getFactoryClassName()});
                                            }
                                            if (JNDIFrame.log.toLogWarningInLocation()) {
                                                JNDIFrame.log.logWarning(JNDILogConstants.CAN_NOT_LOAD_OBJECT_FACTORY, new Object[]{name, ((Reference)object).getFactoryClassLocation(), ((Reference)object).getFactoryClassName()});
                                            }
                                        } else {
                                            object = temp;
                                        }
                                    } else {
                                        object = temp;
                                    }
                                    Object var15_33 = null;
                                    thisThread.setContextClassLoader(oldClassLoader);
                                    break block59;
                                }
                                catch (Throwable throwable) {
                                    Object var15_34 = null;
                                    thisThread.setContextClassLoader(oldClassLoader);
                                    throw throwable;
                                }
                            }
                            object = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                        }
                        catch (Exception e) {
                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                JNDIFrame.log.infoT(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name});
                                JNDIFrame.log.logCatching(e);
                            }
                            NamingException ne = new NamingException(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name}, e);
                            ne.setRootCause(e);
                            ne.log();
                            throw ne;
                        }
                    }
                }
                if (object instanceof RemoteServiceReference) {
                    RemoteServiceReference rSR = null;
                    try {
                        rSR = (RemoteServiceReference)object;
                        object = null;
                        object = rSR.getServiceInterface();
                        if (object == null) {
                            object = rSR.isService() ? JNDIFrame.containerContext.getObjectRegistry().getServiceInterface(name.get(name.size() - 1)) : JNDIFrame.containerContext.getObjectRegistry().getProvidedInterface(name.get(name.size() - 1));
                        }
                    }
                    catch (Exception e) {
                        JNDIFrame.log.logCatching(e);
                        try {
                            if (object == null) {
                                object = rSR.isService() ? JNDIFrame.containerContext.getObjectRegistry().getServiceInterface(name.get(name.size() - 1)) : JNDIFrame.containerContext.getObjectRegistry().getProvidedInterface(name.get(name.size() - 1));
                            }
                        }
                        catch (Exception e2) {
                            if (JNDIFrame.log.toLogInfoInCategory()) {
                                JNDIFrame.log.infoT(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name});
                                JNDIFrame.log.logCatching(e2);
                            }
                            NamingException ne = new NamingException(NamingException.CANNOT_RESOLVE_OBJECT_REFERENCE, new Object[]{name}, e);
                            ne.log();
                            object = null;
                        }
                    }
                }
            }
            Object result = null;
            try {
                result = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
            if (result == null) {
                try {
                    result = NamingManager.getObjectInstance(object, name, this, this.localEnvironment);
                }
                catch (Exception e) {
                    JNDIFrame.log.logCatching(e);
                }
            }
            return result != null ? result : object;
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"lookup", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(JNDILogConstants.CONNECTION_LOST, new Object[]{"lookup", name});
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"lookup", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(JNDILogConstants.CONNECTION_LOST, new Object[]{"lookup", name});
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"lookup", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(JNDILogConstants.NO_PERMISSION, new Object[]{"lookup", name}, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LOOKUP, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_LOOKUP, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public Object lookup(String name) throws javax.naming.NamingException {
        try {
            return this.lookup(ClientContext.parse(name));
        }
        catch (javax.naming.NamingException e) {
            javax.naming.NamingException ne = e;
            try {
                return this.lookup(ClientContext.parse("java:" + name));
            }
            catch (javax.naming.NamingException e1) {
                String ex = e1.getExplanation();
                String formater1 = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), JNDILogConstants.PATH_TO_OBJECT_DOES_NOT_EXISTS, new Object[]{"java:"}).toString();
                formater1 = formater1.substring(0, formater1.indexOf("java:") + 5);
                String formater2 = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), JNDILogConstants.NAME_NOT_FOUND_IN_LOOKUP, new Object[]{"java:"}).toString();
                formater2 = formater2.substring(0, formater2.indexOf("java:") + 5);
                if (ex.indexOf(formater1) != -1 || ex.indexOf(formater2) != -1) {
                    throw ne;
                }
                throw e1;
            }
        }
    }

    private Object lookupFromCosNaming(String name) throws javax.naming.NamingException {
        String protokol;
        block8: {
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.LOOKUP_FROM_COSNAMING, new Object[]{name});
            }
            protokol = "";
            try {
                protokol = name.substring(name.indexOf(58) + 1, name.indexOf(58, name.indexOf(58) + 1));
            }
            catch (Exception e) {
                if (!JNDIFrame.log.toLogInfoInCategory()) break block8;
                JNDIFrame.log.infoT(JNDILogConstants.CANNOT_LOOKUP, new Object[]{name});
                JNDIFrame.log.logCatching(e);
            }
        }
        if (!protokol.equals("iiop") && !protokol.equals("")) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.BAD_CORBA_NAME, new Object[]{name});
            }
            throw new NamingException(NamingException.BAD_CORBA_NAME, new Object[]{name});
        }
        Object obj = null;
        try {
            String url = name.substring(name.lastIndexOf(64) + 1, name.lastIndexOf(35));
            String objName = name.substring(name.lastIndexOf(35) + 1);
            Hashtable<String, String> prop = new Hashtable<String, String>(5);
            prop.put("java.naming.factory.initial", "com.sap.engine.services.jndi.CosNamingInitialContextFactoryImpl");
            prop.put("java.naming.provider.url", url);
            InitialContext ctx = new InitialContext(prop);
            obj = ctx.lookup(objName);
        }
        catch (javax.naming.NamingException ne) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LOOKUP, new Object[]{name});
                JNDIFrame.log.logCatching(ne);
            }
            throw new NamingException(NamingException.CANNOT_LOOKUP, new Object[]{name}, ne);
        }
        return obj;
    }

    public void bind(String name, Object object, Attributes attributes) throws javax.naming.NamingException {
        this.bind(ClientContext.parse(name), object, attributes);
    }

    public void bind(Name name, Object object, Attributes attributes) throws javax.naming.NamingException {
        if ((name = this.transformName(name)).size() == 0) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(InvalidNameException.CAN_NOT_BIND_EMPTY_NAME);
            }
            throw new InvalidNameException(InvalidNameException.CAN_NOT_BIND_EMPTY_NAME);
        }
        this.verifyName(name);
        Object temp = this.prepareStateToBind(name, object, attributes);
        if (temp instanceof DirStateFactory.Result) {
            object = ((DirStateFactory.Result)temp).getObject();
            attributes = ((DirStateFactory.Result)temp).getAttributes();
        } else {
            object = temp;
        }
        short operationType = this.checkOperation(name);
        try {
            Reference ref;
            if (object instanceof Referenceable && (ref = ((Referenceable)object).getReference()) != null) {
                object = ref;
            }
            if ((object instanceof PortableRemoteObject || object instanceof UnicastRemoteObject || object instanceof Remote) && operationType == 2) {
                operationType = 4;
            }
            if (this.remoteContext == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                }
                throw new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            }
            if (attributes == null) {
                attributes = new BasicAttributes();
            }
            DirObject dobj = new DirObject(attributes, object);
            byte[] data = null;
            try {
                String fullName;
                data = this.serializeDirObject(dobj);
                if (data == null) {
                    String fullName2;
                    String string = fullName2 = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
                    if (!RemoteSerializator.LROTable.containsKey(fullName2)) {
                        try {
                            this.remoteContext.lookup(name, operationType);
                        }
                        catch (javax.naming.NamingException ex) {
                            if (ex.getMessage().indexOf("Object not found in lookup") != -1) {
                                RemoteSerializator.LROTable.put(fullName2, dobj);
                                if (JNDIFrame.log.toLogPathInLocation()) {
                                    JNDIFrame.log.logPath(JNDILogConstants.PUT_OBJECT_IN_LRO_TABLE, new Object[]{fullName2, "bind"});
                                }
                                return;
                            }
                            throw ex;
                        }
                        if (JNDIFrame.log.toLogPathInLocation()) {
                            JNDIFrame.log.logPath(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                        }
                        throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                    }
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                    }
                    throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                }
                String string = fullName = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
                if (RemoteSerializator.LROTable.containsKey(fullName)) {
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                    }
                    throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                }
            }
            catch (P4ConnectionException pce) {
                throw pce;
            }
            catch (ServerException nsoe) {
                throw nsoe;
            }
            catch (javax.naming.NamingException ex) {
                throw ex;
            }
            catch (Exception e) {
                String fullName;
                JNDIFrame.log.logCatching(e);
                String string = fullName = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
                if (!RemoteSerializator.LROTable.containsKey(fullName)) {
                    try {
                        this.remoteContext.lookup(ClientContext.parse(fullName), operationType);
                    }
                    catch (P4ConnectionException pce) {
                        throw pce;
                    }
                    catch (ServerException nsoe) {
                        throw nsoe;
                    }
                    catch (Exception ex) {
                        RemoteSerializator.LROTable.put(fullName, dobj);
                        if (JNDIFrame.log.toLogPathInLocation()) {
                            JNDIFrame.log.logPath(JNDILogConstants.PUT_OBJECT_IN_LRO_TABLE, new Object[]{fullName, "bind"});
                        }
                        return;
                    }
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                    }
                    throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                }
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
                }
                throw new NameAlreadyBoundException(NameAlreadyBoundException.NAME_ALREADY_BOUND, new Object[]{name});
            }
            this.remoteContext.bind(name, data, operationType, this.lastobj);
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Bind", name});
            }
            if (this.lastobj && this.remoteReferenceHash != null) {
                this.addReference(name, this.remoteReferenceHash);
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"bind", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"bind", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (P4RuntimeException ex) {
            JNDIFrame.log.logCatching(ex);
            NamingException ne = new NamingException(NamingException.PROTOCOL_EXCEPTION, ex);
            ne.log();
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"bind", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_BIND, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_BIND, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_BIND, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public void bind(String name, Object object) throws javax.naming.NamingException {
        this.bind(name, object, null);
    }

    public void bind(Name name, Object object) throws javax.naming.NamingException {
        this.bind(name, object, null);
    }

    public void rebind(Name name, Object object) throws javax.naming.NamingException {
        this.rebind(name, object, null);
    }

    public void rebind(String name, Object object) throws javax.naming.NamingException {
        this.rebind(ClientContext.parse(name), object, null);
    }

    public void rebind(Name name, Object object, Attributes attributes) throws javax.naming.NamingException {
        if ((name = this.transformName(name)).size() == 0) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(InvalidNameException.CAN_NOT_REBIND_EMPTY_NAME);
            }
            throw new InvalidNameException(InvalidNameException.CAN_NOT_REBIND_EMPTY_NAME);
        }
        this.verifyName(name);
        Object temp = this.prepareStateToBind(name, object, attributes);
        if (temp instanceof DirStateFactory.Result) {
            object = ((DirStateFactory.Result)temp).getObject();
            attributes = ((DirStateFactory.Result)temp).getAttributes();
        } else {
            object = temp;
        }
        short operationType = this.checkOperation(name);
        try {
            byte[] data;
            block35: {
                Reference ref;
                if (object instanceof Referenceable && (ref = ((Referenceable)object).getReference()) != null) {
                    object = ref;
                }
                if ((object instanceof PortableRemoteObject || object instanceof UnicastRemoteObject || object instanceof Remote) && operationType == 2) {
                    operationType = 4;
                }
                if (this.remoteContext == null) {
                    if (JNDIFrame.log.toLogInfoInCategory()) {
                        JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                    }
                    throw new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
                }
                String fullName = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
                RemoteSerializator.LROTable.remove(fullName);
                DirObject dobj = new DirObject(attributes, object);
                if (object != null) {
                    dobj.setClassName(object.getClass().getName());
                } else {
                    dobj.setClassName("null");
                }
                data = null;
                try {
                    data = this.serializeDirObject(dobj);
                    if (data != null) break block35;
                    Object o = null;
                    try {
                        o = this.remoteContext.lookup(name, operationType);
                        this.remoteContext.unbind(name, operationType);
                    }
                    catch (NameNotFoundException ex) {
                        o = null;
                    }
                    RemoteSerializator.LROTable.put(fullName, dobj);
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(JNDILogConstants.PUT_OBJECT_IN_LRO_TABLE, new Object[]{fullName, "rebind"});
                    }
                    return;
                }
                catch (P4ConnectionException pce) {
                    throw pce;
                }
                catch (ServerException nsoe) {
                    throw nsoe;
                }
                catch (Exception e) {
                    JNDIFrame.log.logCatching(e);
                    try {
                        this.remoteContext.lookup(ClientContext.parse(fullName), operationType);
                        this.remoteContext.unbind(name, operationType);
                        RemoteSerializator.LROTable.put(fullName, dobj);
                        if (JNDIFrame.log.toLogPathInLocation()) {
                            JNDIFrame.log.logPath(JNDILogConstants.PUT_OBJECT_IN_LRO_TABLE, new Object[]{fullName, "rebind"});
                        }
                    }
                    catch (P4ConnectionException pce) {
                        throw pce;
                    }
                    catch (ServerException nsoe) {
                        throw nsoe;
                    }
                    catch (Exception ex) {
                        JNDIFrame.log.logCatching(ex);
                        RemoteSerializator.LROTable.put(fullName, dobj);
                        if (JNDIFrame.log.toLogPathInLocation()) {
                            JNDIFrame.log.logPath(JNDILogConstants.PUT_OBJECT_IN_LRO_TABLE, new Object[]{fullName, "bind"});
                        }
                        return;
                    }
                }
            }
            this.removeReference(name);
            this.remoteContext.rebind(name, data, operationType, this.lastobj);
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Rebind", name});
            }
            if (this.lastobj && this.remoteReferenceHash != null) {
                this.addReference(name, this.remoteReferenceHash);
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"rebind", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"rebind", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (P4RuntimeException ex) {
            JNDIFrame.log.logCatching(ex);
            NamingException ne = new NamingException(NamingException.PROTOCOL_EXCEPTION, ex);
            ne.log();
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"rebind", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_REBIND, ex);
                npe.setRootCause(ex);
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_REBIND, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_REBIND, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public void rebind(String name, Object object, Attributes attributes) throws javax.naming.NamingException {
        this.rebind(ClientContext.parse(name), object, attributes);
    }

    public void unbind(Name name) throws javax.naming.NamingException {
        if ((name = this.transformName(name)).size() == 0) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(InvalidNameException.CAN_NOT_UNBIND_EMPTY_NAME);
            }
            throw new InvalidNameException(InvalidNameException.CAN_NOT_UNBIND_EMPTY_NAME);
        }
        this.verifyName(name);
        try {
            if (this.remoteContext == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                }
                throw new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            }
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            obj = (DirObject)RemoteSerializator.LROTable.remove(fullPath);
            if (obj != null) {
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(JNDILogConstants.REMOVE_OBJECT_FROM_LRO_TABLE, new Object[]{fullPath});
                }
                return;
            }
            short operationType = this.checkOperation(name);
            this.removeReference(name);
            this.remoteContext.unbind(name, operationType);
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Unbind", name});
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"unbind", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"unbind", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"unbind", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_UNBIND, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_UNBIND, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_UNBIND, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public void unbind(String name) throws javax.naming.NamingException {
        this.unbind(ClientContext.parse(name));
    }

    public void rename(Name oldName, Name newName) throws javax.naming.NamingException {
        oldName = this.transformName(oldName);
        newName = this.transformName(newName);
        this.verifyName(newName);
        this.verifyName(oldName);
        try {
            if (this.remoteContext == null) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                }
                throw new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            }
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? oldName.toString() : this.getNameInNamespace() + "/" + oldName;
            obj = (DirObject)RemoteSerializator.LROTable.remove(fullPath);
            if (obj != null) {
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(JNDILogConstants.REMOVE_OBJECT_FROM_LRO_TABLE, new Object[]{fullPath});
                }
                String newPath = this.getNameInNamespace().equals("") ? newName.toString() : this.getNameInNamespace() + "/" + newName;
                RemoteSerializator.LROTable.put(newPath, obj);
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(JNDILogConstants.PUT_OBJECT_IN_LRO_TABLE, new Object[]{newPath, "rename"});
                }
                return;
            }
            this.checkOperation(newName);
            short operationType = this.checkOperation(oldName);
            Object reference = this.removeReference(oldName);
            if (reference != null && reference != null) {
                this.addReference(newName, reference);
            }
            this.remoteContext.rename(oldName, newName, operationType);
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Unbind", oldName});
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Rename", newName});
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"rename", newName});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"rename", newName});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"rename", newName});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_RENAME, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_RENAME, new Object[]{oldName, newName});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_RENAME, new Object[]{oldName, newName});
            ne.log();
            throw ne;
        }
    }

    public void rename(String oldName, String newName) throws javax.naming.NamingException {
        this.rename(ClientContext.parse(oldName), ClientContext.parse(newName));
    }

    public NamingEnumeration list(Name name) throws javax.naming.NamingException {
        name = this.transformName(name);
        try {
            short operationType = this.checkOperation(name);
            return new ClientNamingEnum(this, new FullClientNamingEnum(this.remoteContext.list(name, operationType, this.runOnServer), this.listLROTable(name)), this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace, this.localEnvironment, this.runOnServer, this.loginContext);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"list", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"list", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"list", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_LIST, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LIST, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_LIST, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    private ConcurrentArrayObject listBindingsLROTable(Name name) {
        ConcurrentArrayObject bindings = new ConcurrentArrayObject();
        DirObject obj = null;
        String objectName = "";
        String fullPath = "";
        try {
            String string = fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            if (fullPath.endsWith("/")) {
                fullPath = fullPath.substring(0, fullPath.length() - 1);
            }
        }
        catch (javax.naming.NamingException ne) {
            JNDIFrame.log.logCatching(ne);
            fullPath = "";
        }
        Object[] keys = RemoteSerializator.LROTable.getAllKeys();
        int i = 0;
        while (i < keys.length) {
            int index = ((String)keys[i]).lastIndexOf(47);
            if (index != -1) {
                String context = ((String)keys[i]).substring(0, index);
                if (fullPath.equals(context)) {
                    objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                    obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                    bindings.add(new Binding(objectName, obj));
                }
            } else if (fullPath.equals("") || fullPath.equals("/")) {
                obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                bindings.add(new Binding((String)keys[i], obj));
            }
            ++i;
        }
        return bindings;
    }

    private ConcurrentArrayObject listLROTable(Name name) {
        ConcurrentArrayObject bindings = new ConcurrentArrayObject();
        DirObject obj = null;
        String objectName = "";
        String fullPath = "";
        try {
            String string = fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            if (fullPath.endsWith("/")) {
                fullPath = fullPath.substring(0, fullPath.length() - 1);
            }
        }
        catch (javax.naming.NamingException ne) {
            fullPath = "";
        }
        Object[] keys = RemoteSerializator.LROTable.getAllKeys();
        int i = 0;
        while (i < keys.length) {
            int index = ((String)keys[i]).lastIndexOf(47);
            if (index != -1) {
                String context = ((String)keys[i]).substring(0, index);
                if (fullPath.equals(context)) {
                    objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                    obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                    bindings.add(new NameClassPair(objectName, obj.getClassName()));
                }
            } else if (fullPath.equals("") || fullPath.equals("/")) {
                obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                bindings.add(new NameClassPair((String)keys[i], obj.getClassName()));
            }
            ++i;
        }
        return bindings;
    }

    private ConcurrentArrayObject searchLROTable(Name name, Attributes matchingAttributes, String[] attrsToReturn) {
        int i;
        ConcurrentArrayObject searchResult = new ConcurrentArrayObject();
        ConcurrentArrayObject dobjs = new ConcurrentArrayObject();
        DirObject object = null;
        String fullPath = "";
        try {
            fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
        }
        catch (javax.naming.NamingException ne) {
            fullPath = "";
        }
        if (fullPath.endsWith("/")) {
            fullPath = fullPath.substring(0, fullPath.length() - 1);
        }
        Object[] keys = RemoteSerializator.LROTable.getAllKeys();
        String objectName = "";
        if (fullPath.endsWith("/") && fullPath.length() > 0) {
            i = 0;
            while (i < keys.length) {
                if (fullPath.equals(keys[i])) {
                    object = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                    objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                    dobjs.add(new Binding(objectName, object));
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < keys.length) {
                int index = ((String)keys[i]).lastIndexOf(47);
                if (index != -1) {
                    if (fullPath.equals(((String)keys[i]).substring(0, index))) {
                        objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                        object = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                        dobjs.add(new Binding(objectName, object));
                    }
                } else if (fullPath.equals("") || fullPath.equals("/")) {
                    object = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                    dobjs.add(new Binding((String)keys[i], object));
                }
                ++i;
            }
        }
        if (dobjs.size() == 0) {
            return searchResult;
        }
        Attributes attr = null;
        int i2 = 0;
        while (i2 < dobjs.size()) {
            block21: {
                attr = ((DirObject)((Binding)dobjs.get(i2)).getObject()).getAttributes();
                objectName = ((Binding)dobjs.get(i2)).getName();
                if (attr == null) {
                    attr = new BasicAttributes();
                }
                try {
                    if (ModifyAttributes.matchingAttributes(attr, matchingAttributes)) {
                        BasicAttributes selectedAttr = new BasicAttributes();
                        if (attrsToReturn != null) {
                            int n = 0;
                            while (n < attrsToReturn.length) {
                                selectedAttr.put(attr.get(attrsToReturn[n]));
                                ++n;
                            }
                            searchResult.add(new SearchResult(objectName, null, (Object)((DirObject)((Binding)dobjs.get(i2)).getObject()), selectedAttr));
                        } else {
                            searchResult.add(new SearchResult(objectName, null, (Object)((DirObject)((Binding)dobjs.get(i2)).getObject()), attr));
                        }
                    }
                }
                catch (Exception ex) {
                    if (!JNDIFrame.log.toLogInfoInCategory()) break block21;
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_SEARCH, new Object[]{name});
                    JNDIFrame.log.logCatching(ex);
                }
            }
            ++i2;
        }
        return searchResult;
    }

    private ConcurrentArrayObject searchLROTable(Name name, String filter, Object[] filterArgs, SearchControls cons) {
        String className;
        SearchFilter searchFilter;
        Attributes attr;
        String objectName;
        ConcurrentArrayObject dobjs;
        ConcurrentArrayObject searchResult;
        block35: {
            int i;
            searchResult = new ConcurrentArrayObject();
            dobjs = new ConcurrentArrayObject();
            DirObject obj = null;
            objectName = "";
            String fullPath = "";
            try {
                fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            }
            catch (javax.naming.NamingException ne) {
                JNDIFrame.log.logCatching(ne);
                fullPath = "";
            }
            if (fullPath.endsWith("/")) {
                fullPath = fullPath.substring(0, fullPath.length() - 1);
            }
            Object[] keys = RemoteSerializator.LROTable.getAllKeys();
            if (cons.getSearchScope() == 0) {
                i = 0;
                while (i < keys.length) {
                    if (fullPath.equals(keys[i])) {
                        obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                        objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                        dobjs.add(new Binding(objectName, obj));
                    }
                    ++i;
                }
            } else if (cons.getSearchScope() == 1) {
                i = 0;
                while (i < keys.length) {
                    int index = ((String)keys[i]).lastIndexOf(47);
                    if (index != -1) {
                        String context = ((String)keys[i]).substring(0, index);
                        if (fullPath.equals(context)) {
                            objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                            obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                            dobjs.add(new Binding(objectName, obj));
                        }
                    } else if ((fullPath.equals("") || fullPath.equals("/")) && ((String)keys[i]).indexOf("/") == -1) {
                        obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                        dobjs.add(new Binding((String)keys[i], obj));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < keys.length) {
                    if (((String)keys[i]).indexOf(fullPath) == 0) {
                        objectName = ((String)keys[i]).substring(((String)keys[i]).lastIndexOf(47) + 1);
                        obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                        dobjs.add(new Binding(objectName, obj));
                    } else if (fullPath.equals("") || fullPath.equals("/")) {
                        obj = (DirObject)RemoteSerializator.LROTable.get(keys[i]);
                        dobjs.add(new Binding((String)keys[i], obj));
                    }
                    ++i;
                }
            }
            if (dobjs.size() == 0) {
                return searchResult;
            }
            attr = null;
            searchFilter = null;
            className = "";
            try {
                if (filterArgs != null) {
                    String formattedFilter = SearchFilter.format(filter, filterArgs);
                    searchFilter = new SearchFilter(formattedFilter);
                } else {
                    searchFilter = new SearchFilter(filter);
                }
            }
            catch (javax.naming.NamingException ex) {
                if (!JNDIFrame.log.toLogInfoInCategory()) break block35;
                JNDIFrame.log.infoT(JNDILogConstants.CANNOT_SEARCH, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
        }
        int i = 0;
        while (i < dobjs.size()) {
            block36: {
                attr = ((DirObject)((Binding)dobjs.get(i)).getObject()).getAttributes();
                objectName = ((Binding)dobjs.get(i)).getName();
                if (attr == null) {
                    attr = new BasicAttributes();
                }
                className = ((DirObject)((Binding)dobjs.get(i)).getObject()).getClassName();
                try {
                    if (searchFilter.check(attr)) {
                        BasicAttributes selectedAttr = new BasicAttributes();
                        String[] attrsToReturn = cons.getReturningAttributes();
                        if (attrsToReturn != null) {
                            int j = 0;
                            while (j < attrsToReturn.length) {
                                selectedAttr.put(attr.get(attrsToReturn[i]));
                                ++j;
                            }
                            if (cons.getReturningObjFlag()) {
                                searchResult.add(new SearchResult(objectName, className, dobjs.get(i), selectedAttr));
                            } else {
                                searchResult.add(new SearchResult(objectName, className, null, selectedAttr));
                            }
                        } else if (cons.getReturningObjFlag()) {
                            searchResult.add(new SearchResult(objectName, className, dobjs.get(i), attr));
                        } else {
                            searchResult.add(new SearchResult(objectName, className, null, attr));
                        }
                    }
                }
                catch (javax.naming.NamingException ex) {
                    if (!JNDIFrame.log.toLogInfoInCategory()) break block36;
                    JNDIFrame.log.infoT(JNDILogConstants.CANNOT_SEARCH, new Object[]{name});
                    JNDIFrame.log.logCatching(ex);
                }
            }
            ++i;
        }
        return searchResult;
    }

    public NamingEnumeration list(String name) throws javax.naming.NamingException {
        return this.list(ClientContext.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws javax.naming.NamingException {
        name = this.transformName(name);
        try {
            short operationType = this.checkOperation(name);
            return new ClientNamingEnum(this, new FullClientNamingEnum(this.remoteContext.listBindings(name, operationType, this.runOnServer), this.listBindingsLROTable(name)), this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace, this.localEnvironment, this.runOnServer, this.loginContext);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"listBindings", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"listBindings", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"listBindings", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_LIST_BINDINGS, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_LIST_BINDINGS, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_LIST_BINDINGS, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public NamingEnumeration listBindings(String name) throws javax.naming.NamingException {
        return this.listBindings(ClientContext.parse(name));
    }

    public void destroySubcontext(Name name) throws javax.naming.NamingException {
        name = this.transformName(name);
        this.verifyName(name);
        try {
            short operationType = this.checkOperation(name);
            this.remoteContext.destroySubcontext(name, operationType);
            if (JNDIFrame.log.toLogPathInLocation()) {
                JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Destroy subcontext", name});
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"destroySubcontext", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"destroySubcontext", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"destroySubcontext", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_DESTROY_SUBCONTEXT, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_DESTROY_SUBCONTEXT, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_DESTROY_SUBCONTEXT, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public void destroySubcontext(String name) throws javax.naming.NamingException {
        this.destroySubcontext(ClientContext.parse(name));
    }

    public DirContext createSubcontext(Name name, Attributes attributes) throws javax.naming.NamingException {
        name = this.transformName(name);
        this.verifyName(name);
        try {
            short operationType = this.checkOperation(name);
            try {
                Name newFullName = ((Name)(this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace).clone()).addAll(name);
                ClientContext cl = new ClientContext(this.localEnvironment, this.remoteContext.createSubcontext(name, attributes, operationType), newFullName, this.runOnServer, this.referenceFactory, this.loginContext);
                if (JNDIFrame.log.toLogPathInLocation()) {
                    JNDIFrame.log.logPath(JNDILogConstants.SUCCESSFUL_OPERATION, new Object[]{"Create subcontext", newFullName});
                }
                return cl;
            }
            catch (javax.naming.InvalidNameException ex) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.INVALID_NAME_PARAMETER, new Object[]{name});
                    JNDIFrame.log.logCatching(ex);
                }
                throw new InvalidNameException(InvalidNameException.INVALID_NAME_PARAMETER, new Object[]{name}, ex);
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"createSubcontext", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"createSubcontext", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"createSubcontext", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_CREATE_SUBCONTEXT, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_CREATE_SUBCONTEXT, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_CREATE_SUBCONTEXT, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public DirContext createSubcontext(String name, Attributes attributes) throws javax.naming.NamingException {
        return this.createSubcontext(ClientContext.parse(name), attributes);
    }

    public Context createSubcontext(Name name) throws javax.naming.NamingException {
        return this.createSubcontext(name, null);
    }

    public Context createSubcontext(String name) throws javax.naming.NamingException {
        return this.createSubcontext(ClientContext.parse(name), null);
    }

    public Object lookupLink(String name) throws javax.naming.NamingException {
        return this.lookup(ClientContext.parse(name));
    }

    public Object lookupLink(Name name) throws javax.naming.NamingException {
        return this.lookup(name);
    }

    public Attributes getAttributes(Name name) throws javax.naming.NamingException {
        name = this.transformName(name);
        this.verifyName(name);
        short operationType = this.checkOperation(name);
        try {
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            obj = (DirObject)RemoteSerializator.LROTable.get(fullPath);
            if (obj != null) {
                Attributes attrToReturn = obj.getAttributes();
                if (attrToReturn == null) {
                    attrToReturn = new BasicAttributes();
                }
                return attrToReturn;
            }
            return this.remoteContext.getAttributes(name, operationType);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"getAttributes", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"getAttributes", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"getAttributes", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_GET_ATTRIBUTES, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public Attributes getAttributes(Name name, String[] attrIDs) throws javax.naming.NamingException {
        name = this.transformName(name);
        this.verifyName(name);
        short operationType = this.checkOperation(name);
        try {
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            obj = (DirObject)RemoteSerializator.LROTable.get(fullPath);
            if (obj != null) {
                Attributes attrsToReturn = new BasicAttributes();
                Attributes attrs = obj.getAttributes();
                if (attrIDs == null) {
                    attrsToReturn = attrs;
                } else if (attrIDs.length != 0) {
                    int i = 0;
                    while (i < attrIDs.length) {
                        String tempID = attrIDs[i];
                        Attribute attribute = attrs.get(tempID);
                        if (attribute != null) {
                            attrsToReturn.put(attribute);
                        }
                        ++i;
                    }
                }
                return attrsToReturn;
            }
            return this.remoteContext.getAttributes(name, attrIDs, operationType);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"getAttributes", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"getAttributes", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"getAttributes", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_GET_ATTRIBUTES, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_GET_ATTRIBUTES, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public Attributes getAttributes(String name) throws javax.naming.NamingException {
        return this.getAttributes(ClientContext.parse(name));
    }

    public Attributes getAttributes(String name, String[] attributeIDs) throws javax.naming.NamingException {
        if (attributeIDs == null) {
            return this.getAttributes(ClientContext.parse(name));
        }
        return this.getAttributes(ClientContext.parse(name), attributeIDs);
    }

    public void modifyAttributes(Name name, int modificationOption, Attributes attributes) throws javax.naming.NamingException {
        name = this.transformName(name);
        this.verifyName(name);
        short operationType = this.checkOperation(name);
        try {
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            obj = (DirObject)RemoteSerializator.LROTable.remove(fullPath);
            if (obj != null) {
                Attributes attrToModify = obj.getAttributes();
                if (attrToModify == null) {
                    attrToModify = new BasicAttributes();
                }
                ModifyAttributes.modAttr(attrToModify, modificationOption, attributes);
                obj.setAttributes(attrToModify);
                RemoteSerializator.LROTable.put(fullPath, obj);
                return;
            }
            this.remoteContext.modifyAttributes(name, modificationOption, attributes, operationType);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"modifyAttributes", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"modifyAttributes", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"modifyAttributes", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_MODIFY_ATTRIBUTES, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItems) throws javax.naming.NamingException {
        name = this.transformName(name);
        this.verifyName(name);
        short operationType = this.checkOperation(name);
        try {
            DirObject obj = null;
            String fullPath = this.getNameInNamespace().equals("") ? name.toString() : this.getNameInNamespace() + "/" + name;
            obj = (DirObject)RemoteSerializator.LROTable.remove(fullPath);
            if (obj != null) {
                Attributes attrToModify = obj.getAttributes();
                if (attrToModify == null) {
                    attrToModify = new BasicAttributes();
                }
                ModifyAttributes.modAttr(attrToModify, modificationItems);
                obj.setAttributes(attrToModify);
                RemoteSerializator.LROTable.put(fullPath, obj);
                return;
            }
            this.remoteContext.modifyAttributes(name, modificationItems, operationType);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"modifyAttributes", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"modifyAttributes", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"modifyAttributes", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_MODIFY_ATTRIBUTES, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name});
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_MODIFY_ATTRIBUTES, new Object[]{name}, ex);
            ne.log();
            throw ne;
        }
    }

    public void modifyAttributes(String name, int modificationOption, Attributes attrs) throws javax.naming.NamingException {
        this.modifyAttributes(ClientContext.parse(name), modificationOption, attrs);
    }

    public void modifyAttributes(String name, ModificationItem[] modificationItems) throws javax.naming.NamingException {
        this.modifyAttributes(ClientContext.parse(name), modificationItems);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws javax.naming.NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), matchingAttributes, null);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws javax.naming.NamingException {
        try {
            short operationType = this.checkOperation(name);
            return new ClientNamingEnum(this, new FullClientNamingEnum(this.remoteContext.search(name, matchingAttributes, attributesToReturn, operationType), this.searchLROTable(name, matchingAttributes, attributesToReturn)), this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace, this.localEnvironment, this.runOnServer, this.loginContext);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"search", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"search", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"search", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_SEARCH, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_SEARCH);
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_SEARCH, ex);
            ne.log();
            throw ne;
        }
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), matchingAttributes, attributesToReturn);
    }

    public NamingEnumeration search(Name name, String filterExpression, Object[] filterArguments, SearchControls searchControls) throws javax.naming.NamingException {
        try {
            short operationType = this.checkOperation(name);
            ServerNamingEnum sne = null;
            try {
                sne = this.remoteContext.search(name, filterExpression, filterArguments, searchControls, operationType);
            }
            catch (NameNotFoundException ex) {
                JNDIFrame.log.logCatching(ex);
                sne = null;
            }
            return new ClientNamingEnum(this, new FullClientNamingEnum(sne, this.searchLROTable(name, filterExpression, filterArguments, searchControls)), this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace, this.localEnvironment, this.runOnServer, this.loginContext);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"search", name});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"search", name});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.NO_PERMISSION, new Object[]{"search", name});
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_SEARCH, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_SEARCH);
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_SEARCH, ex);
            ne.log();
            throw ne;
        }
    }

    public NamingEnumeration search(String name, String filterExpression, Object[] filterArguments, SearchControls searchControls) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), filterExpression, filterArguments, searchControls);
    }

    public NamingEnumeration search(Name name, String filterExpression, SearchControls searchControls) throws javax.naming.NamingException {
        return this.search(name, filterExpression, null, searchControls);
    }

    public NamingEnumeration search(String name, String filterExpression, SearchControls searchControls) throws javax.naming.NamingException {
        return this.search(ClientContext.parse(name), filterExpression, null, searchControls);
    }

    public DirContext getSchemaClassDefinition(Name name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchemaClassDefinition(String name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchema(Name name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public DirContext getSchema(String name) throws javax.naming.NamingException {
        throw new OperationNotSupportedException(OperationNotSupportedException.NOT_SUPPORT_SCHEMAS);
    }

    public NameParser getNameParser(String name) throws javax.naming.NamingException {
        return new ClientNameParser();
    }

    public NameParser getNameParser(Name name) throws javax.naming.NamingException {
        return new ClientNameParser();
    }

    public String composeName(String name, String prefix) throws javax.naming.NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    public Name composeName(Name name, Name prefix) throws javax.naming.NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public Object addToEnvironment(String propertyName, Object propertyVal) throws javax.naming.NamingException {
        try {
            if (this.remoteContext == null) {
                throw new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            }
            if (propertyName.equals("jndi.syntax.direction") | propertyName.equals("jndi.syntax.separator") | propertyName.equals("jndi.syntax.ignorecase") | propertyName.equals("jndi.syntax.escape") | propertyName.equals("jndi.syntax.beginquote") | propertyName.equals("jndi.syntax.endquote") | propertyName.equals("jndi.syntax.beginquote2") | propertyName.equals("jndi.syntax.endquote2") | propertyName.equals("jndi.syntax.trimblanks") | propertyName.equals("jndi.syntax.ava") | propertyName.equals("jndi.syntax.typeval")) {
                this.remoteContext.addToEnvironment(propertyName, (String)propertyVal, (short)0);
            }
            if (this.localEnvironment != null) {
                return this.localEnvironment.put(propertyName, propertyVal);
            }
            this.localEnvironment = new Hashtable();
            return this.localEnvironment.put(propertyName, propertyVal);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"addToEnvironment", propertyName});
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(JNDILogConstants.CONNECTION_LOST, new Object[]{"addToEnvironment", propertyName});
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ADD_TO_ENVIROMENT);
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ADD_TO_ENVIROMENT, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_ADD_TO_ENVIROMENT);
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_ADD_TO_ENVIROMENT, ex);
            ne.log();
            throw ne;
        }
    }

    public Object removeFromEnvironment(String propertyName) throws javax.naming.NamingException {
        if (this.localEnvironment != null) {
            return this.localEnvironment.remove(propertyName);
        }
        return null;
    }

    public Hashtable getEnvironment() throws javax.naming.NamingException {
        if (this.localEnvironment == null) {
            this.localEnvironment = new Hashtable();
        }
        return this.localEnvironment;
    }

    public boolean targetMustExist() throws javax.naming.NamingException {
        return true;
    }

    public void close() throws javax.naming.NamingException {
        try {
            this.remoteContext.close();
            this.remoteContext = null;
            if (this.loginContext != null) {
                this.loginContext.logout();
            }
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_CLOSE);
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_CLOSE, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_CLOSE);
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_CLOSE, ex);
            ne.setRootCause(ex);
            ne.log();
            throw ne;
        }
    }

    public void print(PrintStream outStrm) throws javax.naming.NamingException {
        try {
            this.remoteContext.print(outStrm);
        }
        catch (P4ConnectionException pce) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                JNDIFrame.log.logCatching(pce);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(pce);
            throw ne;
        }
        catch (ServerException nsoe) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.NO_CONNECTION_WITH_SERVER);
                JNDIFrame.log.logCatching(nsoe);
            }
            NamingException ne = new NamingException(NamingException.NO_CONNECTION_WITH_SERVER);
            ne.setRootCause(nsoe);
            throw ne;
        }
        catch (Exception ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_PRINT);
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_PRINT, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(NamingException.CANNOT_PRINT);
                JNDIFrame.log.logCatching(ex);
            }
            NamingException ne = new NamingException(NamingException.CANNOT_PRINT, ex);
            ne.log();
            throw ne;
        }
    }

    private void dumpbind(String s) {
    }

    private void dumprebind(String s) {
    }

    private void dumpunbind(String s) {
    }

    private void dumprename(String s) {
    }

    public String getNameInNamespace() throws javax.naming.NamingException {
        return (this.fullNameInSpace == null ? (this.fullNameInSpace = new CompositeName("")) : this.fullNameInSpace).toString();
    }

    public void lsn(PrintStream outS) throws javax.naming.NamingException {
        outS.println("");
        outS.println("Naming Tree: ");
        outS.println("************ ");
        this.prntTree(2, (Context)this.lookup(""), outS);
        outS.println("");
    }

    public void lsn(PrintStream outS, boolean classes) throws javax.naming.NamingException {
        outS.println("");
        outS.println("Naming Tree: ");
        outS.println("************ ");
        if (classes) {
            this.prntTree2(2, (Context)this.lookup(""), outS);
        } else {
            this.prntTree(2, (Context)this.lookup(""), outS);
        }
        outS.println("");
    }

    public void prntTree(int offset, Context where, PrintStream outStrm) throws javax.naming.NamingException {
        NamingEnumeration<NameClassPair> je = where.list("");
        while (je.hasMoreElements()) {
            int j;
            NameClassPair nameClassPair = (NameClassPair)je.nextElement();
            String name = nameClassPair.getName();
            String className = nameClassPair.getClassName();
            if (className != null & className.equals("javax.naming.Context")) {
                j = 0;
                while (j < offset) {
                    outStrm.print(" ");
                    ++j;
                }
                outStrm.println("* " + name + " [Context]");
                this.prntTree(offset + 2, (Context)where.lookup(name), outStrm);
                continue;
            }
            j = 0;
            while (j < offset) {
                outStrm.print(" ");
                ++j;
            }
            outStrm.println(name);
        }
    }

    public void prntTree2(int offset, Context where, PrintStream outStrm) throws javax.naming.NamingException {
        NamingEnumeration<Binding> je = where.listBindings("");
        while (je.hasMoreElements()) {
            int j;
            Binding binding = (Binding)je.nextElement();
            String name = binding.getName();
            String className = binding.getClassName();
            if (className != null && binding.getObject() instanceof Context) {
                j = 0;
                while (j < offset) {
                    outStrm.print(" ");
                    ++j;
                }
                outStrm.println("* " + name + " [Context]");
                this.prntTree2(offset + 2, (Context)where.lookup(name), outStrm);
                continue;
            }
            j = 0;
            while (j < offset) {
                outStrm.print(" ");
                ++j;
            }
            outStrm.println("+ " + name);
            int j2 = 0;
            while (j2 < offset + 2) {
                outStrm.print(" ");
                ++j2;
            }
            outStrm.println("[Class Name]   " + className);
            int j3 = 0;
            while (j3 < offset + 2) {
                outStrm.print(" ");
                ++j3;
            }
            outStrm.println("[Object Value] " + binding.getObject());
        }
    }

    public void allowOperation(String userName, String permissionName, boolean isGroup) throws NoPermissionException {
        try {
            this.remoteContext.allowOperation(userName, permissionName, isGroup);
        }
        catch (javax.naming.NamingException ex) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION);
                JNDIFrame.log.logCatching(ex);
            }
            com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION, new Object[]{userName}, ex);
            npe.log();
            throw npe;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION);
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION, new Object[]{userName}, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION);
                JNDIFrame.log.logCatching(ex);
            }
            com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION, new Object[]{userName}, ex);
            npe.log();
            throw npe;
        }
    }

    public void denyOperation(String userName, String permissionName, boolean isGroup) throws NoPermissionException {
        try {
            this.remoteContext.denyOperation(userName, permissionName, isGroup);
        }
        catch (javax.naming.NamingException ex) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION);
                JNDIFrame.log.logCatching(ex);
            }
            com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_DENY_OPERATION, new Object[]{userName}, ex);
            npe.log();
            throw npe;
        }
        catch (RemoteException ex) {
            String m = ex.getMessage();
            if (m != null && m.indexOf("SecurityException") != -1) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION);
                    JNDIFrame.log.logCatching(ex);
                }
                com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_DENY_OPERATION, new Object[]{userName}, ex);
                npe.log();
                throw npe;
            }
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_ALLOW_OPERATION);
                JNDIFrame.log.logCatching(ex);
            }
            com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException npe = new com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException(com.sap.engine.services.jndi.persistent.exceptions.NoPermissionException.NO_PERMISSION_TO_DENY_OPERATION, new Object[]{userName}, ex);
            npe.log();
            throw npe;
        }
    }

    protected void dump(String s) {
        System.out.println(s);
    }

    protected byte[] serializeDirObject(DirObject dirObject) throws Exception {
        Attributes attributes = dirObject.getAttributes();
        String classname = dirObject.getClassName();
        Object obj = dirObject.getObject();
        byte[] result = null;
        byte[] tempAttr = null;
        byte[] tempClassName = null;
        byte[] tempObject = null;
        int offs = 0;
        int resOffs = 0;
        try {
            if (attributes == null) {
                attributes = new BasicAttributes();
            }
            tempAttr = Serializator.toByteArray(attributes);
            tempClassName = classname.getBytes();
            try {
                tempObject = this.serializeObject(obj);
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
                return null;
            }
            result = new byte[4 + tempAttr.length + 4 + tempClassName.length + 4 + tempObject.length];
            offs = tempAttr.length;
            result[0] = (byte)(0xFF & offs);
            result[1] = (byte)(0xFF & offs >> 8);
            result[2] = (byte)(0xFF & offs >> 16);
            result[3] = (byte)(0xFF & offs >> 24);
            System.arraycopy(tempAttr, 0, result, 4, offs);
            resOffs = offs + 4;
            offs = tempClassName.length;
            result[resOffs] = (byte)(0xFF & offs);
            result[resOffs + 1] = (byte)(0xFF & offs >> 8);
            result[resOffs + 2] = (byte)(0xFF & offs >> 16);
            result[resOffs + 3] = (byte)(0xFF & offs >> 24);
            System.arraycopy(tempClassName, 0, result, resOffs += 4, offs);
            resOffs += offs;
            offs = tempObject.length;
            result[resOffs] = (byte)(0xFF & offs);
            result[resOffs + 1] = (byte)(0xFF & offs >> 8);
            result[resOffs + 2] = (byte)(0xFF & offs >> 16);
            result[resOffs + 3] = (byte)(0xFF & offs >> 24);
            System.arraycopy(tempObject, 0, result, resOffs += 4, offs);
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_SERIALIZE_OBJECT, e);
        }
        return result;
    }

    protected DirObject deserializeDirObject(byte[] arr) throws Exception {
        DirObject result = new DirObject();
        byte[] temp = null;
        int resOffs = 0;
        int lngth = 0;
        try {
            lngth = arr[3] << 24 & 0xFF000000 | arr[2] << 16 & 0xFF0000 | arr[1] << 8 & 0xFF00 | arr[0] & 0xFF;
            temp = new byte[lngth];
            System.arraycopy(arr, 4, temp, 0, lngth);
            resOffs = lngth + 4;
            Attributes attributes = (Attributes)Serializator.toObject(temp);
            result.setAttributes(attributes);
            lngth = arr[resOffs + 3] << 24 & 0xFF000000 | arr[resOffs + 2] << 16 & 0xFF0000 | arr[resOffs + 1] << 8 & 0xFF00 | arr[resOffs] & 0xFF;
            temp = new byte[lngth];
            System.arraycopy(arr, resOffs += 4, temp, 0, lngth);
            resOffs += lngth;
            result.setClassName(new String(temp));
            lngth = arr[resOffs + 3] << 24 & 0xFF000000 | arr[resOffs + 2] << 16 & 0xFF0000 | arr[resOffs + 1] << 8 & 0xFF00 | arr[resOffs] & 0xFF;
            temp = new byte[lngth];
            System.arraycopy(arr, resOffs + 4, temp, 0, lngth);
            result.setObject(this.deserializeObject(temp));
            if (this.lastobj) {
                try {
                    result.setClassName(result.getObject().getClass().getName());
                }
                catch (Exception e) {
                    JNDIFrame.log.logCatching(e);
                    result.setClassName("null");
                }
            }
            return result;
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_DESERIALIZE_OBJECT, e);
        }
    }

    public byte[] serializeObject(Object object) throws Exception {
        try {
            this.lastobj = false;
            byte[] bytearr = RemoteSerializator.toByteArray(object, this);
            return bytearr;
        }
        catch (Exception e) {
            throw new JNDIException(JNDIException.CAN_NOT_SERIALIZE_OBJECT, e);
        }
    }

    public Object deserializeObject(byte[] data) throws Exception {
        try {
            this.lastobj = false;
            Object obj = RemoteSerializator.toObject(data, this);
            this.commonLoader = null;
            return obj;
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            throw new JNDIException(JNDIException.CAN_NOT_DESERIALIZE_OBJECT, e);
        }
    }

    public void setLastObj(boolean lo) {
        this.lastobj = lo;
    }

    private Object removeReference(Name name) {
        try {
            if (this.fullNameInSpace == null) {
                this.fullNameInSpace = new CompositeName();
            }
            Name full = ((Name)this.fullNameInSpace.clone()).addAll(name);
            return referenceHash.remove(full);
        }
        catch (javax.naming.InvalidNameException e) {
            JNDIFrame.log.logCatching(e);
            return null;
        }
    }

    private void addReference(Name name, Object value) {
        try {
            if (this.fullNameInSpace == null) {
                this.fullNameInSpace = new CompositeName();
            }
            Name full = ((Name)this.fullNameInSpace.clone()).addAll(name);
            referenceHash.put(full, value);
            this.remoteReferenceHash = null;
        }
        catch (javax.naming.InvalidNameException e) {
            JNDIFrame.log.logCatching(e);
            return;
        }
    }

    protected Object prepareStateToBind(Name name, Object obj, Attributes attr) {
        Object result = null;
        try {
            result = attr != null ? DirectoryManager.getStateToBind(obj, name, this, this.localEnvironment, attr) : NamingManager.getStateToBind(obj, name, this, this.localEnvironment);
        }
        catch (javax.naming.NamingException ne) {
            JNDIFrame.log.logCatching(ne);
        }
        return result != null ? result : obj;
    }

    public ServerContextInface getRemoteContext() {
        return this.remoteContext;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        syntax = new ConcurrentHashMapObjectObject();
        syntax.put("jndi.syntax.direction", "left_to_right");
        syntax.put("jndi.syntax.ignorecase", "false");
        syntax.put("jndi.syntax.separator", "/");
        if (referenceHash == null) {
            referenceHash = new ConcurrentHashMapObjectObject();
        }
    }
}

