/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.gui;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.gui.JNDITreeGrabberContext;
import com.sap.engine.services.jndi.gui.JNDITreeGrabberRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JNDITreeGrabberPanel
extends JPanel {
    private JScrollPane scrollPane = new JScrollPane();
    private JTree tree = null;
    private BorderLayout borderLayout = new BorderLayout();
    private JNDITreeGrabberContext grabberContext = null;
    private JFileChooser fc = new JFileChooser();
    private boolean isAccessible = true;
    static final long serialVersionUID = 3774618817318753771L;

    public JNDITreeGrabberPanel(JNDITreeGrabberContext grabberContext) {
        this.grabberContext = grabberContext;
    }

    public void refreshAction() {
        this.initTree();
        this.scrollPane.getViewport().add((Component)this.tree, null);
        this.repaint();
    }

    public void exportAction() {
        int returnVal = this.fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            try {
                this.grabberContext.exportToFile(file);
            }
            catch (IOException e) {
                JNDIFrame.log.logCatching(e);
                JOptionPane.showMessageDialog(this, e.getMessage(), "Exception occured", 0);
            }
        }
    }

    public void expandAction() {
        this.expandNode(new TreePath(this.tree.getModel().getRoot()));
    }

    public void collapseAction() {
        this.collapseTree();
        this.tree.expandRow(0);
    }

    public boolean isAccessible() {
        return this.isAccessible;
    }

    public void initPanel() {
        if (this.initTree()) {
            this.scrollPane.setAutoscrolls(true);
            this.scrollPane.getViewport().add((Component)this.tree, null);
            this.setLayout(this.borderLayout);
            this.add((Component)this.scrollPane, "Center");
        } else {
            JLabel errorLabel = new JLabel("You do not have permission to view the naming tree!", 0);
            this.setLayout(this.borderLayout);
            this.add(errorLabel);
            this.isAccessible = false;
        }
    }

    private boolean initTree() {
        DefaultMutableTreeNode treeInfo = null;
        try {
            treeInfo = this.grabberContext.getDefaultMutableTreeNode();
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
            treeInfo = null;
        }
        if (treeInfo != null) {
            this.tree = new JTree(treeInfo);
            this.tree.setCellRenderer(new JNDITreeGrabberRenderer());
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.setAutoscrolls(true);
            this.tree.setActionMap(null);
            this.tree.setExpandsSelectedPaths(true);
            this.tree.setShowsRootHandles(false);
            this.tree.setToggleClickCount(2);
            this.tree.setRootVisible(true);
            this.tree.setScrollsOnExpand(true);
            this.tree.setEditable(false);
            return true;
        }
        return false;
    }

    private void collapseTree() {
        int maxCount;
        this.tree.setSelectionRow(0);
        int currentRowCount = maxCount = this.tree.getRowCount() - 2;
        while (currentRowCount > 0) {
            maxCount = this.tree.getRowCount() - 2;
            if (maxCount < currentRowCount) {
                currentRowCount = maxCount;
            }
            this.tree.collapseRow(currentRowCount);
            --currentRowCount;
        }
    }

    private void expandNode(TreePath path) {
        this.tree.expandPath(path);
        TreeNode node = (TreeNode)path.getLastPathComponent();
        if (node != null && !node.isLeaf()) {
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                TreeNode next = enumeration.nextElement();
                TreePath newTreePath = new TreePath(this.getNewPath(path, next));
                this.expandNode(newTreePath);
            }
        }
    }

    private Object[] getNewPath(TreePath path, Object child) {
        Object[] oldPath = path.getPath();
        Object[] newPath = new Object[oldPath.length + 1];
        int i = 0;
        while (i < oldPath.length) {
            newPath[i] = oldPath[i];
            ++i;
        }
        newPath[i] = child;
        return newPath;
    }
}

