/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.gui;

import com.sap.engine.services.jndi.gui.JNDIRuntimeLogical;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.naming.NamingException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class JNDITreeGrabberContext {
    private DefaultMutableTreeNode treeNode = null;

    public DefaultMutableTreeNode getDefaultMutableTreeNode() throws RemoteException {
        this.initTreeNode();
        return this.treeNode;
    }

    public void exportToFile(File file) throws IOException {
        if (this.treeNode != null) {
            String listing = this.getListing(this.treeNode, "");
            FileWriter outFile = new FileWriter(file);
            outFile.write(listing);
            outFile.close();
        }
    }

    private void initTreeNode() throws RemoteException {
        this.treeNode = (DefaultMutableTreeNode)JNDIRuntimeLogical.jndiRuntimeInterface.listAllBindings();
    }

    private String getListing(DefaultMutableTreeNode root, String indent) {
        StringBuffer buffer = new StringBuffer();
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            String line = node.getUserObject().toString();
            String type = " * ";
            if (line.indexOf("[Context]") == -1) {
                type = " + ";
            }
            buffer.append(indent + type + line + "\r\n");
            if (!node.getAllowsChildren()) continue;
            buffer.append(this.getListing(node, indent + "      "));
        }
        return buffer.toString();
    }
}

