/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cosnaming;

import com.sap.engine.interfaces.cross.UnsatisfiedReference;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.NamingManager;
import com.sap.engine.services.jndi.cosnaming.BindingIteratorImpl;
import com.sap.engine.services.jndi.cosnaming.CosNamingContext;
import com.sap.engine.services.jndi.cosnaming.NamingContextExtBaseImpl;
import com.sap.engine.services.jndi.cosnaming.NamingContextExtImpl;
import com.sap.engine.services.jndi.implclient.ClientContext;
import com.sap.engine.services.jndi.implclient.IIOPReferenceFactory;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InvalidAttributesException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public class NamingContextImpl
extends NamingContextExtBaseImpl {
    private static final AlreadyBound ALREADY_BOUND = new AlreadyBound();
    static final InvalidName INVALID_NAME = new InvalidName();
    private static final NotEmpty NOT_EMPTY = new NotEmpty();
    private static final NotFound NOT_FOUND = new NotFound(NotFoundReason.missing_node, new NameComponent[0]);
    private static final CannotProceed CANNOT_PROCEED = new CannotProceed(null, new NameComponent[0]);
    private static Context jndiContext = null;
    private static Properties connectProperties = null;
    private static ORB orb = ORB.init();
    private String root;
    static final long serialVersionUID = 4494267120473619684L;
    private static final char[] escapeExceptions = new char[]{';', '/', ':', '?', '@', '&', '=', '+', '$', ',', '-', '_', '.', '!', '~', '*', '\u0092', '(', ')'};
    String[] ids = new String[]{"IDL:omg.org/CosNaming/NamingContextExt:1.0", "IDL:omg.org/CosNaming/NamingContext:1.0"};

    public NamingContextImpl() {
        this("");
    }

    public NamingContextImpl(String root) {
        this.setRoot(root);
        if (connectProperties == null) {
            connectProperties = new Properties();
            ((Hashtable)connectProperties).put("server", "true");
            ((Hashtable)connectProperties).put("java.naming.factory.initial", "com.sap.engine.services.jndi.InitialContextFactoryImpl");
        }
        if (jndiContext == null) {
            try {
                jndiContext = new ClientContext(connectProperties, NamingManager.getNamingManager().getProxy().getNewServerContext(false, false), false, new IIOPReferenceFactory(), null);
            }
            catch (Exception e) {
                JNDIFrame.log.logError(JNDILogConstants.NAMING_CONTEXT_IMPL_CANNOT_GET_INITIAL_CONTEXT);
                JNDIFrame.log.logThrowable(e);
            }
        }
    }

    public void bind(NameComponent[] nameComponent, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            String name = this.createName(nameComponent);
            NamingContextExt objContext = null;
            try {
                objContext = NamingContextExtHelper.narrow((Object)obj);
            }
            catch (Exception e) {
                objContext = null;
            }
            if (objContext == null) {
                jndiContext.bind(name, (java.lang.Object)orb.object_to_string(obj));
            } else {
                this.bind_context(nameComponent, (NamingContext)objContext);
            }
        }
        catch (Exception ne) {
            if (ne instanceof NameAlreadyBoundException) {
                throw ALREADY_BOUND;
            }
            if (ne instanceof InvalidNameException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
    }

    private static void copyContext(NamingContext source, NamingContext destination) {
        boolean bool;
        BindingIteratorHolder bih = new BindingIteratorHolder();
        source.list(0, new BindingListHolder(), bih);
        BindingIterator bi = bih.value;
        if (bi == null) {
            return;
        }
        BindingHolder bh = new BindingHolder();
        do {
            bool = bi.next_one(bh);
            Binding bind = bh.value;
            try {
                Object obj = source.resolve(bind.binding_name);
                if (bind.binding_type.value() == 0) {
                    destination.bind(bind.binding_name, obj);
                    continue;
                }
                destination.bind_context(bind.binding_name, (NamingContext)NamingContextExtHelper.narrow((Object)obj));
            }
            catch (Exception e) {
                JNDIFrame.log.logThrowable(e);
            }
        } while (bool);
    }

    public void bind_context(NameComponent[] nameComponent, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        try {
            NamingContext newContext = this.bind_new_context(nameComponent);
            NamingContextImpl.copyContext(namingContext, newContext);
        }
        catch (Exception ne) {
            if (ne instanceof NameAlreadyBoundException) {
                throw ALREADY_BOUND;
            }
            if (ne instanceof InvalidAttributesException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
    }

    public void rebind(NameComponent[] nameComponent, Object obj) throws NotFound, CannotProceed, InvalidName {
        try {
            String name = this.createName(nameComponent);
            NamingContextExt objContext = null;
            try {
                objContext = NamingContextExtHelper.narrow((Object)obj);
            }
            catch (Exception e) {
                objContext = null;
            }
            if (objContext == null) {
                jndiContext.rebind(name, (java.lang.Object)orb.object_to_string(obj));
            } else {
                this.rebind_context(nameComponent, (NamingContext)objContext);
            }
        }
        catch (Exception ne) {
            if (ne instanceof NameAlreadyBoundException) {
                return;
            }
            if (ne instanceof InvalidNameException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
    }

    public void rebind_context(NameComponent[] nameComponent, NamingContext namingContext) throws NotFound, CannotProceed, InvalidName {
        try {
            this.unbind(this.createName(nameComponent));
            NamingContext newContext = this.bind_new_context(nameComponent);
            NamingContextImpl.copyContext(namingContext, newContext);
        }
        catch (Exception ne) {
            if (ne instanceof NameAlreadyBoundException) {
                return;
            }
            if (ne instanceof InvalidAttributesException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
    }

    public Object resolve(NameComponent[] nameComponent) throws NotFound, CannotProceed, InvalidName {
        try {
            String name = this.createName(nameComponent);
            java.lang.Object result = jndiContext.lookup(name);
            if (result instanceof UnsatisfiedReference) {
                result = jndiContext.lookup("ejbCosNaming/" + name);
            }
            if (result instanceof Object) {
                return (Object)result;
            }
            if (result instanceof String) {
                return orb.string_to_object((String)result);
            }
            if (result instanceof Context) {
                return this instanceof NamingContextExt ? new NamingContextExtImpl(name) : new NamingContextImpl(name);
            }
        }
        catch (Exception e) {
            if (e instanceof NameNotFoundException) {
                throw NOT_FOUND;
            }
            if (e instanceof InvalidNameException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
        throw CANNOT_PROCEED;
    }

    private void unbind(String contextName) throws Exception {
        NamingEnumeration<NameClassPair> ne = jndiContext.list(contextName);
        String temp = contextName + "/";
        while (ne.hasMore()) {
            NameClassPair ncp = ne.next();
            String jndiNameStr = temp + ncp.getName();
            String className = ncp.getClassName();
            if ("javax.naming.Context".equals(className)) {
                this.unbind(jndiNameStr);
                continue;
            }
            jndiContext.unbind(jndiNameStr);
        }
        jndiContext.destroySubcontext(contextName);
    }

    public void unbind(NameComponent[] nameComponent) throws NotFound, CannotProceed, InvalidName {
        try {
            String name = this.createName(nameComponent);
            java.lang.Object result = jndiContext.lookup(name);
            if (result instanceof Context) {
                this.unbind(name);
            } else {
                jndiContext.unbind(name);
            }
        }
        catch (Exception ne) {
            if (ne instanceof NameNotFoundException) {
                throw NOT_FOUND;
            }
            if (ne instanceof InvalidNameException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
    }

    public void list(int how_many, BindingListHolder bindingListHolder, BindingIteratorHolder bindingIteratorHolder) {
        if (how_many < 0) {
            how_many = 0;
        }
        try {
            NamingEnumeration<NameClassPair> ne = jndiContext.list(this.getRoot());
            ArrayList<Binding> bindingList = new ArrayList<Binding>();
            while (ne.hasMore()) {
                NameClassPair ncp = ne.next();
                String jndiNameStr = ncp.getName();
                String className = ncp.getClassName();
                Name jndiName = null;
                try {
                    jndiName = CosNamingContext.nameParser.parse(jndiNameStr);
                }
                catch (Exception e) {
                    JNDIFrame.log.logCatching(e);
                    jndiName = null;
                }
                if (jndiName == null) continue;
                NameComponent[] cosName = CosNamingContext.toCosName(jndiName);
                BindingType type = "javax.naming.Context".equals(className) ? BindingType.ncontext : BindingType.nobject;
                bindingList.add(new Binding(cosName, type));
            }
            int fullSize = bindingList.size();
            int size = how_many < fullSize ? (how_many < 0 ? 0 : how_many) : fullSize;
            bindingListHolder.value = bindingList.subList(0, size).toArray(new Binding[size]);
            bindingIteratorHolder.value = size < fullSize ? new BindingIteratorImpl(bindingList.subList(size, fullSize)) : null;
        }
        catch (Exception ne) {
            JNDIFrame.log.logThrowable(ne);
        }
    }

    public NamingContext new_context() {
        return null;
    }

    public NamingContext bind_new_context(NameComponent[] nameComponent) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        try {
            String name = this.createName(nameComponent);
            jndiContext.createSubcontext(name);
            return this instanceof NamingContextExt ? new NamingContextExtImpl(name) : new NamingContextImpl(name);
        }
        catch (Exception ne) {
            if (ne instanceof NameAlreadyBoundException) {
                throw ALREADY_BOUND;
            }
            if (ne instanceof InvalidAttributesException) {
                throw INVALID_NAME;
            }
            throw CANNOT_PROCEED;
        }
    }

    public void destroy() throws NotEmpty {
        try {
            jndiContext.destroySubcontext(this.getRoot());
        }
        catch (Exception ne) {
            throw NOT_EMPTY;
        }
    }

    private static Name toJNDIName(NameComponent[] nameComponent) throws NamingException {
        try {
            return new CompositeName(NamingContextImpl.toString(nameComponent));
        }
        catch (InvalidName in) {
            InvalidNameException ine = new InvalidNameException();
            ine.setRootCause(in);
            throw ine;
        }
    }

    void setRoot(String newRoot) {
        this.root = newRoot == null ? "" : newRoot;
    }

    public String getRoot() {
        return this.root;
    }

    public static void setContext(Context newContext) {
        jndiContext = newContext;
    }

    String createName(NameComponent[] nameComponent) throws NamingException {
        String result = this.getRoot();
        String name = null;
        try {
            name = NamingContextImpl.toString(nameComponent);
        }
        catch (InvalidName in) {
            InvalidNameException ine = new InvalidNameException();
            ine.setRootCause(in);
            throw ine;
        }
        if (result.length() != 0 && !result.endsWith("/") && !name.startsWith("/")) {
            result = result + "/";
        }
        return result + name;
    }

    static String toString(NameComponent[] name) throws InvalidName {
        StringBuffer sb = new StringBuffer();
        int c = 0;
        while (c < name.length) {
            sb.append(NamingContextImpl.toString(name[c]) + "/");
            ++c;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - "/".length());
        }
        return sb.toString();
    }

    static String toString(NameComponent name) {
        String id = NamingContextImpl.escapeName(name.id);
        String kind = NamingContextImpl.escapeName(name.kind);
        return id.length() > 0 && kind.length() == 0 ? id : id + "." + kind;
    }

    private static String escapeName(String s) {
        if (s == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(s, "./\\", true);
        StringBuffer sb = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals(".") || token.equals("/") || token.equals("\\")) {
                token = "\\" + token;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    static NameComponent[] toNameComponent(String sn) throws InvalidName {
        ArrayList<NameComponent> tempList = new ArrayList<NameComponent>();
        while (sn != null) {
            NameComponent name = new NameComponent(null, null);
            sn = NamingContextImpl.nameParse(sn, name);
            if (name.id == null) break;
            tempList.add(name);
        }
        NameComponent[] result = new NameComponent[tempList.size()];
        int c = 0;
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            result[c] = (NameComponent)i.next();
            ++c;
        }
        return result;
    }

    private static String nameParse(String sn, NameComponent name) throws InvalidName {
        int size = sn.length();
        if (size == 0) {
            throw INVALID_NAME;
        }
        int id = NamingContextImpl.idParse(sn);
        int kind = NamingContextImpl.kindParse(sn, id);
        name.id = sn.substring(0, id);
        String string = name.kind = id >= kind ? "" : sn.substring(id + 1, kind);
        if (kind >= size) {
            return null;
        }
        return sn.substring(kind + 1);
    }

    private static int idParse(String sn) throws InvalidName {
        if (sn.startsWith("/")) {
            throw INVALID_NAME;
        }
        int size = sn.length();
        int c = 0;
        while (c < size) {
            char ch = sn.charAt(c);
            if (ch == '\\') {
                char nextChar;
                if (c == size) {
                    throw INVALID_NAME;
                }
                if ((nextChar = sn.charAt(++c)) != '.' && nextChar != '/' && nextChar != '\\') {
                    throw INVALID_NAME;
                }
            } else if (ch == '.' || ch == '/') break;
            ++c;
        }
        return c;
    }

    private static int kindParse(String sn, int id) throws InvalidName {
        int size = sn.length();
        if (id >= size || sn.charAt(id) != '.') {
            return id;
        }
        int c = 0;
        while (c < size) {
            char ch = sn.charAt(c);
            if (ch == '\\') {
                char nextChar;
                if (c == size - 1) {
                    throw INVALID_NAME;
                }
                if ((nextChar = sn.charAt(++c)) != '.' && nextChar != '/' && nextChar != '\\') {
                    throw INVALID_NAME;
                }
            } else if (ch == '/') break;
            ++c;
        }
        return c;
    }

    public Object resolve_str(String sn) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(sn));
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        return NamingContextImpl.toNameComponent(sn);
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        return NamingContextImpl.toString(n);
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (addr == null || addr.length() == 0) {
            throw new InvalidAddress();
        }
        if (sn == null) {
            sn = "";
        }
        addr = NamingContextImpl.escapeURL(addr);
        sn = NamingContextImpl.escapeURL(sn);
        return "corbaname://" + addr + "#" + sn;
    }

    private static String escapeURL(String s) {
        StringBuffer sb = new StringBuffer();
        int size = s.length();
        int c = 0;
        while (c < size) {
            char ch = s.charAt(c);
            if (NamingContextImpl.isEscapable(ch)) {
                sb.append(NamingContextImpl.escape(ch));
            } else {
                sb.append(ch);
            }
            ++c;
        }
        return sb.toString();
    }

    private static boolean isEscapable(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return false;
        }
        int c = 0;
        while (c < escapeExceptions.length) {
            if (ch == escapeExceptions[c]) {
                return false;
            }
            ++c;
        }
        return true;
    }

    private static String escape(char ch) {
        String hex = "0123456789abcdef";
        int charAsInt = ch & 0xFF;
        return "%" + hex.charAt(charAsInt >> 4) + hex.charAt(charAsInt & 0xF);
    }
}

