/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cosnaming;

import com.sap.engine.services.jndi.cosnaming.NamingEnumerationImpl;
import com.sap.engine.services.jndi.implclient.ClientNameParser;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.omg.CORBA.Object;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;

public class CosNamingContext
implements Context {
    static final String DELIM = "/";
    static final String EMPTY_NAME = "<empty>";
    private static final NamingException CLASS_CAST_EXCEPTION = new NamingException("Object must implement org.omg.CORBA.Object");
    private static final NamingException OPERATION_NOT_SUPPORTED_EXCEPTION = new OperationNotSupportedException("This operation is not supported in this version");
    private static final NamingException NOT_CONTEXT_EXCEPTION = new NotContextException();
    static ClientNameParser nameParser = new ClientNameParser();
    private NamingContext ctx;
    private Hashtable env;

    public CosNamingContext(NamingContext namingContext, Hashtable environment) {
        this.ctx = namingContext;
        this.env = environment == null ? new Hashtable() : (Hashtable)environment.clone();
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        try {
            Object result = this.ctx.resolve(CosNamingContext.toCosName(name));
            NamingContext resultContext = null;
            return resultContext == null ? result : new CosNamingContext(resultContext, this.env);
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public java.lang.Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser(name).parse(name));
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        try {
            this.ctx.bind(CosNamingContext.toCosName(name), (Object)obj);
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        this.bind(this.getNameParser(name).parse(name), obj);
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        try {
            this.ctx.rebind(CosNamingContext.toCosName(name), (Object)obj);
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        this.rebind(this.getNameParser(name).parse(name), obj);
    }

    public void unbind(Name name) throws NamingException {
        try {
            this.ctx.unbind(CosNamingContext.toCosName(name));
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser(name).parse(name));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw OPERATION_NOT_SUPPORTED_EXCEPTION;
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.getNameParser(oldName).parse(oldName), this.getNameParser(newName).parse(newName));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name, false);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.list(name, true);
    }

    private NamingEnumeration list(Name name, boolean binds) throws NamingException {
        try {
            Object result = this.ctx.resolve(CosNamingContext.toCosName(name));
            NamingContextExt subContext = null;
            try {
                subContext = NamingContextExtHelper.narrow((Object)result);
            }
            catch (Exception e) {
                throw NOT_CONTEXT_EXCEPTION;
            }
            BindingListHolder blh = new BindingListHolder();
            BindingIteratorHolder bih = new BindingIteratorHolder();
            subContext.list(0, blh, bih);
            return new NamingEnumerationImpl(bih.value, (NamingContext)subContext, binds);
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.getNameParser(name).parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        try {
            Object result = this.ctx.resolve(CosNamingContext.toCosName(name));
            NamingContextExt cosContext = null;
            try {
                cosContext = NamingContextExtHelper.narrow((Object)result);
            }
            catch (Exception e) {
                throw NOT_CONTEXT_EXCEPTION;
            }
            cosContext.destroy();
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.getNameParser(name).parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        try {
            return new CosNamingContext(this.ctx.bind_new_context(CosNamingContext.toCosName(name)), this.env);
        }
        catch (Exception e) {
            throw CosNamingContext.handleException(e);
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.getNameParser(name).parse(name));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return ((Name)prefix.clone()).addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(this.getNameParser(name).parse(name), this.getNameParser(prefix).parse(prefix)).toString();
    }

    public java.lang.Object addToEnvironment(String propName, java.lang.Object propVal) throws NamingException {
        return this.env.put(propName, propVal);
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        return this.env.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.env;
    }

    public void close() throws NamingException {
        this.env.clear();
    }

    public String getNameInNamespace() throws NamingException {
        throw OPERATION_NOT_SUPPORTED_EXCEPTION;
    }

    static NameComponent[] toCosName(Name name) {
        Enumeration<String> en = name.getAll();
        ArrayList<NameComponent> nameComponentList = new ArrayList<NameComponent>();
        while (en.hasMoreElements()) {
            String n = en.nextElement();
            int dotIndex = n.indexOf(".");
            String kind = "";
            if (dotIndex != -1) {
                kind = n.substring(dotIndex + 1);
                n = n.substring(0, dotIndex);
            }
            if (n.equals(EMPTY_NAME)) {
                n = "";
            }
            nameComponentList.add(new NameComponent(n, kind));
        }
        NameComponent[] result = new NameComponent[nameComponentList.size()];
        int c = 0;
        Iterator i = nameComponentList.iterator();
        while (i.hasNext()) {
            result[c] = (NameComponent)i.next();
            ++c;
        }
        return result;
    }

    static String toString(Name name) {
        Enumeration<String> en = name.getAll();
        StringBuffer sb = new StringBuffer();
        while (en.hasMoreElements()) {
            String n = en.nextElement();
            sb.append(n + DELIM);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - DELIM.length());
        }
        return sb.toString();
    }

    static NamingException handleException(Exception e) {
        if (e instanceof NamingException) {
            return (NamingException)e;
        }
        if (e instanceof NotFound) {
            return new NameNotFoundException(e.getLocalizedMessage());
        }
        if (e instanceof CannotProceed) {
            return new CannotProceedException(e.getLocalizedMessage());
        }
        if (e instanceof InvalidName) {
            return new InvalidNameException(e.getLocalizedMessage());
        }
        if (e instanceof AlreadyBound) {
            return new NameAlreadyBoundException(e.getLocalizedMessage());
        }
        if (e instanceof ClassCastException) {
            return CLASS_CAST_EXCEPTION;
        }
        return new NamingException(e.getLocalizedMessage());
    }
}

