/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cosnaming;

import java.util.Iterator;
import java.util.List;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingHolder;
import org.omg.CosNaming.BindingIteratorOperations;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming._BindingIteratorImplBase;

public class BindingIteratorImpl
extends _BindingIteratorImplBase
implements BindingIteratorOperations {
    private static final Binding EMPTY_BINDING = new Binding(new NameComponent[0], BindingType.nobject);
    private Iterator iterator;
    private int index;
    private int fullSize;
    static final long serialVersionUID = 5368952935822420948L;

    BindingIteratorImpl(List bindings) {
        this.iterator = bindings.iterator();
        this.index = 0;
        this.fullSize = bindings.size();
    }

    public boolean next_one(BindingHolder bindingHolder) {
        bindingHolder.value = this.iterator == null ? EMPTY_BINDING : this.get();
        return this.iterator != null;
    }

    public boolean next_n(int how_many, BindingListHolder bindingListHolder) {
        int size = Math.min(how_many, this.fullSize - this.index);
        Binding[] bindings = new Binding[size];
        int c = 0;
        while (c < size) {
            bindings[c] = this.get();
            ++c;
        }
        bindingListHolder.value = bindings;
        return this.iterator != null;
    }

    private Binding get() {
        Binding binding = (Binding)this.iterator.next();
        if (++this.index >= this.fullSize) {
            this.iterator = null;
        }
        return binding;
    }

    public void destroy() {
        this.iterator = null;
    }
}

