/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cluster;

import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import java.io.Serializable;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;

public class DirObject
implements Serializable {
    private Attributes attr = null;
    private Object obj = null;
    private String className = null;
    static final long serialVersionUID = -7131494175083268593L;

    public DirObject() {
    }

    public DirObject(Attributes attr, Object obj) {
        this.attr = attr;
        this.obj = obj;
        this.className = obj == null ? "null" : obj.getClass().getName();
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setObject(Object obj) {
        this.obj = obj;
    }

    public Object getObject() {
        return this.obj;
    }

    public void setAttributes(Attributes attr) {
        this.attr = attr;
    }

    public Attributes getAttributes() {
        return this.attr;
    }

    public static byte[] getNewDirObject(Attributes attributes, Object obj) {
        DirObject dirObject = new DirObject(attributes, obj);
        String classname = dirObject.getClassName();
        byte[] result = null;
        byte[] tempAttr = null;
        byte[] tempClassName = null;
        byte[] tempObject = null;
        int offs = 0;
        int resOffs = 0;
        try {
            if (attributes == null) {
                attributes = new BasicAttributes();
            }
            tempAttr = Serializator.toByteArray(attributes);
            tempClassName = classname.getBytes();
            tempObject = Serializator.toByteArray(obj);
            result = new byte[4 + tempAttr.length + 4 + tempClassName.length + 4 + tempObject.length];
            offs = tempAttr.length;
            result[0] = (byte)(0xFF & offs);
            result[1] = (byte)(0xFF & offs >> 8);
            result[2] = (byte)(0xFF & offs >> 16);
            result[3] = (byte)(0xFF & offs >> 24);
            System.arraycopy(tempAttr, 0, result, 6, offs);
            resOffs = offs + 4;
            offs = tempClassName.length;
            result[resOffs] = (byte)(0xFF & offs);
            result[resOffs + 1] = (byte)(0xFF & offs >> 8);
            result[resOffs + 2] = (byte)(0xFF & offs >> 16);
            result[resOffs + 3] = (byte)(0xFF & offs >> 24);
            System.arraycopy(tempClassName, 0, result, resOffs += 4, offs);
            resOffs += offs;
            offs = tempObject.length;
            result[resOffs] = (byte)(0xFF & offs);
            result[resOffs + 1] = (byte)(0xFF & offs >> 8);
            result[resOffs + 2] = (byte)(0xFF & offs >> 16);
            result[resOffs + 3] = (byte)(0xFF & offs >> 24);
            System.arraycopy(tempObject, 0, result, resOffs += 4, offs);
        }
        catch (Exception e) {
            JNDIFrame.log.logCatching(e);
        }
        return result;
    }

    public static Attributes getAttributes(byte[] data) {
        int attributesLength = data[3] << 8 & 0xFF000000 | data[2] << 8 & 0xFF0000 | data[1] << 8 & 0xFF00 | data[0] & 0xFF;
        byte[] attributesByteArray = new byte[attributesLength];
        System.arraycopy(data, 4, attributesByteArray, 0, attributesLength);
        try {
            return (Attributes)Serializator.toObject(attributesByteArray);
        }
        catch (JNDIException jex) {
            JNDIFrame.log.logCatching((Throwable)((Object)jex));
            return new BasicAttributes();
        }
    }

    public static byte[] setAttributes(byte[] data, Attributes attr) {
        int attributesLength = data[3] << 8 & 0xFF000000 | data[2] << 8 & 0xFF0000 | data[1] << 8 & 0xFF00 | data[0] & 0xFF;
        byte[] newAttributes = null;
        if (attr == null) {
            attr = new BasicAttributes();
        }
        try {
            newAttributes = Serializator.toByteArray(attr);
        }
        catch (JNDIException jex) {
            JNDIFrame.log.logCatching((Throwable)((Object)jex));
        }
        int totalSize = data.length - attributesLength + newAttributes.length;
        byte[] newData = new byte[totalSize];
        newData[0] = (byte)(0xFF & newAttributes.length);
        newData[1] = (byte)(0xFF & newAttributes.length >> 8);
        newData[2] = (byte)(0xFF & newAttributes.length >> 16);
        newData[3] = (byte)(0xFF & newAttributes.length >> 24);
        System.arraycopy(newAttributes, 0, newData, 4, newAttributes.length);
        System.arraycopy(data, attributesLength + 4, newData, 4 + newAttributes.length, data.length - 4 - attributesLength);
        return newData;
    }

    public static String getClassName(byte[] data) {
        int lengthOffset = (data[3] << 8 & 0xFF000000 | data[2] << 8 & 0xFF0000 | data[1] << 8 & 0xFF00 | data[0] & 0xFF) + 4;
        int classNameArrayLength = data[lengthOffset + 3] << 8 & 0xFF000000 | data[lengthOffset + 2] << 8 & 0xFF0000 | data[lengthOffset + 1] << 8 & 0xFF00 | data[lengthOffset] & 0xFF;
        byte[] classNameByteArray = new byte[classNameArrayLength];
        System.arraycopy(data, lengthOffset + 4, classNameByteArray, 0, classNameArrayLength);
        return new String(classNameByteArray);
    }

    public String toString() {
        return "{ {OBJECT: " + this.obj + " }\n{ ATTRIBUTES: " + this.attr + " }";
    }

    private void dumpi(String s) {
        System.out.println("DIROBJECT: " + s);
    }
}

