/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.services.jndi.JNDIFrame;

public final class MonitorBlock {
    private int access = 0;
    private int wannaBeChangers = 0;
    private boolean change = false;

    public synchronized void tryToChange() {
        ++this.wannaBeChangers;
        while (this.access > 0 || this.change) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                JNDIFrame.log.logCatching(ie);
            }
        }
        this.change = true;
        --this.wannaBeChangers;
    }

    public synchronized void tryToAccess() {
        while (this.change || this.wannaBeChangers > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                JNDIFrame.log.logCatching(ie);
            }
        }
        ++this.access;
    }

    public synchronized void endChange() {
        this.change = false;
        this.notifyAll();
    }

    public synchronized void endAccess() {
        --this.access;
        this.notifyAll();
    }
}

