/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi.cache;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.cluster.message.DestinationLostException;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.message.PartialResponseException;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.util.ConcurrentArrayObject;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.JNDIManager;
import com.sap.engine.services.jndi.cache.Cache;
import com.sap.engine.services.jndi.cache.CacheCommunicator;
import com.sap.engine.services.jndi.cache.MonitorBlock;
import com.sap.engine.services.jndi.cache.ReplicationCounter;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.Serializator;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.engine.services.jndi.persistentimpl.memory.JNDIMemoryImpl;
import com.sap.exception.BaseRuntimeException;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;

public class CacheCommunicatorImpl
implements ServiceEventListener,
MessageListener,
CacheCommunicator,
ClusterEventListener {
    static MessageContext msgContext = null;
    public static ClusterContext clContext = null;
    static Cache cache = null;
    public static final int REPLICATE_OBJECT_BIND = 2;
    public static final int REPLICATE_OBJECT_REBIND = 3;
    public static final int REPLICATE_CONTAINER_CREATE = 4;
    public static final int REPLICATE_CONTAINER_DELETE = 5;
    public static final int REPLICATE_LINK_OBJECT_TO_CONTAINER = 6;
    public static final int REPLICATE_CONTAINER_MODIFY = 7;
    public static final int REPLICATE_REMOVE_LINKED_CONTAINER = 8;
    public static final int REPLICATE_RENAME_OBJECT = 9;
    public static final int REPLICATE_UNBIND_OBJECT = 10;
    public static final int REPLICATE_ALL_BINDINGS = 11;
    public static final int END_OF_GLOBAL_OBJECTS_SENDDING = 12;
    public static final int CLUSTER_LOCK = 13;
    public static final int CLUSTER_UNLOCK = 14;
    public static final int REPLICATION_MESSAGE = 15;
    public static MonitorBlock monitor = new MonitorBlock();
    static ArrayInt whoLockedMe = new ArrayInt();
    static boolean replicationCompleted = false;
    public ReplicationCounter replicationCounter;

    public CacheCommunicatorImpl(ApplicationServiceContext srvCtx) {
        block9: {
            block8: {
                this.replicationCounter = new ReplicationCounter(0);
                msgContext = srvCtx.getClusterContext().getMessageContext();
                clContext = srvCtx.getClusterContext();
                try {
                    msgContext.registerListener(this);
                    if (JNDIFrame.log.toLogPathInLocation()) {
                        JNDIFrame.log.logPath(JNDILogConstants.MESSAGE_LISTENER_REGISTERED);
                    }
                }
                catch (ListenerAlreadyRegisteredException lare) {
                    msgContext.unregisterListener();
                    try {
                        msgContext.registerListener(this);
                        if (JNDIFrame.log.toLogPathInLocation()) {
                            JNDIFrame.log.logPath(JNDILogConstants.MESSAGE_LISTENER_REGISTERED);
                        }
                    }
                    catch (ListenerAlreadyRegisteredException e) {
                        if (!JNDIFrame.log.toLogWarningInLocation()) break block8;
                        JNDIFrame.log.logWarning(JNDILogConstants.MESSAGE_LISTENER_ALREADY_REGISTERED);
                        JNDIFrame.log.logCatching((Throwable)((Object)e));
                    }
                }
            }
            try {
                srvCtx.getServiceState().registerServiceEventListener(this);
                srvCtx.getServiceState().registerClusterEventListener(this);
            }
            catch (ListenerAlreadyRegisteredException e) {
                if (!JNDIFrame.log.toLogWarningInLocation()) break block9;
                JNDIFrame.log.logWarning(JNDILogConstants.LISTENER_ALREADY_REGISTERED_EXCEPTION_OCCURED);
                JNDIFrame.log.logCatching((Throwable)((Object)e));
            }
        }
    }

    public void setCache(Cache ch) {
        cache = ch;
    }

    public void serviceStarted(ClusterElement elementInfo) {
    }

    public void serviceStopped(ClusterElement elementInfo) {
        cache.emptyReferencableCache();
    }

    public void receive(int clusterId, int messageId, byte[] message, int offset, int length) {
        try {
            if (messageId == 0) {
                cache.removeLocalCache((String)Serializator.toObject(message));
                return;
            }
            if (messageId == 1) {
                cache.emptyReferencableCache();
                return;
            }
            if (messageId == 15) {
                int i = 0;
                do {
                    int sizeOfMessageType = message[i];
                    byte[] msgType_ = new byte[sizeOfMessageType];
                    ++i;
                    if (sizeOfMessageType > 0) {
                        int j = 0;
                        while (j < sizeOfMessageType) {
                            msgType_[j] = message[i];
                            ++j;
                            ++i;
                        }
                    }
                    int msgType = Convert.byteArrToInt(msgType_, 0);
                    int sizeOfMessageLength = message[i];
                    byte[] msgLength_ = new byte[sizeOfMessageLength];
                    ++i;
                    if (sizeOfMessageLength > 0) {
                        int j = 0;
                        while (j < sizeOfMessageLength) {
                            msgLength_[j] = message[i];
                            ++j;
                            ++i;
                        }
                    }
                    int msgLength = Convert.byteArrToInt(msgLength_, 0);
                    byte[] msg = new byte[msgLength];
                    if (msgLength > 0) {
                        int j = 0;
                        while (j < msgLength) {
                            msg[j] = message[i];
                            ++j;
                            ++i;
                        }
                    }
                    this.messageProcesing(clusterId, msgType, msg, msgLength);
                } while (i < length);
            } else {
                this.messageProcesing(clusterId, messageId, message, length);
            }
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogWarningInLocation()) {
                JNDIFrame.log.logWarning(RuntimeExceptionConstants.CANNOT_PROCCESS_MESSAGE, new Object[]{new Integer(clusterId)});
                JNDIFrame.log.logCatching(e);
            }
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_PROCCESS_MESSAGE, new Object[]{new Integer(clusterId)}), (Throwable)e);
            bre.log();
            throw bre;
        }
    }

    private void messageProcesing(int clusterId, int messageId, byte[] message, int length) throws JNDIException {
        byte[] objectName;
        byte[] containerName;
        int sizeCid = message[0];
        byte[] cid = new byte[sizeCid];
        int i = 1;
        if (sizeCid > 0) {
            int j = 0;
            while (j < sizeCid) {
                cid[j] = message[i];
                ++j;
                ++i;
            }
        }
        int sizeOid = message[i];
        byte[] oid = new byte[sizeOid];
        ++i;
        if (sizeOid > 0) {
            int j = 0;
            while (j < sizeOid) {
                oid[j] = message[i];
                ++j;
                ++i;
            }
        }
        int sizencLength = message[i];
        byte[] sizenc = new byte[sizencLength];
        ++i;
        if (sizencLength > 0) {
            int j = 0;
            while (j < sizencLength) {
                sizenc[j] = message[i];
                ++j;
                ++i;
            }
        }
        if ((containerName = new byte[Convert.byteArrToInt(sizenc, 0)]).length > 0) {
            int j = 0;
            while (j < containerName.length) {
                containerName[j] = message[i];
                ++j;
                ++i;
            }
        }
        int sizenLength = message[i];
        byte[] sizen = new byte[sizenLength];
        ++i;
        if (sizenLength > 0) {
            int j = 0;
            while (j < sizenLength) {
                sizen[j] = message[i];
                ++j;
                ++i;
            }
        }
        if ((objectName = new byte[Convert.byteArrToInt(sizen, 0)]).length > 0) {
            int j = 0;
            while (j < objectName.length) {
                objectName[j] = message[i];
                ++j;
                ++i;
            }
        }
        int sized = length - sizeCid - sizeOid - sizencLength - sizenLength - containerName.length - objectName.length - 7;
        byte[] data = new byte[sized];
        if (sized > 0) {
            int j = 0;
            while (j < sized) {
                data[j] = message[i];
                ++j;
                ++i;
            }
        }
        short operationType = message[i];
        long containerId = Convert.byteArrToLong(cid, 0);
        long objectId = Convert.byteArrToLong(oid, 0);
        String containerName_ = new String(containerName);
        String objectName_ = new String(objectName);
        if (messageId == 2) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateObjectBind(containerName_, objectName_, data, objectId, operationType);
        } else if (messageId == 3) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateObjectRebind(containerName_, objectName_, data, objectId, operationType);
        } else if (messageId == 4) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateContainer(containerName_, data, containerId);
        } else if (messageId == 5) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateContainerDelete(containerId);
        } else if (messageId == 6) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateLinkObjectToContainer(containerName_, objectName_, objectId);
        } else if (messageId == 7) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateModifyContainer(containerId, data);
        } else if (messageId == 8) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateRemoveLinkedContainer(containerId, objectId);
        } else if (messageId == 9) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateRenameObject(containerName_, objectName_, objectId);
        } else if (messageId == 10) {
            ((JNDIMemoryImpl)JNDIManager.db).replicateUnbindObject(containerName_, objectId);
        }
    }

    public MessageAnswer receiveWait(int clusterId, int messageId, byte[] message, int offset, int length) {
        byte[] id = new byte[4];
        if (messageId == 13) {
            if (!replicationCompleted) {
                Convert.writeIntToByteArr(id, 0, 2);
                this.tryToLock(clusterId);
                return new MessageAnswer(id, 0, 4);
            }
            Convert.writeIntToByteArr(id, 0, this.tryToLock(clusterId));
            return new MessageAnswer(id, 0, 4);
        }
        if (messageId == 14) {
            Convert.writeIntToByteArr(id, 0, this.unlock(clusterId));
            return new MessageAnswer(id, 0, 4);
        }
        if (messageId == 11) {
            int objectsCounter;
            block6: {
                objectsCounter = -1;
                try {
                    objectsCounter = ((JNDIMemoryImpl)JNDIManager.db).toSendGlobalObjects(clusterId, null);
                }
                catch (JNDIException e) {
                    if (!JNDIFrame.log.toLogWarningInCategory()) break block6;
                    JNDIFrame.log.warningT(JNDILogConstants.REPLICATION_ERROR, new Object[]{String.valueOf(clusterId), ((Throwable)((Object)e)).toString()});
                    JNDIFrame.log.logCatching((Throwable)((Object)e));
                }
            }
            byte[] answer = new byte[4];
            Convert.writeIntToByteArr(answer, 0, objectsCounter);
            return new MessageAnswer(answer, 0, answer.length);
        }
        return new MessageAnswer(new byte[0], 0, 0);
    }

    private int tryToLock(int clusterId) {
        ArrayInt arrayInt = whoLockedMe;
        synchronized (arrayInt) {
            if (whoLockedMe.isEmpty()) {
                monitor.tryToChange();
                whoLockedMe.add(clusterId);
                int n = 0;
                return n;
            }
            if (!whoLockedMe.contains(clusterId)) {
                whoLockedMe.add(clusterId);
                int n = 0;
                return n;
            }
            int n = 1;
            return n;
        }
    }

    private int unlock(int clusterId) {
        ArrayInt arrayInt = whoLockedMe;
        synchronized (arrayInt) {
            if (whoLockedMe.contains(clusterId)) {
                whoLockedMe.remove(clusterId);
                if (whoLockedMe.isEmpty()) {
                    monitor.endChange();
                }
            }
            int n = 0;
            return n;
        }
    }

    public void notifyCluster(String nm) {
        try {
            byte[] msg = Serializator.toByteArray(nm);
            this.sendToAll(msg, 0, msg.length);
        }
        catch (JNDIException e) {
            if (JNDIFrame.log.toLogWarningInLocation()) {
                JNDIFrame.log.logWarning(RuntimeExceptionConstants.CANNOT_NOTIFY_CLUSTER_FOR_NAME_REMOVED, new Object[]{nm});
                JNDIFrame.log.logCatching((Throwable)((Object)e));
            }
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_NOTIFY_CLUSTER_FOR_NAME_REMOVED, new Object[]{nm}), (Throwable)((Object)e));
            bre.log();
            throw bre;
        }
    }

    public String getName() {
        return "CacheCommunicatorImpl";
    }

    public void sendToAll(byte[] message, int type, int length) {
        if (clContext.getClusterMonitor().getCurrentParticipant().getState() != 7) {
            try {
                msgContext.send(-1, (byte)2, type, message, 0, length);
            }
            catch (ClusterException ce) {
                if (JNDIFrame.log.toLogWarningInLocation()) {
                    JNDIFrame.log.logWarning(RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER);
                    JNDIFrame.log.logCatching((Throwable)((Object)ce));
                }
                BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER), (Throwable)((Object)ce));
                bre.log();
                throw bre;
            }
        }
    }

    public MultipleAnswer sendToAllAndWaitForAnswer(byte[] message, int type, int length) {
        MultipleAnswer ma = null;
        if (clContext.getClusterMonitor().getCurrentParticipant().getState() != 7) {
            try {
                ma = msgContext.sendAndWaitForAnswer(0, (byte)2, type, message, 0, length, 100000L);
            }
            catch (PartialResponseException pre) {
                if (JNDIFrame.log.toLogWarningInLocation()) {
                    JNDIFrame.log.logWarning(JNDILogConstants.PARTIAL_RESPONCE, new Object[]{String.valueOf(type), ((Throwable)((Object)pre)).toString()});
                    JNDIFrame.log.logCatching((Throwable)((Object)pre));
                }
                ma = pre.getPartialResponse();
            }
            catch (ClusterException ce) {
                if (JNDIFrame.log.toLogWarningInLocation()) {
                    JNDIFrame.log.logWarning(RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER);
                    JNDIFrame.log.logCatching((Throwable)((Object)ce));
                }
                BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER), (Throwable)((Object)ce));
                bre.log();
                throw bre;
            }
        }
        return ma;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendToServer(int clusterId, byte[] message, int type, int length) {
        int idToSend = 0;
        if (clContext.getClusterMonitor().getCurrentParticipant().getState() == 7) return;
        ClusterElement clElement = clContext.getClusterMonitor().getParticipant(clusterId);
        if (clusterId == 0) {
            ConcurrentArrayObject clusterElements = this.getClusterElements();
            if (clusterElements.size() <= 0) return;
            idToSend = (Integer)clusterElements.firstElement();
        } else {
            if (clElement == null || clElement.getState() == 7) return;
            idToSend = clusterId;
        }
        try {
            msgContext.send(idToSend, type, message, 0, length);
            return;
        }
        catch (ClusterException ce) {
            if (JNDIFrame.log.toLogWarningInLocation()) {
                JNDIFrame.log.logWarning(RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER_ELEMENT, new Object[]{String.valueOf(idToSend)});
                JNDIFrame.log.logCatching((Throwable)((Object)ce));
            }
            BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER_ELEMENT, new Object[]{String.valueOf(idToSend)}), (Throwable)((Object)ce));
            bre.log();
            throw bre;
        }
    }

    public MessageAnswer sendToServerAndWaitForAnswer(int clusterId, byte[] message, int type, int length) {
        if (clContext.getClusterMonitor().getCurrentParticipant().getState() != 7) {
            ClusterElement clElement = clContext.getClusterMonitor().getParticipant(clusterId);
            if (clElement != null && clElement.getState() != 7) {
                try {
                    return msgContext.sendAndWaitForAnswer(clusterId, type, message, 0, length, 100000L);
                }
                catch (ClusterException ce) {
                    if (ce instanceof DestinationLostException) {
                        if (JNDIFrame.log.toLogWarningInLocation()) {
                            JNDIFrame.log.logWarning(JNDILogConstants.REPLICATING_SERVER_CRASHED, new Object[]{String.valueOf(((DestinationLostException)ce).getClusterId())});
                            JNDIFrame.log.logCatching((Throwable)((Object)ce));
                        }
                        BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), JNDILogConstants.REPLICATING_SERVER_CRASHED, new Object[]{String.valueOf(((DestinationLostException)ce).getClusterId())}), (Throwable)((Object)ce));
                        throw bre;
                    }
                    if (JNDIFrame.log.toLogWarningInLocation()) {
                        JNDIFrame.log.logWarning(RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER_ELEMENT, new Object[]{String.valueOf(clusterId)});
                        JNDIFrame.log.logCatching((Throwable)((Object)ce));
                    }
                    BaseRuntimeException bre = new BaseRuntimeException((LocalizableText)new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.CANNOT_SEND_MESSAGE_TO_CLUSTER_ELEMENT, new Object[]{String.valueOf(clusterId)}), (Throwable)((Object)ce));
                    bre.log();
                    throw bre;
                }
            }
            return null;
        }
        return null;
    }

    public ConcurrentArrayObject getClusterElements() {
        ClusterMonitor clusterMonitor = clContext.getClusterMonitor();
        ClusterElement[] infos = clusterMonitor.getServiceNodes();
        ConcurrentArrayObject clusterElements = new ConcurrentArrayObject();
        int i = 0;
        while (i < infos.length) {
            if (infos[i] != null && infos[i].getType() == 2 && infos[i].getType() != 7) {
                clusterElements.add(new Integer(infos[i].getClusterId()));
            }
            ++i;
        }
        return clusterElements;
    }

    public void setReplicationCompleted(boolean value) {
        replicationCompleted = value;
    }

    public void elementJoin(ClusterElement clusterElement) {
    }

    public void elementLoss(ClusterElement clusterElement) {
        this.unlock(clusterElement.getClusterId());
    }

    public void elementStateChanged(ClusterElement clusterElement, byte b) {
    }
}

