/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.frame.state.ManagementListener;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.JNDIManagementInterface;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.implserver.ServerContextImpl;
import com.sap.engine.services.jndi.persistent.exceptions.RemoteException;
import java.io.Serializable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.rmi.PortableRemoteObject;
import javax.swing.tree.DefaultMutableTreeNode;

public class PermissionAdministrator
extends PortableRemoteObject
implements JNDIManagementInterface {
    public synchronized Object getPermissions() throws java.rmi.RemoteException {
        try {
            return SecurityBase.getPrincipals();
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(RemoteException.CANNOT_GET_PERMISSIONS);
                JNDIFrame.log.logCatching(e);
            }
            RemoteException re = new RemoteException(RemoteException.CANNOT_GET_PERMISSIONS, e);
            re.log();
            throw re;
        }
    }

    public synchronized Object getPermissions(String permissionName) throws java.rmi.RemoteException {
        try {
            return SecurityBase.getPrincipals(permissionName);
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(RemoteException.CANNOT_GET_PERMISSION, new Object[]{permissionName});
                JNDIFrame.log.logCatching(e);
            }
            RemoteException re = new RemoteException(RemoteException.CANNOT_GET_PERMISSION, new Object[]{permissionName}, e);
            re.log();
            throw re;
        }
    }

    public void addPermission(String userName, String permissionName, boolean isGroup) throws java.rmi.RemoteException {
        try {
            SecurityBase.allowOperation(userName, permissionName, isGroup);
        }
        catch (Exception e) {
            RemoteException re = null;
            if (isGroup) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(RemoteException.CANNOT_ADD_PERMISSION_TO_GROUP, new Object[]{permissionName, userName});
                    JNDIFrame.log.logCatching(e);
                }
                re = new RemoteException(RemoteException.CANNOT_ADD_PERMISSION_TO_GROUP, new Object[]{permissionName, userName}, e);
            } else {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(RemoteException.CANNOT_ADD_PERMISSION_TO_USER, new Object[]{permissionName, userName});
                    JNDIFrame.log.logCatching(e);
                }
                re = new RemoteException(RemoteException.CANNOT_ADD_PERMISSION_TO_USER, new Object[]{permissionName, userName}, e);
            }
            re.log();
            throw re;
        }
    }

    public void removePermission(String userName, String permissionName, boolean isGroup) throws java.rmi.RemoteException {
        try {
            SecurityBase.denyOperation(userName, permissionName, isGroup);
        }
        catch (Exception e) {
            RemoteException re = null;
            if (isGroup) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(RemoteException.CANNOT_REMOVE_PERMISSION_FROM_GROUP, new Object[]{permissionName, userName});
                    JNDIFrame.log.logCatching(e);
                }
                re = new RemoteException(RemoteException.CANNOT_REMOVE_PERMISSION_FROM_GROUP, new Object[]{permissionName, userName}, e);
            } else {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(RemoteException.CANNOT_REMOVE_PERMISSION_FROM_USER, new Object[]{permissionName, userName});
                    JNDIFrame.log.logCatching(e);
                }
                re = new RemoteException(RemoteException.CANNOT_REMOVE_PERMISSION_FROM_USER, new Object[]{permissionName, userName}, e);
            }
            re.log();
            throw re;
        }
    }

    public Object listAllBindings() throws java.rmi.RemoteException {
        try {
            InitialContext ctx = new InitialContext();
            DefaultMutableTreeNode treeNode = new DefaultMutableTreeNode("root", true);
            this.initTree(treeNode, ctx);
            return treeNode;
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(RemoteException.CANNOT_LIST_BINDINGS);
                JNDIFrame.log.logCatching(e);
            }
            RemoteException re = new RemoteException(RemoteException.CANNOT_LIST_BINDINGS, e);
            re.log();
            throw re;
        }
    }

    public Object getUsersTree() throws java.rmi.RemoteException {
        try {
            return SecurityBase.getUsersTree();
        }
        catch (Exception e) {
            if (JNDIFrame.log.toLogInfoInCategory()) {
                JNDIFrame.log.infoT(RemoteException.CANNOT_GET_USERS_AND_GROUPS);
                JNDIFrame.log.logCatching(e);
            }
            RemoteException re = new RemoteException(RemoteException.CANNOT_GET_USERS_AND_GROUPS, e);
            re.log();
            throw re;
        }
    }

    private void initTree(DefaultMutableTreeNode treeNode, Context ctx) throws NamingException {
        NamingEnumeration<Binding> nenum = ctx.listBindings("");
        Binding binding = null;
        String name = null;
        String className = null;
        String objectValue = null;
        Object o = null;
        boolean isContext = false;
        DefaultMutableTreeNode newNode = null;
        while (nenum.hasMoreElements()) {
            try {
                binding = (Binding)nenum.nextElement();
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
            if (binding == null) continue;
            name = binding.getName();
            className = binding.getClassName();
            objectValue = "";
            o = binding.getObject();
            isContext = o != null ? o instanceof Context : false;
            newNode = null;
            Object objref = null;
            if (isContext) {
                newNode = new DefaultMutableTreeNode(name + "   [Context]", isContext);
            } else {
                objectValue = o != null ? (o instanceof Serializable ? o.toString().replace('\n', ' ') : "NON Serializable Object") : "null";
                newNode = new DefaultMutableTreeNode(name, true);
                PermissionAdministrator.insertInfo(newNode, className, objectValue);
            }
            PermissionAdministrator.insertSorted(treeNode, newNode, isContext);
            if (!isContext) continue;
            try {
                objref = ctx.lookup(name);
            }
            catch (Exception e) {
                JNDIFrame.log.logCatching(e);
            }
            if (objref == null || !(objref instanceof DirContext)) continue;
            this.initTree(newNode, (Context)objref);
        }
    }

    private static void insertSorted(DefaultMutableTreeNode parent, DefaultMutableTreeNode child, boolean isContext) {
        int index = 0;
        int childCount = parent.getChildCount();
        DefaultMutableTreeNode nextNode = null;
        boolean nextIsContext = false;
        Object userObject = null;
        while (index < childCount) {
            nextNode = (DefaultMutableTreeNode)parent.getChildAt(index);
            userObject = nextNode.getUserObject();
            nextIsContext = userObject instanceof String ? ((String)userObject).endsWith("[Context]") : nextNode.getAllowsChildren();
            if (isContext == nextIsContext && child.toString().compareToIgnoreCase(nextNode.toString()) < 0 || !isContext && nextIsContext) break;
            ++index;
        }
        parent.insert(child, index);
    }

    private static void insertInfo(DefaultMutableTreeNode child, String className, String objectValue) {
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode("[Class Name] : " + className, false);
        child.insert(newNode, 0);
        newNode = new DefaultMutableTreeNode("[Object Value] : " + objectValue, false);
        child.insert(newNode, 1);
    }

    public void registerManagementListener(ManagementListener managementListener) {
    }

    public int getByteArrayCacheSize() {
        return ServerContextImpl.cache.getByteArrayCacheSize();
    }

    public int getBoundObjectsCount() {
        return ServerContextImpl.getNumberOfBindings();
    }
}

