/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.lib.security.http.HttpGetterCallback;
import com.sap.engine.lib.security.http.HttpSetterCallback;
import com.sap.engine.services.jndi.JNDIFrame;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import java.io.IOException;
import java.util.Hashtable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class NamingCallbackHandler
implements CallbackHandler {
    public static final String SECURITY_CREDENTIAL = "sap.security.credential.";
    public static final String DIVIDER = ".";
    Hashtable properties = null;

    public NamingCallbackHandler(Hashtable properties) {
        this.properties = properties;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        int i = 0;
        while (i < callbacks.length) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName((String)this.properties.get("java.naming.security.principal"));
            } else if (callbacks[i] instanceof PasswordCallback) {
                String pass = (String)this.properties.get("java.naming.security.credentials");
                ((PasswordCallback)callbacks[i]).setPassword(pass != null ? pass.toCharArray() : null);
            } else if (callbacks[i] instanceof HttpGetterCallback) {
                HttpGetterCallback getterCallback = (HttpGetterCallback)callbacks[i];
                Object value = this.properties.get(SECURITY_CREDENTIAL + getterCallback.getType() + DIVIDER + getterCallback.getName());
                getterCallback.setValue(value);
            } else if (!(callbacks[i] instanceof HttpSetterCallback)) {
                if (JNDIFrame.log.toLogInfoInCategory()) {
                    JNDIFrame.log.infoT(JNDILogConstants.UNSUPPORTED_CALLBACK, new Object[]{callbacks[i]});
                }
                throw new UnsupportedCallbackException(callbacks[i], " Unsupported callback! ");
            }
            ++i;
        }
    }
}

