/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.services.jndi.InitialContextFactoryImpl;
import com.sap.engine.services.jndi.persistent.exceptions.NamingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LoadBalancerEnvironment {
    public static final String HTTP_PROTOCOL = "http";
    public static final String BALANCER_PREFIX = "sapms";
    public static final String MESSAGE_SERVER_FILE = "/msgserver/text/logon";
    public static final String MESSAGE_SERVER_P4_PREFIX = "P4";
    public static final String BEGIN_MESSAGE_DELIM = "://";
    public static final String BEGIN_MS_PREF = "sapms://";
    public static final String NAMING_HOST_PORT_DELIM = ":";
    public static final String BALANCED_URL = "sap.msg.balanced_url";
    public static URL msgSrvURL = null;
    static String msg_host = null;
    static int msg_port = 0;

    public static Hashtable updateEnv(Hashtable environment) throws NamingException {
        String url;
        String string = url = environment.containsKey("java.naming.provider.url") ? environment.get("java.naming.provider.url").toString().trim() : InitialContextFactoryImpl.systemProperties.getProperty("java.naming.provider.url");
        if (url != null && url.indexOf(BEGIN_MS_PREF) != -1 && url.startsWith(BEGIN_MS_PREF) && !environment.containsKey(BALANCED_URL)) {
            int protocol_delim = url.indexOf(BEGIN_MESSAGE_DELIM);
            int colonIndex = url.lastIndexOf(NAMING_HOST_PORT_DELIM);
            if (colonIndex <= protocol_delim) {
                throw new NamingException(NamingException.WRONG_MS_URL, new Object[]{url});
            }
            try {
                if (protocol_delim != -1 && colonIndex != -1) {
                    msg_host = url.substring(protocol_delim + BEGIN_MESSAGE_DELIM.length(), colonIndex);
                    msg_port = Integer.parseInt(url.substring(colonIndex + NAMING_HOST_PORT_DELIM.length()));
                }
            }
            catch (RuntimeException e) {
                throw new NamingException(NamingException.WRONG_PARAMETERS, new Object[]{url, e.toString()}, e);
            }
            InputStream stream = null;
            try {
                msgSrvURL = new URL(HTTP_PROTOCOL, msg_host, msg_port, MESSAGE_SERVER_FILE);
            }
            catch (MalformedURLException mue) {
                throw new NamingException(NamingException.UNABLE_TO_GET_CONNECTION_PARAMETERS, new Object[]{msg_host + NAMING_HOST_PORT_DELIM + msg_port, mue.toString()}, mue);
            }
            try {
                stream = msgSrvURL.openStream();
            }
            catch (IOException ioe) {
                throw new NamingException(NamingException.UNABLE_TO_GET_CONNECTION_PARAMETERS, new Object[]{msg_host + NAMING_HOST_PORT_DELIM + msg_port, ioe.toString()}, ioe);
            }
            catch (RuntimeException e) {
                throw new NamingException(NamingException.UNABLE_TO_GET_CONNECTION_PARAMETERS, new Object[]{msg_host + NAMING_HOST_PORT_DELIM + msg_port, e.toString()}, e);
            }
            String balanced_url = LoadBalancerEnvironment.loadBalanceDispatcher(LoadBalancerEnvironment.parseMSGFile(stream));
            environment.put(BALANCED_URL, balanced_url);
        }
        return environment;
    }

    private static String loadBalanceDispatcher(Hashtable disp) throws NamingException {
        if (disp.size() > 0) {
            Enumeration dispHosts = disp.keys();
            Enumeration ff = disp.keys();
            int alls = 0;
            while (ff.hasMoreElements()) {
                String sss = (String)ff.nextElement();
                String ss = (String)disp.get(sss);
                alls += Integer.parseInt(ss.trim());
            }
            String[] alldisp = new String[alls];
            int pos = 0;
            while (dispHosts.hasMoreElements()) {
                String ddd = (String)dispHosts.nextElement();
                int count = Integer.parseInt(((String)disp.get(ddd)).trim());
                int i = 0;
                while (i < count) {
                    alldisp[pos++] = ddd;
                    ++i;
                }
            }
            int balanced = (int)(Math.random() * (double)alldisp.length);
            return alldisp[balanced];
        }
        throw new NamingException(NamingException.UNABLE_TO_GET_CONNECTION_PARAMETERS, new Object[]{msg_host + NAMING_HOST_PORT_DELIM + msg_port, ""}, null);
    }

    private static Hashtable parseMSGFile(InputStream stream) throws NamingException {
        Hashtable<String, String> disp = new Hashtable<String, String>();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line);
                if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase(MESSAGE_SERVER_P4_PREFIX) || !tokenizer.hasMoreTokens()) continue;
                String hostName = tokenizer.nextToken().trim();
                if (!tokenizer.hasMoreTokens()) continue;
                String pport = tokenizer.nextToken().trim();
                if (!tokenizer.hasMoreTokens()) continue;
                String nextStr = tokenizer.nextToken().trim();
                int servers = 1;
                if (nextStr != null) {
                    int ii = nextStr.indexOf("=");
                    servers = ii != -1 ? Integer.parseInt(nextStr.substring(ii + 1)) : 1;
                }
                disp.put(hostName + NAMING_HOST_PORT_DELIM + pport, servers + "");
            }
        }
        catch (IOException ioe) {
            throw new NamingException(NamingException.MISSING_CONNECTION_PARAMETERS, new Object[]{msgSrvURL.toString(), ioe.toString()}, ioe);
        }
        return disp;
    }
}

