/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jndi;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.container.ApplicationContainerContext;
import com.sap.engine.frame.container.monitor.InterfaceMonitor;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.core.CoreContext;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.connector.ComponentExecutionContext;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.cross.CrossObjectFactory;
import com.sap.engine.interfaces.security.AuthenticationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.services.jndi.AppclientObjectFactory;
import com.sap.engine.services.jndi.ComponentObjectFactory;
import com.sap.engine.services.jndi.Constants;
import com.sap.engine.services.jndi.InitialContextFactoryImpl;
import com.sap.engine.services.jndi.InitialReplicatingContextFactoryImpl;
import com.sap.engine.services.jndi.JNDIContainerEventListener;
import com.sap.engine.services.jndi.JNDIManager;
import com.sap.engine.services.jndi.JNDIProxyImpl;
import com.sap.engine.services.jndi.NamingManager;
import com.sap.engine.services.jndi.PermissionAdministrator;
import com.sap.engine.services.jndi.ServiceReferenceImpl;
import com.sap.engine.services.jndi.cache.CacheCommunicator;
import com.sap.engine.services.jndi.cache.CacheCommunicatorImpl;
import com.sap.engine.services.jndi.cluster.SecurityBase;
import com.sap.engine.services.jndi.persistent.JNDILogConstants;
import com.sap.engine.services.jndi.persistent.JNDILogger;
import com.sap.engine.services.jndi.persistent.JNDIResourceAccessor;
import com.sap.engine.services.jndi.persistent.RemoteSerializator;
import com.sap.engine.services.jndi.persistent.SerializatorFactory;
import com.sap.engine.services.jndi.persistent.exceptions.JNDIException;
import com.sap.engine.services.jndi.persistent.exceptions.RuntimeExceptionConstants;
import com.sap.engine.services.jndi.persistentimpl.memory.JNDIMemoryImpl;
import com.sap.engine.services.jndi.providerimpl.DefaultResolver;
import com.sap.engine.services.jndi.shellcmd.ServCLUtils;
import com.sap.engine.system.naming.provider.Manager;
import com.sap.engine.system.naming.provider.ResolverManager;
import com.sap.localization.LocalizableText;
import com.sap.localization.LocalizableTextFormatter;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIFrame
implements ApplicationServiceFrame {
    private static ComponentExecutionContext appContext = null;
    private static CacheCommunicator cacheCommunicator;
    private static NamingManager naming;
    private static final String NAMING_SERVICE_NAME = "naming";
    public static String PROTOCOL_USED;
    private static ApplicationServiceContext sc;
    public static ApplicationContainerContext containerContext;
    public static ThreadSystem threadSystem;
    public static CrossInterface crossInterface;
    public static CoreContext coreContext;
    public static AuthenticationContext loginContext;
    public static SecurityContext namingSecurityContext;
    private static boolean isObjectRandomSelected;
    public static Location location;
    public static Category category;
    public static JNDILogger log;
    private JNDIContainerEventListener containerEventListener = null;
    static final int CLUSTER_LOCK = 13;
    static final int CLUSTER_UNLOCK = 14;
    private DefaultResolver resolver = null;

    public void start(ApplicationServiceContext _sc) throws ServiceException {
        sc = _sc;
        JNDIResourceAccessor.init(category, location);
        cacheCommunicator = new CacheCommunicatorImpl(sc);
        try {
            if (RemoteSerializator.serializatorFactory == null) {
                Class<?> factory = Class.forName("com.sap.engine.services.jndi.persistent.ServerSerializatorFactory");
                RemoteSerializator.serializatorFactory = (SerializatorFactory)factory.newInstance();
            }
            containerContext = _sc.getContainerContext();
            this.containerEventListener = new JNDIContainerEventListener(containerContext.getSystemMonitor().getService(NAMING_SERVICE_NAME).getProperties());
            int mask = 212;
            _sc.getServiceState().registerContainerEventListener(mask, null, this.containerEventListener);
            coreContext = _sc.getCoreContext();
            threadSystem = coreContext.getThreadSystem();
            try {
                Constants.lockTrials = Integer.parseInt(containerContext.getSystemMonitor().getService(NAMING_SERVICE_NAME).getProperty("LockTrials"));
                if (Constants.lockTrials < 1) {
                    Constants.lockTrials = 1;
                }
            }
            catch (Exception e) {
                log.logCatching(e);
                Constants.lockTrials = 3;
            }
            try {
                isObjectRandomSelected = "true".equals(containerContext.getSystemMonitor().getService(NAMING_SERVICE_NAME).getProperty("LookupLoadBalance"));
            }
            catch (Exception e) {
                log.logCatching(e);
                isObjectRandomSelected = false;
            }
            String temp = null;
            try {
                temp = containerContext.getSystemMonitor().getService(NAMING_SERVICE_NAME).getProperty("ReplicationMessageSize");
                if (temp != null) {
                    Constants.REPLICATION_MESSAGE_SIZE = Integer.parseInt(temp);
                }
            }
            catch (Exception e) {
                log.logCatching(e);
                temp = null;
            }
            naming = NamingManager.getNamingManager();
            ((JNDIManager)naming).setContainerContext(containerContext);
            ((JNDIManager)naming).setCommunicator((CacheCommunicatorImpl)cacheCommunicator);
            JNDIProxyImpl proxy = (JNDIProxyImpl)naming.start();
            crossInterface = (CrossInterface)containerContext.getObjectRegistry().getProvidedInterface("cross");
            crossInterface.setInitialObject(NAMING_SERVICE_NAME, proxy);
            CrossObjectFactory objectFactoryImpl = ((JNDIManager)naming).getObjectFactory();
            crossInterface.registerObjectFactory("RedirectableServerContext", objectFactoryImpl);
            this.initializeFactoryBuidler();
            this.bindReferences();
            ManagementInterface mi = this.getManagementInterface();
            if (mi == null && log.toLogWarningInLocation()) {
                log.warningT(JNDILogConstants.FAILED_TO_REGISTER_MANAGEMENT_INTERFACE);
            }
            _sc.getServiceState().registerManagementInterface(mi);
            this.performClusterLock();
            _sc.getContainerContext().getObjectRegistry().registerInterfaceProvider(NAMING_SERVICE_NAME, null);
        }
        catch (NamingException ne) {
            log.fatalT(JNDILogConstants.FAILED_TO_START_NAMING, new Object[]{ne.toString()});
            log.logCatching(ne);
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.FAIL_TO_START_NAMING, null);
            ServiceException se = new ServiceException((LocalizableText)formater, (Throwable)ne);
            log.logThrowable((Throwable)((Object)se));
            throw se;
        }
        catch (Exception e) {
            log.fatalT(JNDILogConstants.FAILED_TO_START_NAMING, new Object[]{e.toString()});
            log.logCatching(e);
            LocalizableTextFormatter formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.FAIL_TO_START_NAMING, null);
            ServiceException se = new ServiceException((LocalizableText)formater, (Throwable)e);
            log.logThrowable((Throwable)((Object)se));
            throw se;
        }
    }

    public synchronized void stop() {
        block5: {
            try {
                sc.getContainerContext().getObjectRegistry().unregisterInterfaceProvider(NAMING_SERVICE_NAME);
                naming.stop();
                naming = null;
                SecurityBase.getServerInfo();
                SecurityBase.close();
                JNDIProxyImpl.db = null;
                JNDIProxyImpl.rootObject = null;
                JNDIProxyImpl.jndiRootContainer = null;
                ServCLUtils.ctx = null;
                sc.getServiceState().unregisterContainerEventListener();
                sc.getClusterContext().getMessageContext().unregisterListener();
                sc.getServiceState().unregisterManagementInterface();
                this.containerEventListener.unregisterResources();
                sc.getServiceState().unregisterServiceEventListener();
                crossInterface.removeInitialObject(NAMING_SERVICE_NAME);
                log.logWarning(JNDILogConstants.NAMING_SERVICE_WAS_STOPPED);
                try {
                    ResolverManager resolverManager = (ResolverManager)Manager.getInstance();
                    resolverManager.unregisterResolver(this.resolver);
                    resolverManager.disableLogging();
                }
                catch (Exception e) {
                    if (log.toLogInfoInCategory()) {
                        log.infoT(JNDILogConstants.FAIL_TO_GET_NAMING_PROXY);
                        log.logCatching(e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.toLogWarningInLocation()) break block5;
                log.logWarning(RuntimeExceptionConstants.FAIL_TO_STOP_NAMING);
                log.logCatching(e);
            }
        }
    }

    public ManagementInterface getManagementInterface() {
        try {
            return new PermissionAdministrator();
        }
        catch (RemoteException e) {
            if (log.toLogPathInCategory()) {
                log.logPath(JNDILogConstants.FAILED_TO_INIT_PERMISSION_ADMINISTRATOR);
                log.logCatching(e);
            }
            return null;
        }
    }

    protected static ApplicationContainerContext getContainerContext() {
        return containerContext;
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        return false;
    }

    private void bindReferences() {
        block18: {
            try {
                int i;
                ServiceReferenceImpl[] interfaceRefs;
                ServiceReferenceImpl[] refs;
                Context jndi;
                block15: {
                    jndi = new InitialContext();
                    ServiceMonitor[] names = null;
                    InterfaceMonitor[] interfaceNames = null;
                    while (names == null || interfaceNames == null) {
                        names = containerContext.getSystemMonitor().getServices();
                        interfaceNames = containerContext.getSystemMonitor().getInterfaces();
                        Thread.currentThread();
                        Thread.yield();
                    }
                    refs = new ServiceReferenceImpl[names.length];
                    interfaceRefs = new ServiceReferenceImpl[interfaceNames.length];
                    try {
                        int i2 = 0;
                        while (i2 < refs.length) {
                            refs[i2] = new ServiceReferenceImpl(names[i2].getComponentName());
                            ++i2;
                        }
                        i = 0;
                        while (i < interfaceRefs.length) {
                            interfaceRefs[i] = new ServiceReferenceImpl(interfaceNames[i].getComponentName(), false);
                            ++i;
                        }
                    }
                    catch (RemoteException re) {
                        if (!log.toLogWarningInCategory()) break block15;
                        log.warningT(JNDILogConstants.FAILED_TO_BIND_SERVICE_REFERENCES);
                        log.logCatching(re);
                    }
                }
                String serviceName = "";
                i = 0;
                while (i < refs.length) {
                    block16: {
                        try {
                            jndi.rebind(refs[i].getServiceName(), (Object)refs[i]);
                            serviceName = refs[i].getServiceName();
                        }
                        catch (Exception e) {
                            if (!log.toLogWarningInCategory()) break block16;
                            log.warningT(JNDILogConstants.FAILED_TO_BIND_SERVICE_REFERENCE, new Object[]{serviceName});
                            log.logCatching(e);
                        }
                    }
                    ++i;
                }
                jndi = jndi.createSubcontext("interfaces");
                int i3 = 0;
                while (i3 < interfaceRefs.length) {
                    block17: {
                        String name = null;
                        try {
                            name = interfaceRefs[i3].getServiceName();
                            jndi.rebind(name, (Object)interfaceRefs[i3]);
                            int k = 0;
                            while (k < InterfaceMonitor.INTERFACE_NAMES.length) {
                                if (InterfaceMonitor.INTERFACE_NAMES[k].equals(name)) {
                                    jndi.rebind(InterfaceMonitor.INTERFACE_NAMES_API[k], (Object)interfaceRefs[i3]);
                                    break;
                                }
                                ++k;
                            }
                        }
                        catch (Exception e) {
                            if (!log.toLogWarningInCategory()) break block17;
                            log.warningT(JNDILogConstants.FAILED_TO_BIND_INTERFACE_REFERENCE, new Object[]{name});
                            log.logCatching(e);
                        }
                    }
                    ++i3;
                }
            }
            catch (NamingException e) {
                if (!log.toLogWarningInCategory()) break block18;
                log.warningT(JNDILogConstants.FAILED_TO_BIND_SERVICE_REFERENCES);
                log.logCatching(e);
            }
        }
    }

    public static CacheCommunicator getCacheCommunicator() {
        return cacheCommunicator;
    }

    public static CoreContext getCoreContext() {
        return coreContext;
    }

    public static ClassLoader getClassLoader(String name) {
        return coreContext.getLoadContext().getClassLoader(name);
    }

    public void initializeFactoryBuidler() {
        block9: {
            block7: {
                if (!javax.naming.spi.NamingManager.hasInitialContextFactoryBuilder()) {
                    try {
                        ResolverManager.init();
                    }
                    catch (Exception e) {
                        if (!log.toLogWarningInCategory()) break block7;
                        log.warningT(JNDILogConstants.FAIL_TO_GET_NAMING_PROXY);
                        log.logCatching(e);
                    }
                }
            }
            this.resolver = new DefaultResolver();
            DefaultResolver.addInitialContextFactoryImpl(new InitialContextFactoryImpl());
            DefaultResolver.addInitialContextFactoryImpl(new InitialReplicatingContextFactoryImpl());
            DefaultResolver.addObjectFactoryImpl(new AppclientObjectFactory());
            DefaultResolver.addObjectFactoryImpl(new ComponentObjectFactory());
            try {
                ResolverManager resolverManager;
                block8: {
                    resolverManager = (ResolverManager)Manager.getInstance();
                    try {
                        resolverManager.setLogger(log);
                    }
                    catch (Exception e) {
                        if (!log.toLogPathInLocation()) break block8;
                        log.logCatching(e);
                    }
                }
                resolverManager.registerResolver(this.resolver);
            }
            catch (NamingException e) {
                if (!log.toLogWarningInCategory()) break block9;
                log.warningT(JNDILogConstants.FAIL_TO_GET_NAMING_PROXY);
                log.logCatching(e);
            }
        }
    }

    public void testJNDI() {
        try {
            InitialContext ctx = new InitialContext();
            ctx.rebind("testjndi", (Object)"[JNDI] Testing jndi ... done");
            System.out.println(ctx.lookup("testjndi").toString());
            long t = System.currentTimeMillis();
            InitialContext cx = null;
            int i = 0;
            while (i < 1000) {
                cx = new InitialContext();
                ++i;
            }
            System.out.println("[JNDI] " + 1000000L / (System.currentTimeMillis() - t) + " InitialContexts/sec. ");
            cx = new InitialContext();
            t = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < 1000) {
                cx.lookup("testjndi");
                ++i2;
            }
            System.out.println("[JNDI] " + 1000000L / (System.currentTimeMillis() - t) + " lookup/sec. ");
        }
        catch (Exception e) {
            System.out.println("  Exception during testing ");
            log.logThrowable(e);
        }
    }

    public static boolean isObjectRandomSelected() {
        return isObjectRandomSelected;
    }

    protected static boolean isAppContextAvailable() {
        return appContext != null;
    }

    protected static void setAppContextProvider(ComponentExecutionContext appContext) {
        JNDIFrame.appContext = appContext;
    }

    protected static ComponentExecutionContext getAppContextProvider() {
        return appContext;
    }

    static void initializeSecurity() throws ServiceException {
        block13: {
            SecurityContext newSecurityContext = (SecurityContext)sc.getContainerContext().getObjectRegistry().getServiceInterface("security");
            boolean success = false;
            Exception exception = null;
            int i = 0;
            while (i < Constants.lockTrials) {
                try {
                    namingSecurityContext = newSecurityContext.getPolicyConfigurationContext("service.naming");
                    if (namingSecurityContext != null) {
                        success = true;
                        break;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException ie) {
                        success = false;
                    }
                }
                catch (Exception e) {
                    log.logCatching(e);
                    exception = e;
                }
                ++i;
            }
            if (!success) {
                LocalizableTextFormatter formater;
                if (exception == null) {
                    if (log.toLogWarningInCategory()) {
                        log.warningT(RuntimeExceptionConstants.POLICY_CONFIGURATION_IS_NULL);
                    }
                    formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.POLICY_CONFIGURATION_IS_NULL, null);
                    ServiceException se = new ServiceException((LocalizableText)formater);
                    log.logThrowable((Throwable)((Object)se));
                    loginContext = null;
                    SecurityBase.WITHOUT_SECURITY = true;
                    throw se;
                }
                if (log.toLogWarningInCategory()) {
                    log.warningT(RuntimeExceptionConstants.FAIL_TO_GET_POLICY_CONFIGURATION);
                }
                formater = new LocalizableTextFormatter(JNDIResourceAccessor.getResourceAccessor(), RuntimeExceptionConstants.FAIL_TO_GET_POLICY_CONFIGURATION, null);
                ServiceException se = new ServiceException((LocalizableText)formater, (Throwable)exception);
                log.logThrowable((Throwable)((Object)se));
                loginContext = null;
                SecurityBase.WITHOUT_SECURITY = true;
                throw se;
            }
            loginContext = newSecurityContext.getAuthenticationContext();
            try {
                SecurityBase.WITHOUT_SECURITY = false;
                new SecurityBase(sc);
                if (log.toLogPathInCategory()) {
                    log.logPath(JNDILogConstants.SECURITY_CHECKS_ENABLED);
                }
            }
            catch (JNDIException e) {
                loginContext = null;
                SecurityBase.WITHOUT_SECURITY = true;
                if (!log.toLogWarningInCategory()) break block13;
                log.warningT(JNDILogConstants.SECURITY_CHECKS_DISABLED);
                log.logCatching((Throwable)((Object)e));
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performClusterLock() {
        ma = null;
        lockPerformedOk = false;
        do {
            block7: {
                block9: {
                    block8: {
                        if ((ma = ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).sendToAllAndWaitForAnswer(new byte[0], 13, 0)) == null) return;
                        servers = this.checkAnswers(ma);
                        if (servers == null) break block7;
                        if (servers.size() == 0) break block8;
                        answer = null;
                        clusterId = -1;
                        do {
                            clusterId = servers.lastElement();
                            servers.removeLastElement();
                        } while ((answer = ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).sendToServerAndWaitForAnswer(clusterId, new byte[0], 11, 0)) == null && servers.size() != 0);
                        if (answer == null || (replicationPassCount = Convert.byteArrToInt(count = answer.getMessage(), 0)) <= 0) break block9;
                        var9_9 = repCount = ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).replicationCounter;
                        synchronized (var9_9) {
                            if (true) ** GOTO lbl30
                        }
                    }
                    ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).setReplicationCompleted(true);
                    ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).sendToAllAndWaitForAnswer(new byte[0], 14, 0);
                    return;
                    {
                        do {
                            try {
                                repCount.wait();
                            }
                            catch (InterruptedException e) {
                                JNDIFrame.log.logCatching(e);
                            }
lbl30:
                            // 3 sources

                        } while (repCount.getValue() < replicationPassCount);
                    }
                }
                ((JNDIMemoryImpl)JNDIManager.db).initIDGenerator();
                ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).setReplicationCompleted(true);
                ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).sendToAllAndWaitForAnswer(new byte[0], 14, 0);
                return;
            }
            ((CacheCommunicatorImpl)JNDIFrame.cacheCommunicator).sendToAllAndWaitForAnswer(new byte[0], 14, 0);
        } while (!lockPerformedOk);
    }

    private ArrayInt checkAnswers(MultipleAnswer ma) {
        int thisClusterId = sc.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        int localIdPrefix = thisClusterId / 100;
        ArrayInt localServers = new ArrayInt();
        int[] servers = ma.participants();
        ArrayInt readyServers = new ArrayInt();
        int i = 0;
        while (i < servers.length) {
            try {
                byte[] answer = ma.getAnswer(servers[i]).getMessage();
                int result = Convert.byteArrToInt(answer, 0);
                if (result == 0) {
                    if (localIdPrefix == servers[i] / 100) {
                        localServers.add(servers[i]);
                    } else {
                        readyServers.add(servers[i]);
                    }
                } else if (result == 1) {
                    return null;
                }
            }
            catch (ClusterException e) {
                log.logCatching((Throwable)((Object)e));
            }
            ++i;
        }
        readyServers.addAll(localServers);
        return readyServers;
    }

    static {
        naming = null;
        PROTOCOL_USED = "p4";
        sc = null;
        containerContext = null;
        threadSystem = null;
        crossInterface = null;
        coreContext = null;
        loginContext = null;
        namingSecurityContext = null;
        isObjectRandomSelected = false;
        location = Location.getLocation((String)JNDIResourceAccessor.LOCATION_PATH);
        category = Category.getCategory((String)"/System/Server");
        log = new JNDILogger(location, category);
    }
}

